/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.BusinessArea;
import org.fenixedu.academic.domain.ContractType;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.JobApplicationType;
import org.fenixedu.academic.domain.JobBean;
import org.fenixedu.academic.domain.Job_Base;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.alumni.AlumniJobBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class Job
extends Job_Base {
    public static final Comparator<Job> REVERSE_COMPARATOR_BY_BEGIN_DATE = new Comparator<Job>(){

        @Override
        public int compare(Job o1, Job o2) {
            if (o2.getBeginDate() != null && o1.getBeginDate() != null) {
                return o2.getBeginDate().compareTo((ReadablePartial)o1.getBeginDate());
            }
            return o2.getBeginDate() != null ? 1 : -1;
        }
    };

    private Job() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setLastModifiedDate(new DateTime());
    }

    public Job(Person person, String employerName, String city, Country country, BusinessArea businessArea, BusinessArea parentBusinessArea, String position, LocalDate beginDate, LocalDate endDate, JobApplicationType applicationType, ContractType contractType, Double salary) {
        this();
        this.checkParameters(person, employerName, city, country, businessArea, parentBusinessArea, position, beginDate, endDate, applicationType, contractType, salary);
        this.checkValidDates(beginDate, endDate);
        this.setPerson(person);
        this.setEmployerName(employerName);
        this.setCity(city);
        this.setCountry(country);
        this.setBusinessArea(businessArea);
        this.setParentBusinessArea(parentBusinessArea);
        this.setPosition(position);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setJobApplicationType(applicationType);
        this.setContractType(contractType);
        this.setSalary(salary);
    }

    public void edit(AlumniJobBean jobBean) {
        this.checkParameters(jobBean.getEmployerName(), jobBean.getCity(), jobBean.getCountry(), jobBean.getChildBusinessArea(), jobBean.getParentBusinessArea(), jobBean.getPosition(), jobBean.getBeginDateAsLocalDate(), jobBean.getEndDateAsLocalDate(), jobBean.getApplicationType(), jobBean.getContractType(), jobBean.getSalary());
        this.setEmployerName(jobBean.getEmployerName());
        this.setCity(jobBean.getCity());
        this.setCountry(jobBean.getCountry());
        this.setBusinessArea(jobBean.getChildBusinessArea());
        this.setParentBusinessArea(jobBean.getParentBusinessArea());
        this.setPosition(jobBean.getPosition());
        this.setBeginDate(jobBean.getBeginDateAsLocalDate());
        this.setEndDate(jobBean.getEndDateAsLocalDate());
        this.setJobApplicationType(jobBean.getApplicationType());
        this.setContractType(jobBean.getContractType());
        this.setSalary(jobBean.getSalary());
        this.setLastModifiedDate(new DateTime());
    }

    private void checkParameters(Person person, String employerName, String city, Country country, BusinessArea businessArea, BusinessArea parentBusinessArea, String position, LocalDate beginDate, LocalDate endDate, JobApplicationType applicationType, ContractType contractType, Double salary) {
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("job.creation.person.null", args);
        }
        this.checkParameters(employerName, city, country, businessArea, parentBusinessArea, position, beginDate, endDate, applicationType, contractType, salary);
    }

    private void checkParameters(String employerName, String city, Country country, BusinessArea businessArea, BusinessArea parentBusinessArea, String position, LocalDate beginDate, LocalDate endDate, JobApplicationType applicationType, ContractType contractType, Double salary) {
        if (StringUtils.isEmpty((String)employerName) && StringUtils.isEmpty((String)city) && country == null && businessArea == null && parentBusinessArea == null && StringUtils.isEmpty((String)position) && beginDate == null && endDate == null && applicationType == null && contractType == null && salary == null) {
            throw new DomainException("job.creation.allFields.null", new String[0]);
        }
    }

    private void checkParameters(Person person, String employerName, String city, Country country, BusinessArea businessArea, String position) {
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("job.creation.person.null", args);
        }
        String[] args1 = new String[]{};
        if (country == null) {
            throw new DomainException("job.creation.country.null", args1);
        }
        String[] args2 = new String[]{};
        if (businessArea == null) {
            throw new DomainException("job.creation.businessArea.null", args2);
        }
        String[] args3 = new String[]{};
        if (employerName == null || employerName.isEmpty()) {
            throw new DomainException("job.creation.employerName.null", args3);
        }
        String[] args4 = new String[]{};
        if (city == null || city.isEmpty()) {
            throw new DomainException("job.creation.city.null", args4);
        }
        String[] args5 = new String[]{};
        if (position == null || position.isEmpty()) {
            throw new DomainException("job.creation.position.null", args5);
        }
    }

    private void checkDates(LocalDate beginDate, LocalDate endDate) {
        if (beginDate == null) {
            throw new DomainException("job.creation.beginDate.null", new String[0]);
        }
        this.checkValidDates(beginDate, endDate);
    }

    private void checkValidDates(LocalDate beginDate, LocalDate endDate) {
        if (beginDate != null && endDate != null && beginDate.isAfter((ReadablePartial)endDate)) {
            throw new DomainException("job.creation.beginDate.after.endDate", new String[0]);
        }
    }

    public Job(Person person, JobBean bean) {
        this();
        this.checkParameters(person, bean.getEmployerName(), bean.getCity(), bean.getCountry(), bean.getChildBusinessArea(), bean.getPosition());
        this.checkDates(bean.getBeginDate(), bean.getEndDate());
        this.setPerson(person);
        this.setBusinessArea(bean.getChildBusinessArea());
        this.setParentBusinessArea(bean.getParentBusinessArea());
        this.setEmployerName(bean.getEmployerName());
        this.setCity(bean.getCity());
        this.setPosition(bean.getPosition());
        this.setBeginDate(bean.getBeginDate());
        this.setEndDate(bean.getEndDate());
        this.setCountry(bean.getCountry());
    }

    public void delete() {
        this.setPerson(null);
        this.setCreator(null);
        this.setCountry(null);
        this.setBusinessArea(null);
        this.setParentBusinessArea(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

