/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=RAMApplication.RAMSchedulesApp.class, path="view-all-class-schedules", titleKey="link.schedules.listAllByClass")
@Mapping(path="/viewAllClassesSchedulesDA", module="resourceAllocationManager")
@Forwards(value={@Forward(name="choose", path="/resourceAllocationManager/chooseDegreesToViewClassesSchedules.jsp"), @Forward(name="list", path="/resourceAllocationManager/viewAllClassesSchedules.jsp")})
public class ViewAllClassesSchedulesDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward choose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChooseExecutionDegreeBean bean = (ChooseExecutionDegreeBean)this.getRenderedObject();
        if (bean == null) {
            bean = new ChooseExecutionDegreeBean();
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("choose");
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChooseExecutionDegreeBean bean = (ChooseExecutionDegreeBean)this.getRenderedObject();
        request.setAttribute("academicInterval", (Object)bean.getAcademicInterval());
        request.setAttribute("degrees", bean.getDegrees());
        return mapping.findForward("list");
    }

    public static class ChooseExecutionDegreeBean
    implements Serializable {
        private static final long serialVersionUID = -663198492313971329L;
        private AcademicInterval academicInterval = AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER);
        private List<ExecutionDegree> selectedDegrees;

        public AcademicInterval getAcademicInterval() {
            return this.academicInterval;
        }

        public void setAcademicInterval(AcademicInterval academicInterval) {
            this.academicInterval = academicInterval;
        }

        public List<ExecutionDegree> getDegrees() {
            return this.selectedDegrees;
        }

        public void setDegrees(List<ExecutionDegree> degrees) {
            this.selectedDegrees = degrees;
        }

        public List<ExecutionDegree> getAvailableDegrees() {
            ArrayList<ExecutionDegree> degrees = new ArrayList<ExecutionDegree>(ExecutionDegree.filterByAcademicInterval(this.academicInterval));
            Collections.sort(degrees, ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
            return degrees;
        }

        public List<AcademicInterval> getAvailableIntervals() {
            return Ordering.from(AcademicInterval.COMPARATOR_BY_BEGIN_DATE).reverse().sortedCopy(AcademicInterval.readAcademicIntervals(AcademicPeriod.SEMESTER));
        }
    }
}

