/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.person;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.person.UpdateEmergencyContactDA;
import org.fenixedu.academic.ui.struts.action.person.VisualizePersonalInfo;
import org.fenixedu.bennu.core.domain.UserProfile;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(module="person", path="/updateNickname", functionality=VisualizePersonalInfo.class)
@Forwards(value={@Forward(name="visualizePersonalInformation", path="/person/visualizePersonalInfo.jsp")})
public class UpdateNicknameDA
extends FenixDispatchAction {
    public ActionForward updateNickname(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PersonBean personBean = (PersonBean)this.getRenderedObject("nickname");
        Person person = this.getLoggedPerson(request);
        UpdateEmergencyContactDA.EmergencyContactBean emergencyContactBean = new UpdateEmergencyContactDA.EmergencyContactBean(person);
        try {
            this.atomic(() -> {
                UserProfile profile = person.getProfile();
                profile.changeName(profile.getGivenNames(), profile.getFamilyNames(), personBean.getNickname());
            });
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey());
            request.setAttribute("personBean", (Object)new PersonBean(person));
            request.setAttribute("emergencyContactBean", (Object)new UpdateEmergencyContactDA.EmergencyContactBean(person));
        }
        catch (BennuCoreDomainException be) {
            this.addActionMessage(request, be.getLocalizedMessage(), false);
            request.setAttribute("personBean", (Object)new PersonBean(person));
            request.setAttribute("emergencyContactBean", (Object)new UpdateEmergencyContactDA.EmergencyContactBean(person));
        }
        request.setAttribute("personBean", (Object)personBean);
        request.setAttribute("emergencyContactBean", (Object)emergencyContactBean);
        return mapping.findForward("visualizePersonalInformation");
    }
}

