/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.thesis;

import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;

public class ManageThesisContext
implements Serializable {
    private ExecutionDegree executionDegree = null;

    public ManageThesisContext(ExecutionDegree executionDegree) {
        this.setExecutionDegree(executionDegree);
    }

    public ExecutionDegree getExecutionDegree() {
        return this.executionDegree;
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        this.executionDegree = executionDegree;
    }

    public ExecutionDegree getPreviousExecutionDegree() {
        ExecutionYear executionYear;
        ExecutionYear previousExecutionYear;
        ExecutionDegree executionDegree = this.getExecutionDegree();
        if (executionDegree != null && (previousExecutionYear = (executionYear = executionDegree.getExecutionYear()).getPreviousExecutionYear()) != null) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            for (ExecutionDegree otherExecutionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (otherExecutionDegree.getExecutionYear() != previousExecutionYear) continue;
                return otherExecutionDegree;
            }
        }
        return null;
    }

    public SortedSet<ExecutionDegree> getAvailableExecutionDegrees() {
        TreeSet<ExecutionDegree> executionDegrees = new TreeSet<ExecutionDegree>(ExecutionDegree.REVERSE_EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
        ExecutionDegree executionDegree = this.getExecutionDegree();
        if (executionDegree != null) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            executionDegrees.addAll(degreeCurricularPlan.getExecutionDegreesSet());
        }
        return executionDegrees;
    }
}

