/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import org.joda.time.Interval;

public class CourseLoadOverviewBean
implements Serializable {
    private ExecutionSemester executionSemester;
    private static final BigDecimal MILIS_TO_HOURS_DIVOSOR = new BigDecimal(3600000);

    public CourseLoadOverviewBean(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public CourseLoadOverviewBean() {
        this(ExecutionSemester.readActualExecutionSemester());
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public StyledExcelSpreadsheet getInconsistencySpreadsheet() {
        StyledExcelSpreadsheet spreadsheet = new StyledExcelSpreadsheet(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.course.load.inconsistency.filename", (String[])new String[0]) + "_" + this.executionSemester.getExecutionYear().getYear().replace('/', '_') + "_" + this.executionSemester.getSemester());
        HSSFCellStyle normalStyle = spreadsheet.getExcelStyle().getValueStyle();
        normalStyle.setAlignment((short)2);
        HSSFWorkbook wb = spreadsheet.getWorkbook();
        HSSFFont font = wb.createFont();
        font.setColor((short)8);
        font.setFontHeightInPoints((short)8);
        HSSFCellStyle redStyle = wb.createCellStyle();
        redStyle.setFont(font);
        redStyle.setAlignment((short)2);
        redStyle.setFillForegroundColor((short)53);
        redStyle.setFillPattern((short)1);
        HSSFCellStyle yellowStyle = wb.createCellStyle();
        yellowStyle.setFont(font);
        yellowStyle.setAlignment((short)2);
        yellowStyle.setFillForegroundColor((short)13);
        yellowStyle.setFillPattern((short)1);
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.department", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.degree", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.executionCourse", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.shift", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.shiftType", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.load.competenceCourse", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.load.curricularCourse", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.load.executionCourse", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.load.lessonInstances", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.load.lesson.count", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.load.lessonInstances.count", (String[])new String[0]));
        for (ExecutionCourse executionCourse : this.executionSemester.getAssociatedExecutionCoursesSet()) {
            for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
                for (Shift shift : courseLoad.getShiftsSet()) {
                    spreadsheet.newRow();
                    spreadsheet.addCell(this.getDepartmentString(executionCourse));
                    spreadsheet.addCell((Object)executionCourse.getDegreePresentationString());
                    spreadsheet.addCell((Object)executionCourse.getName());
                    spreadsheet.addCell((Object)shift.getNome());
                    spreadsheet.addCell((Object)courseLoad.getType().getFullNameTipoAula());
                    BigDecimal competenceCourseLoad = new BigDecimal(this.getCompetenceCourseLoad(courseLoad)).setScale(2, RoundingMode.HALF_EVEN);
                    BigDecimal curricularCourseLoad = new BigDecimal(this.getCurricularCourseLoad(courseLoad)).setScale(2, RoundingMode.HALF_EVEN);
                    BigDecimal executionLoad = courseLoad.getTotalQuantity().setScale(2, RoundingMode.HALF_EVEN);
                    BigDecimal shiftCourseLoad = this.getShiftCourseLoad(shift).setScale(2, RoundingMode.HALF_EVEN);
                    if (competenceCourseLoad.signum() < 0) {
                        spreadsheet.addCell((Object)this.getCompetenceCourseLoadStrings(courseLoad), redStyle);
                    } else {
                        spreadsheet.addCell((Object)competenceCourseLoad);
                    }
                    if (!competenceCourseLoad.equals(curricularCourseLoad) || curricularCourseLoad.signum() < 0) {
                        spreadsheet.addCell((Object)this.getCurricularCourseLoadString(courseLoad), redStyle);
                    } else {
                        spreadsheet.addCell((Object)curricularCourseLoad);
                    }
                    if (!executionLoad.equals(curricularCourseLoad)) {
                        spreadsheet.addCell((Object)executionLoad, redStyle);
                    } else {
                        spreadsheet.addCell((Object)executionLoad);
                    }
                    if (!shiftCourseLoad.equals(executionLoad)) {
                        if (this.isLargeDifference(shiftCourseLoad, executionLoad, competenceCourseLoad.divide(new BigDecimal(14), 2, RoundingMode.HALF_EVEN))) {
                            spreadsheet.addCell((Object)shiftCourseLoad, redStyle);
                        } else {
                            spreadsheet.addCell((Object)shiftCourseLoad, yellowStyle);
                        }
                    } else {
                        spreadsheet.addCell((Object)shiftCourseLoad);
                    }
                    spreadsheet.addCell((Object)shift.getAssociatedLessonsSet().size());
                    spreadsheet.addCell((Object)this.getLessonInstanceCount(shift));
                }
            }
        }
        HSSFSheet sheet = wb.getSheetAt(0);
        sheet.createFreezePane(0, 1, 0, 1);
        sheet.autoSizeColumn(1, true);
        sheet.autoSizeColumn(2, true);
        sheet.autoSizeColumn(3, true);
        sheet.autoSizeColumn(4, true);
        sheet.autoSizeColumn(5, true);
        sheet.autoSizeColumn(6, true);
        sheet.autoSizeColumn(7, true);
        sheet.autoSizeColumn(8, true);
        sheet.autoSizeColumn(9, true);
        return spreadsheet;
    }

    private boolean isLargeDifference(BigDecimal value1, BigDecimal value2, BigDecimal unitValue) {
        return value1.subtract(value2).abs().compareTo(unitValue) > 0;
    }

    private String getCompetenceCourseLoadStrings(CourseLoad courseLoad) {
        return this.getCurricularCourseLoadString(courseLoad);
    }

    private double getCompetenceCourseLoad(CourseLoad courseLoad) {
        return this.getCurricularCourseLoad(courseLoad);
    }

    private String getCurricularCourseLoadString(CourseLoad courseLoad) {
        ShiftType shiftType = courseLoad.getType();
        HashSet<Double> ds = new HashSet<Double>();
        for (CurricularCourse curricularCourse : courseLoad.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            double curricularCourseLoad = this.getCurricularCourseLoad(curricularCourse, shiftType);
            ds.add(new Double(curricularCourseLoad * 14.0));
        }
        StringBuilder builder = new StringBuilder();
        for (Double d : ds) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(d);
        }
        return builder.toString();
    }

    private double getCurricularCourseLoad(CourseLoad courseLoad) {
        ShiftType shiftType = courseLoad.getType();
        double result = -1.0;
        for (CurricularCourse curricularCourse : courseLoad.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            double curricularCourseLoad = this.getCurricularCourseLoad(curricularCourse, shiftType);
            if (result == -1.0 || result == curricularCourseLoad) {
                result = curricularCourseLoad;
                continue;
            }
            if (result == -1.0 || result == curricularCourseLoad) continue;
            return -1.0;
        }
        return result * 14.0;
    }

    private double getCurricularCourseLoad(CurricularCourse curricularCourse, ShiftType shiftType) {
        if (shiftType == ShiftType.FIELD_WORK) {
            return curricularCourse.getFieldWorkHours(this.executionSemester);
        }
        if (shiftType == ShiftType.LABORATORIAL) {
            return curricularCourse.getLaboratorialHours(this.executionSemester);
        }
        if (shiftType == ShiftType.PRATICA) {
            // empty if block
        }
        if (shiftType == ShiftType.PROBLEMS) {
            return curricularCourse.getProblemsHours(this.executionSemester);
        }
        if (shiftType == ShiftType.SEMINARY) {
            return curricularCourse.getSeminaryHours(this.executionSemester);
        }
        if (shiftType == ShiftType.TEORICA) {
            return curricularCourse.getTheoreticalHours(this.executionSemester);
        }
        if (shiftType == ShiftType.TEORICO_PRATICA) {
            // empty if block
        }
        if (shiftType == ShiftType.TRAINING_PERIOD) {
            return curricularCourse.getTrainingPeriodHours(this.executionSemester);
        }
        if (shiftType == ShiftType.TUTORIAL_ORIENTATION) {
            return curricularCourse.getTutorialOrientationHours(this.executionSemester);
        }
        return 0.0;
    }

    private BigDecimal getShiftCourseLoad(Shift shift) {
        BigDecimal result = BigDecimal.ZERO;
        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
            for (Interval interval : lesson.getAllLessonIntervals()) {
                BigDecimal duration = new BigDecimal(interval.toDurationMillis());
                result = result.add(duration.divide(MILIS_TO_HOURS_DIVOSOR));
            }
        }
        return result;
    }

    private Integer getLessonInstanceCount(Shift shift) {
        int result = 0;
        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
            result += lesson.getAllLessonIntervals().size();
        }
        return result;
    }

    private Object getDepartmentString(ExecutionCourse executionCourse) {
        StringBuilder builder = new StringBuilder();
        for (Department department : executionCourse.getDepartments()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(department.getAcronym());
        }
        return builder.toString();
    }
}

