/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.ObjectLinkRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class ConditionalObjectLinkRenderer
extends ObjectLinkRenderer {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalObjectLinkRenderer.class);
    private String visibleIf;

    public String getVisibleIf() {
        return this.visibleIf;
    }

    public void setVisibleIf(String visibleIf) {
        this.visibleIf = visibleIf;
    }

    protected Layout getLayout(Object object, Class type) {
        final Layout layout = super.getLayout(object, type);
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                Boolean visible = Boolean.FALSE;
                try {
                    visible = (Boolean)RendererPropertyUtils.getProperty((Object)ConditionalObjectLinkRenderer.this.getTargetObject(object), (String)ConditionalObjectLinkRenderer.this.getVisibleIf(), (boolean)false);
                }
                catch (ClassCastException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (visible.booleanValue()) {
                    return layout.createComponent(object, type);
                }
                String text = ConditionalObjectLinkRenderer.this.getText();
                return text != null ? new HtmlText(text) : ConditionalObjectLinkRenderer.this.renderValue(object, RenderKit.getInstance().findSchema(ConditionalObjectLinkRenderer.this.getSubSchema()), ConditionalObjectLinkRenderer.this.getSubLayout());
            }
        };
    }
}

