/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.service.filter.CoordinatorExecutionDegreeAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.SearchExecutionCourses$callable$runSearchExecutionCourses;
import org.fenixedu.academic.service.services.resourceAllocationManager.SearchExecutionCourses$callable$runSearchExecutionCourses$1;
import org.fenixedu.academic.service.services.resourceAllocationManager.SearchExecutionCourses$callable$runSearchExecutionCourses$2;
import org.fenixedu.academic.util.NumberUtils;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SearchExecutionCourses {
    private static final SearchExecutionCourses serviceInstance;
    public static final Advice advice$runSearchExecutionCourses;
    public static final Advice advice$runSearchExecutionCourses$1;
    public static final Advice advice$runSearchExecutionCourses$2;

    public List<InfoExecutionCourse> run(AcademicInterval academicInterval, ExecutionDegree executionDegree, String courseName) {
        List<ExecutionCourse> executionCourses = ExecutionCourse.searchByAcademicIntervalAndExecutionDegreeYearAndName(academicInterval, executionDegree, null, courseName);
        return this.fillInfoExecutionCourses(academicInterval, executionCourses);
    }

    public List<InfoExecutionCourse> run(AcademicInterval academicInterval, ExecutionDegree executionDegree, CurricularYear curricularYear, String courseName) {
        List<ExecutionCourse> executionCourses = ExecutionCourse.searchByAcademicIntervalAndExecutionDegreeYearAndName(academicInterval, executionDegree, curricularYear, courseName);
        return this.fillInfoExecutionCourses(academicInterval, executionCourses);
    }

    public List<InfoExecutionCourse> run(InfoExecutionPeriod infoExecutionPeriod, InfoExecutionDegree infoExecutionDegree, InfoCurricularYear infoCurricularYear, String executionCourseName) {
        Object result = null;
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)infoExecutionPeriod.getExternalId());
        ExecutionDegree executionDegree = null;
        if (infoExecutionDegree != null) {
            executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)infoExecutionDegree.getExternalId());
        }
        CurricularYear curricularYear = null;
        if (infoCurricularYear != null) {
            curricularYear = (CurricularYear)FenixFramework.getDomainObject((String)infoCurricularYear.getExternalId());
        }
        List<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        if (executionSemester != null) {
            executionCourses = executionSemester.getExecutionCoursesByDegreeCurricularPlanAndSemesterAndCurricularYearAndName(executionDegree.getDegreeCurricularPlan(), curricularYear, executionCourseName);
        }
        return this.fillInfoExecutionCourses(executionSemester.getAcademicInterval(), executionCourses);
    }

    private List<InfoExecutionCourse> fillInfoExecutionCourses(AcademicInterval academicInterval, List<ExecutionCourse> executionCourses) {
        List result = (List)CollectionUtils.collect(executionCourses, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                InfoExecutionCourse infoExecutionCourse = null;
                infoExecutionCourse = this.getOccupancyLevels(arg0);
                return infoExecutionCourse;
            }

            private InfoExecutionCourse getOccupancyLevels(Object arg0) {
                ExecutionCourse executionCourse = (ExecutionCourse)((Object)arg0);
                Integer theoreticalCapacity = 0;
                Integer theoPraticalCapacity = 0;
                Integer praticalCapacity = 0;
                Integer labCapacity = 0;
                Integer doubtsCapacity = 0;
                Integer reserveCapacity = 0;
                Integer semCapacity = 0;
                Integer probCapacity = 0;
                Integer fieldCapacity = 0;
                Integer trainCapacity = 0;
                Integer tutCapacity = 0;
                Set<Shift> shifts = executionCourse.getAssociatedShifts();
                for (Shift shift : shifts) {
                    if (shift.containsType(ShiftType.TEORICA)) {
                        theoreticalCapacity = theoreticalCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.TEORICO_PRATICA)) {
                        theoPraticalCapacity = theoPraticalCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.DUVIDAS)) {
                        doubtsCapacity = doubtsCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.LABORATORIAL)) {
                        labCapacity = labCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.PRATICA)) {
                        praticalCapacity = praticalCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.RESERVA)) {
                        reserveCapacity = reserveCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.SEMINARY)) {
                        semCapacity = semCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.PROBLEMS)) {
                        probCapacity = probCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.FIELD_WORK)) {
                        fieldCapacity = fieldCapacity + shift.getLotacao();
                        continue;
                    }
                    if (shift.containsType(ShiftType.TRAINING_PERIOD)) {
                        trainCapacity = trainCapacity + shift.getLotacao();
                        continue;
                    }
                    if (!shift.containsType(ShiftType.TUTORIAL_ORIENTATION)) continue;
                    tutCapacity = tutCapacity + shift.getLotacao();
                }
                InfoExecutionCourse infoExecutionCourse = InfoExecutionCourse.newInfoFromDomain(executionCourse);
                ArrayList<Integer> capacities = new ArrayList<Integer>();
                if (theoreticalCapacity != 0) {
                    capacities.add(theoreticalCapacity);
                }
                if (theoPraticalCapacity != 0) {
                    capacities.add(theoPraticalCapacity);
                }
                if (doubtsCapacity != 0) {
                    capacities.add(doubtsCapacity);
                }
                if (labCapacity != 0) {
                    capacities.add(labCapacity);
                }
                if (praticalCapacity != 0) {
                    capacities.add(praticalCapacity);
                }
                if (reserveCapacity != 0) {
                    capacities.add(reserveCapacity);
                }
                if (semCapacity != 0) {
                    capacities.add(semCapacity);
                }
                if (probCapacity != 0) {
                    capacities.add(probCapacity);
                }
                if (fieldCapacity != 0) {
                    capacities.add(fieldCapacity);
                }
                if (trainCapacity != 0) {
                    capacities.add(trainCapacity);
                }
                if (tutCapacity != 0) {
                    capacities.add(tutCapacity);
                }
                int total = 0;
                if (!capacities.isEmpty()) {
                    total = (Integer)Collections.min(capacities);
                }
                if (total == 0) {
                    infoExecutionCourse.setOccupancy(-1.0);
                } else {
                    infoExecutionCourse.setOccupancy(NumberUtils.formatNumber(Double.valueOf(Double.valueOf(executionCourse.getAttendsSet().size()).floatValue() * 100.0f / (float)total), 1));
                }
                return infoExecutionCourse;
            }
        });
        return result;
    }

    public static List<InfoExecutionCourse> runSearchExecutionCourses(AcademicInterval academicInterval, ExecutionDegree executionDegree, String string) throws NotAuthorizedException {
        return (List)advice$runSearchExecutionCourses.perform((Callable)new SearchExecutionCourses$callable$runSearchExecutionCourses(academicInterval, executionDegree, string));
    }

    static /* synthetic */ List<InfoExecutionCourse> advised$runSearchExecutionCourses(AcademicInterval academicInterval, ExecutionDegree executionDegree, String courseName) throws NotAuthorizedException {
        CoordinatorExecutionDegreeAuthorizationFilter.instance.execute(executionDegree.getExternalId());
        return serviceInstance.run(academicInterval, executionDegree, courseName);
    }

    public static List<InfoExecutionCourse> runSearchExecutionCourses(InfoExecutionPeriod infoExecutionPeriod, InfoExecutionDegree infoExecutionDegree, InfoCurricularYear infoCurricularYear, String string) throws NotAuthorizedException {
        return (List)advice$runSearchExecutionCourses$1.perform((Callable)new SearchExecutionCourses$callable$runSearchExecutionCourses$1(infoExecutionPeriod, infoExecutionDegree, infoCurricularYear, string));
    }

    static /* synthetic */ List<InfoExecutionCourse> advised$runSearchExecutionCourses(InfoExecutionPeriod infoExecutionPeriod, InfoExecutionDegree infoExecutionDegree, InfoCurricularYear infoCurricularYear, String executionCourseName) throws NotAuthorizedException {
        CoordinatorExecutionDegreeAuthorizationFilter.instance.execute(infoExecutionDegree.getExternalId());
        return serviceInstance.run(infoExecutionPeriod, infoExecutionDegree, infoCurricularYear, executionCourseName);
    }

    public static List<InfoExecutionCourse> runSearchExecutionCourses(AcademicInterval academicInterval, ExecutionDegree executionDegree, CurricularYear curricularYear, String string) throws NotAuthorizedException {
        return (List)advice$runSearchExecutionCourses$2.perform((Callable)new SearchExecutionCourses$callable$runSearchExecutionCourses$2(academicInterval, executionDegree, curricularYear, string));
    }

    static /* synthetic */ List<InfoExecutionCourse> advised$runSearchExecutionCourses(AcademicInterval academicInterval, ExecutionDegree executionDegree, CurricularYear curricularYear, String courseName) throws NotAuthorizedException {
        CoordinatorExecutionDegreeAuthorizationFilter.instance.execute(executionDegree.getExternalId());
        return serviceInstance.run(academicInterval, executionDegree, curricularYear, courseName);
    }

    static {
        advice$runSearchExecutionCourses = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runSearchExecutionCourses$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runSearchExecutionCourses$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new SearchExecutionCourses();
    }
}

