/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.log;

import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.log.PhdLogEntry_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class PhdLogEntry
extends PhdLogEntry_Base {
    private PhdLogEntry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private PhdLogEntry(String activityClassName, String message, PhdProgramProcess process2) {
        this.setResponsible(AccessControl.getPerson());
        this.setWhenOccured(new DateTime());
        this.setActivityClassName(activityClassName);
        this.setPhdProgramProcess(process2);
        this.setState(process2.getActiveState().getLocalizedName(new Locale("pt", "PT")));
        this.setMessage(message);
    }

    public String getResponsibleName() {
        if (this.getResponsible() == null) {
            return "-";
        }
        return this.getResponsible().getName();
    }

    static PhdLogEntry createLog(String activityClassName, String message, PhdProgramProcess process2) {
        return new PhdLogEntry(activityClassName, message, process2);
    }
}

