/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExternalUser;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument_Base;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.servlets.FileDownloadServlet;
import org.joda.time.ReadableInstant;

public class PhdProgramProcessDocument
extends PhdProgramProcessDocument_Base {
    public static Comparator<PhdProgramProcessDocument> COMPARATOR_BY_UPLOAD_TIME = new Comparator<PhdProgramProcessDocument>(){

        @Override
        public int compare(PhdProgramProcessDocument left, PhdProgramProcessDocument right) {
            int comparationResult = left.getCreationDate().compareTo((ReadableInstant)right.getCreationDate());
            return comparationResult == 0 ? left.getExternalId().compareTo(right.getExternalId()) : comparationResult;
        }
    };
    public static Comparator<PhdProgramProcessDocument> COMPARATOR_BY_VERSION = new Comparator<PhdProgramProcessDocument>(){

        @Override
        public int compare(PhdProgramProcessDocument left, PhdProgramProcessDocument right) {
            return left.getDocumentVersion().compareTo(right.getDocumentVersion()) * -1;
        }
    };

    protected PhdProgramProcessDocument() {
    }

    public PhdProgramProcessDocument(PhdProgramProcess process2, PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        this();
        this.init(process2, documentType, remarks, content, filename, uploader);
    }

    protected void init(PhdProgramProcess process2, PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        this.checkParameters(process2, documentType, content, filename, uploader);
        this.setDocumentVersion(process2, documentType);
        super.setPhdProgramProcess(process2);
        super.setDocumentType(documentType);
        super.setRemarks(remarks);
        super.setUploader(uploader);
        super.setDocumentAccepted(Boolean.valueOf(true));
        super.init(filename, filename, content);
    }

    public void setFilename(String filename) {
        super.setFilename(FileUtils.cleanupUserInputFilename(filename));
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(FileUtils.cleanupUserInputFileDisplayName(displayName));
    }

    protected void setDocumentVersion(PhdProgramProcess process2, PhdIndividualProgramDocumentType documentType) {
        if (documentType.isVersioned()) {
            super.setDocumentVersion(process2.getLastVersionNumber(documentType));
        } else {
            super.setDocumentVersion(Integer.valueOf(1));
        }
    }

    protected void checkParameters(PhdProgramProcess process2, PhdIndividualProgramDocumentType documentType, byte[] content, String filename, Person uploader) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.phd.PhdProgramProcessDocument.process.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (uploader == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessDocument.uploader.cannot.be.null", args1);
        }
        if (documentType == null || content == null || content.length == 0 || StringUtils.isEmpty((String)filename)) {
            throw new DomainException("error.phd.PhdProgramProcessDocument.documentType.and.file.cannot.be.null", new String[0]);
        }
    }

    @Deprecated
    public String getDownloadUrl() {
        return FileDownloadServlet.getDownloadUrl((GenericFile)this);
    }

    public void delete() {
        this.setUploader(null);
        this.setPhdProgramProcess(null);
        super.delete();
    }

    public boolean hasType(PhdIndividualProgramDocumentType type) {
        return this.getDocumentType().equals((Object)type);
    }

    public boolean isAccessible(User user) {
        return user != null && user.getPerson() != null && (this.getPhdProgramProcess().getPerson() == user.getPerson() || AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESSES).isMember(user) || this.getPhdProgramProcess().getIndividualProgramProcess().isCoordinatorForPhdProgram(user.getPerson()) || this.getPhdProgramProcess().getIndividualProgramProcess().isGuiderOrAssistentGuider(user.getPerson()) || ExternalUser.isExternalUser(user.getUsername()));
    }

    public boolean isPrivate() {
        return true;
    }

    public PhdProgramProcessDocument replaceDocument(PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        if (!((Object)((Object)this)).getClass().equals(PhdProgramProcessDocument.class)) {
            throw new DomainException("error.phd.PhdProgramProcessDocument.override.replaceDocument.method.on.this.class", new String[0]);
        }
        if (!this.getDocumentType().equals((Object)documentType)) {
            throw new DomainException("error.phd.PhdProgramProcessDocument.type.must.be.equal", new String[0]);
        }
        return new PhdProgramProcessDocument(this.getPhdProgramProcess(), documentType, remarks, content, filename, uploader);
    }

    public boolean isReplaceable() {
        return this.isVersioned();
    }

    public boolean isOtherType() {
        return this.hasType(PhdIndividualProgramDocumentType.OTHER);
    }

    public boolean isVersioned() {
        return this.getDocumentType().isVersioned();
    }

    public boolean isLast() {
        return !this.isVersioned() || this.getPhdProgramProcess().getLatestDocumentVersionFor(this.getDocumentType()) == this;
    }

    public PhdProgramProcessDocument getLastVersion() {
        if (!this.isVersioned()) {
            return this;
        }
        return this.getPhdProgramProcess().getLatestDocumentVersionFor(this.getDocumentType());
    }

    public Set<PhdProgramProcessDocument> getAllVersions() {
        return this.getPhdProgramProcess().getAllDocumentVersionsOfType(this.getDocumentType());
    }

    public void removeFromProcess() {
        if (!this.isVersioned()) {
            this.setDocumentAccepted(false);
            return;
        }
        Set<PhdProgramProcessDocument> versions = this.getAllVersions();
        for (PhdProgramProcessDocument version : versions) {
            version.setDocumentAccepted(false);
        }
    }
}

