/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.bennu.core.domain.Bennu;

public class MobilityAgreement
extends MobilityAgreement_Base {
    private MobilityAgreement() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public MobilityAgreement(MobilityProgram program, UniversityUnit university) {
        this();
        if (university == null) {
            throw new NullPointerException("error.university.cannot.be.null");
        }
        this.setMobilityProgram(program);
        this.setUniversityUnit(university);
    }

    public void delete() {
        this.setMobilityProgram(null);
        this.setUniversityUnit(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public static MobilityAgreement getOrCreateAgreement(MobilityProgram mobilityProgram, UniversityUnit universityUnit) {
        MobilityAgreement mobilityAgreementByUniversityUnit = mobilityProgram.getMobilityAgreementByUniversityUnit(universityUnit);
        if (mobilityAgreementByUniversityUnit == null) {
            return new MobilityAgreement(mobilityProgram, universityUnit);
        }
        return mobilityAgreementByUniversityUnit;
    }
}

