/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode;
import org.fenixedu.academic.domain.accounting.util.PaymentCodeGenerator;
import org.fenixedu.bennu.core.domain.Bennu;

public class IndividualCandidacyPaymentCodeGenerator
extends PaymentCodeGenerator {
    public static Comparator<PaymentCode> COMPARATOR_BY_PAYMENT_SEQUENTIAL_DIGITS = new Comparator<PaymentCode>(){

        @Override
        public int compare(PaymentCode leftPaymentCode, PaymentCode rightPaymentCode) {
            String rightSequentialNumber;
            String leftSequentialNumber = IndividualCandidacyPaymentCodeGenerator.getSequentialNumber(leftPaymentCode);
            int comparationResult = leftSequentialNumber.compareTo(rightSequentialNumber = IndividualCandidacyPaymentCodeGenerator.getSequentialNumber(rightPaymentCode));
            return comparationResult == 0 ? leftPaymentCode.getExternalId().compareTo(rightPaymentCode.getExternalId()) : comparationResult;
        }
    };
    private static final String CODE_FILLER = "0";
    private static final int NUM_TYPE_DIGITS = 2;
    private static final int NUM_CONTROL_DIGITS = 2;
    private static final int NUM_SEQUENTIAL_NUMBERS = 4;
    private static final String START = "8";

    @Override
    public boolean canGenerateNewCode(PaymentCodeType paymentCodeType, Person person) {
        PaymentCode lastPaymentCode = this.findLastPaymentCode(paymentCodeType);
        return lastPaymentCode == null ? true : Integer.valueOf(IndividualCandidacyPaymentCodeGenerator.getSequentialNumber(lastPaymentCode)) < 9999;
    }

    private PaymentCode findLastPaymentCode(PaymentCodeType paymentCodeType) {
        List<IndividualCandidacyPaymentCode> individualCandidacyPaymentCodes = this.getAllIndividualCandidacyPaymentCodesForType(paymentCodeType);
        return individualCandidacyPaymentCodes.isEmpty() ? null : Collections.max(individualCandidacyPaymentCodes, COMPARATOR_BY_PAYMENT_SEQUENTIAL_DIGITS);
    }

    private List<IndividualCandidacyPaymentCode> getAllIndividualCandidacyPaymentCodesForType(final PaymentCodeType paymentCodeType) {
        Set allPaymentCodes = Bennu.getInstance().getPaymentCodesSet();
        ArrayList<IndividualCandidacyPaymentCode> outputList = new ArrayList<IndividualCandidacyPaymentCode>();
        CollectionUtils.select((Collection)allPaymentCodes, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                PaymentCode paymentCode = (PaymentCode)((Object)arg0);
                return paymentCodeType.equals((Object)paymentCode.getType());
            }
        }, outputList);
        return outputList;
    }

    @Override
    public String generateNewCodeFor(PaymentCodeType paymentCodeType, Person person) {
        PaymentCode lastPaymentCode = this.findLastPaymentCode(paymentCodeType);
        int nextSequentialNumber = lastPaymentCode == null ? 0 : Integer.valueOf(IndividualCandidacyPaymentCodeGenerator.getSequentialNumber(lastPaymentCode)) + 1;
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)4, (String)CODE_FILLER);
        String typeDigitsPadded = StringUtils.leftPad((String)String.valueOf(paymentCodeType.getTypeDigit()), (int)2, (String)CODE_FILLER);
        String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
        return START + sequentialNumberPadded + typeDigitsPadded + controDigitsPadded;
    }

    private static String getSequentialNumber(PaymentCode paymentCode) {
        String sequentialNumber = paymentCode.getCode().substring(1, paymentCode.getCode().length() - 2 - 2);
        return sequentialNumber;
    }

    @Override
    public boolean isCodeMadeByThisFactory(PaymentCode paymentCode) {
        return paymentCode.getCode().startsWith(START);
    }
}

