/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonAccount_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.transactions.InsuranceTransaction;
import org.fenixedu.academic.domain.transactions.PaymentTransaction;
import org.fenixedu.academic.domain.transactions.Transaction;
import org.fenixedu.bennu.core.domain.Bennu;

public class PersonAccount
extends PersonAccount_Base {
    public PersonAccount() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public PersonAccount(Person person) {
        this();
        this.setPerson(person);
        this.setBalance(new Double(0.0));
    }

    public List getPaymentTransactions() {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (Transaction transaction : this.getTransactionsSet()) {
            if (!(transaction instanceof PaymentTransaction)) continue;
            result.add(transaction);
        }
        return result;
    }

    public List getInsuranceTransactions() {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (Transaction transaction : this.getTransactionsSet()) {
            if (!(transaction instanceof InsuranceTransaction)) continue;
            result.add(transaction);
        }
        return result;
    }

    public void delete() {
        if (this.getTransactionsSet().size() > 0) {
            throw new DomainException("error.person.cannot.be.deleted", new String[0]);
        }
        this.setRootDomainObject(null);
        this.setPerson(null);
        super.deleteDomainObject();
    }
}

