/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Branch;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourseEquivalence;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.CurricularCourse_Base;
import org.fenixedu.academic.domain.CurricularSemester;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Curriculum;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.MarkSheetState;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.branch.BranchType;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.RestrictionDoneDegreeModule;
import org.fenixedu.academic.domain.curriculum.CurricularCourseType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CurricularCourseFunctor;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.predicate.MarkSheetPredicates;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class CurricularCourse
extends CurricularCourse_Base {
    public static final Comparator<CurricularCourse> CURRICULAR_COURSE_COMPARATOR_BY_DEGREE_AND_NAME = new Comparator<CurricularCourse>(){

        @Override
        public int compare(CurricularCourse o1, CurricularCourse o2) {
            Degree degree1 = o1.getDegree();
            Degree degree2 = o2.getDegree();
            Collator collator = Collator.getInstance();
            int degreeTypeComp = degree1.getDegreeType().compareTo(degree2.getDegreeType());
            if (degreeTypeComp != 0) {
                return degreeTypeComp;
            }
            int degreeNameComp = collator.compare(degree1.getNome(), degree2.getNome());
            if (degreeNameComp == 0) {
                return degreeNameComp;
            }
            return COMPARATOR_BY_NAME.compare(o1, o2);
        }
    };

    public static List<CurricularCourse> readCurricularCourses() {
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        for (DegreeModule degreeModule : Bennu.getInstance().getDegreeModulesSet()) {
            if (!(degreeModule instanceof CurricularCourse)) continue;
            result.add((CurricularCourse)((Object)degreeModule));
        }
        return result;
    }

    protected CurricularCourse() {
        Double d = 0.0;
        this.setTheoreticalHours(d);
        this.setTheoPratHours(d);
        this.setLabHours(d);
        this.setPraticalHours(d);
        this.setCredits(d);
        this.setEctsCredits(d);
        this.setWeigth(d);
    }

    protected CurricularCourse(DegreeCurricularPlan degreeCurricularPlan, String name, String code, String acronym, Boolean enrolmentAllowed, CurricularStage curricularStage) {
        this();
        this.checkParameters(name, code, acronym);
        this.checkForCurricularCourseWithSameAttributes(degreeCurricularPlan, name, code, acronym);
        this.setName(name);
        this.setCode(code);
        this.setAcronym(acronym);
        this.setEnrollmentAllowed(enrolmentAllowed);
        this.setCurricularStage(curricularStage);
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        if (curricularStage == CurricularStage.OLD) {
            this.setRegimeType(RegimeType.SEMESTRIAL);
        }
    }

    private void checkParameters(String name, String code, String acronym) {
        if (StringUtils.isEmpty((String)name)) {
            throw new DomainException("error.curricularCourse.invalid.name", new String[0]);
        }
        if (StringUtils.isEmpty((String)code)) {
            throw new DomainException("error.curricularCourse.invalid.code", new String[0]);
        }
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.curricularCourse.invalid.acronym", new String[0]);
        }
    }

    public CurricularCourse(Double weight, String prerequisites, String prerequisitesEn, CurricularStage curricularStage, CompetenceCourse competenceCourse, CourseGroup parentCourseGroup, CurricularPeriod curricularPeriod, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        this();
        this.setWeigth(weight);
        this.setPrerequisites(prerequisites);
        this.setPrerequisitesEn(prerequisitesEn);
        this.setCurricularStage(curricularStage);
        this.setCompetenceCourse(competenceCourse);
        this.setType(CurricularCourseType.NORMAL_COURSE);
        new Context(parentCourseGroup, (DegreeModule)((Object)this), curricularPeriod, beginExecutionPeriod, endExecutionPeriod);
    }

    public GradeScale getGradeScaleChain() {
        return super.getGradeScale() != null ? super.getGradeScale() : this.getDegreeCurricularPlan().getGradeScaleChain();
    }

    public void print(StringBuilder dcp, String tabs, Context previousContext) {
        String tab = tabs + "\t";
        dcp.append(tab);
        dcp.append("[CC ").append(this.getExternalId()).append("][");
        dcp.append(previousContext.getCurricularPeriod().getOrderByType(AcademicPeriod.YEAR)).append("Y,");
        dcp.append(previousContext.getCurricularPeriod().getOrderByType(AcademicPeriod.SEMESTER)).append("S]\t");
        dcp.append("[B:").append(previousContext.getBeginExecutionPeriod().getBeginDateYearMonthDay());
        dcp.append(" E:").append(previousContext.getEndExecutionPeriod() != null ? previousContext.getEndExecutionPeriod().getEndDateYearMonthDay() : "          ");
        dcp.append("]\t");
        dcp.append(this.getName()).append("\n");
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isRoot() {
        return false;
    }

    public DegreeCurricularPlan getParentDegreeCurricularPlan() {
        if (this.getCurricularStage() != CurricularStage.OLD) {
            return !this.getParentContextsSet().isEmpty() ? ((Context)this.getParentContextsSet().iterator().next()).getParentCourseGroup().getParentDegreeCurricularPlan() : null;
        }
        return super.getDegreeCurricularPlan();
    }

    public final DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getParentDegreeCurricularPlan();
    }

    public void edit(Double weight, String prerequisites, String prerequisitesEn, CurricularStage curricularStage, CompetenceCourse competenceCourse) {
        this.setWeigth(weight);
        this.setPrerequisites(prerequisites);
        this.setPrerequisitesEn(prerequisitesEn);
        this.setCurricularStage(curricularStage);
        this.setCompetenceCourse(competenceCourse);
    }

    public void edit(String name, String nameEn, CurricularStage curricularStage) {
        this.setName(name);
        this.setNameEn(nameEn);
        this.setCurricularStage(curricularStage);
    }

    public void edit(String name, String nameEn, String code, String acronym, Double weigth, Double credits, Double ectsCredits, Integer enrolmentWeigth, Integer minimumValueForAcumulatedEnrollments, Integer maximumValueForAcumulatedEnrollments, Double theoreticalHours, Double labHours, Double praticalHours, Double theoPratHours, GradeScale gradeScale) {
        this.checkForCurricularCourseWithSameAttributes(this.getDegreeCurricularPlan(), name, code, acronym);
        this.setName(name);
        this.setNameEn(nameEn);
        this.setCode(code);
        this.setAcronym(acronym);
        this.setWeigth(weigth);
        this.setCredits(credits);
        this.setEctsCredits(ectsCredits);
        this.setEnrollmentWeigth(enrolmentWeigth);
        this.setMinimumValueForAcumulatedEnrollments(minimumValueForAcumulatedEnrollments);
        this.setMaximumValueForAcumulatedEnrollments(maximumValueForAcumulatedEnrollments);
        this.setTheoreticalHours(theoreticalHours);
        this.setLabHours(labHours);
        this.setPraticalHours(praticalHours);
        this.setTheoPratHours(theoPratHours);
        super.setGradeScale(gradeScale);
    }

    private void checkForCurricularCourseWithSameAttributes(DegreeCurricularPlan degreeCurricularPlan, String name, String code, String acronym) {
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            if (curricularCourse == this) continue;
            if (curricularCourse.getName().equals(name) && curricularCourse.getCode().equals(code)) {
                throw new DomainException("error.curricularCourseWithSameNameAndCode", new String[0]);
            }
            if (!curricularCourse.getAcronym().equals(acronym)) continue;
            throw new DomainException("error.curricularCourseWithSameAcronym", new String[0]);
        }
    }

    public void delete() {
        super.delete();
        this.setUniversity(null);
        this.setDegreeCurricularPlan(null);
        this.setCompetenceCourse(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean curricularCourseIsMandatory() {
        return this.getMandatory();
    }

    public List<CurricularCourseScope> getInterminatedScopes() {
        ArrayList<CurricularCourseScope> result = new ArrayList<CurricularCourseScope>();
        for (CurricularCourseScope curricularCourseScope : this.getScopesSet()) {
            if (curricularCourseScope.getEndDate() != null) continue;
            result.add(curricularCourseScope);
        }
        return result;
    }

    public List<CurricularCourseScope> getActiveScopes() {
        ArrayList<CurricularCourseScope> activeScopes = new ArrayList<CurricularCourseScope>();
        for (CurricularCourseScope scope : this.getScopesSet()) {
            if (!scope.isActive().booleanValue()) continue;
            activeScopes.add(scope);
        }
        return activeScopes;
    }

    public boolean hasAnyActiveDegreModuleScope(int year, int semester) {
        for (DegreeModuleScope degreeModuleScope : this.getDegreeModuleScopes()) {
            if (!degreeModuleScope.isActive(year, semester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyActiveDegreModuleScope() {
        for (DegreeModuleScope degreeModuleScope : this.getDegreeModuleScopes()) {
            if (!degreeModuleScope.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyActiveDegreModuleScope(ExecutionSemester executionSemester) {
        for (DegreeModuleScope degreeModuleScope : this.getDegreeModuleScopes()) {
            if (!degreeModuleScope.isActiveForExecutionPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyActiveDegreModuleScope(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.hasAnyActiveDegreModuleScope(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyActiveContext(ExecutionSemester executionSemester) {
        for (Context context : this.getParentContextsSet()) {
            if (!context.isValid(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public List<CurricularCourseScope> getActiveScopesInExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<CurricularCourseScope> result = new ArrayList<CurricularCourseScope>();
        for (CurricularCourseScope curricularCourseScope : this.getScopesSet()) {
            if (!curricularCourseScope.isActiveForExecutionPeriod(executionSemester)) continue;
            result.add(curricularCourseScope);
        }
        return result;
    }

    @Deprecated
    public List<DegreeModuleScope> getActiveDegreeModuleScopesInExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<DegreeModuleScope> activeScopesInExecutionPeriod = new ArrayList<DegreeModuleScope>();
        for (DegreeModuleScope scope : this.getDegreeModuleScopes()) {
            if (!scope.isActiveForExecutionPeriod(executionSemester)) continue;
            activeScopesInExecutionPeriod.add(scope);
        }
        return activeScopesInExecutionPeriod;
    }

    public List<DegreeModuleScope> getActiveDegreeModuleScopesInAcademicInterval(AcademicInterval academicInterval) {
        ArrayList<DegreeModuleScope> activeScopesInExecutionPeriod = new ArrayList<DegreeModuleScope>();
        for (DegreeModuleScope scope : this.getDegreeModuleScopes()) {
            if (!scope.isActiveForAcademicInterval(academicInterval)) continue;
            activeScopesInExecutionPeriod.add(scope);
        }
        return activeScopesInExecutionPeriod;
    }

    public boolean hasActiveScopesInExecutionPeriod(ExecutionSemester executionSemester) {
        return !this.getActiveDegreeModuleScopesInExecutionPeriod(executionSemester).isEmpty();
    }

    public Set<CurricularCourseScope> getActiveScopesInExecutionYear(ExecutionYear executionYear) {
        HashSet<CurricularCourseScope> result = new HashSet<CurricularCourseScope>();
        for (CurricularCourseScope scope : this.getScopesSet()) {
            if (!scope.isActiveForExecutionYear(executionYear)) continue;
            result.add(scope);
        }
        return result;
    }

    public List<CurricularCourseScope> getActiveScopesIntersectedByExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<CurricularCourseScope> activeScopesInExecutionPeriod = new ArrayList<CurricularCourseScope>();
        for (CurricularCourseScope scope : this.getScopesSet()) {
            if (scope.getBeginYearMonthDay().isBefore((ReadablePartial)executionSemester.getBeginDateYearMonthDay())) {
                if (scope.hasEndYearMonthDay() && scope.getEndYearMonthDay().isBefore((ReadablePartial)executionSemester.getBeginDateYearMonthDay())) continue;
                activeScopesInExecutionPeriod.add(scope);
                continue;
            }
            if (scope.getBeginYearMonthDay().isAfter((ReadablePartial)executionSemester.getEndDateYearMonthDay())) continue;
            activeScopesInExecutionPeriod.add(scope);
        }
        return activeScopesInExecutionPeriod;
    }

    public boolean hasRestrictionDone(CurricularCourse precedence) {
        if (!this.isBolonhaDegree()) {
            throw new DomainException("CurricularCourse.method.only.appliable.to.bolonha.structure", new String[0]);
        }
        ExecutionSemester currentExecutionPeriod = ExecutionSemester.readActualExecutionSemester();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            RestrictionDoneDegreeModule restrictionDone;
            if (!curricularRule.isValid(currentExecutionPeriod) || !(curricularRule instanceof RestrictionDoneDegreeModule) || (restrictionDone = (RestrictionDoneDegreeModule)((Object)curricularRule)).getPrecedenceDegreeModule() != precedence) continue;
            return true;
        }
        return false;
    }

    public CurricularYear getCurricularYearByBranchAndSemester(Branch branch, Integer semester) {
        return this.getCurricularYearByBranchAndSemester(branch, semester, new Date());
    }

    public CurricularYear getCurricularYearByBranchAndSemester(Branch branch, Integer semester, Date date) {
        ArrayList<CurricularCourseScope> scopesFound = new ArrayList<CurricularCourseScope>();
        for (CurricularCourseScope scope : this.getScopesSet()) {
            if (!scope.getCurricularSemester().getSemester().equals(semester) || !scope.isActive(date).booleanValue() || !scope.getBranch().representsCommonBranch().booleanValue() && (branch == null || !branch.equals((Object)scope.getBranch()))) continue;
            scopesFound.add(scope);
        }
        if (scopesFound.isEmpty()) {
            for (CurricularCourseScope scope : this.getScopesSet()) {
                if (!scope.getCurricularSemester().getSemester().equals(semester) || !scope.isActive(date).booleanValue()) continue;
                scopesFound.add(scope);
            }
        }
        return this.getCurricularYearWithLowerYear(scopesFound, date);
    }

    public String getCurricularCourseUniqueKeyForEnrollment() {
        DegreeType degreeType = this.getDegreeCurricularPlan() != null && this.getDegreeCurricularPlan().getDegree() != null ? this.getDegreeCurricularPlan().getDegree().getDegreeType() : null;
        return this.constructUniqueEnrollmentKey(this.getCode(), this.getName(), degreeType);
    }

    public boolean hasActiveScopeInGivenSemester(Integer semester) {
        for (CurricularCourseScope curricularCourseScope : this.getScopesSet()) {
            if (!curricularCourseScope.getCurricularSemester().getSemester().equals(semester) || !curricularCourseScope.isActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasScopeInGivenSemester(Integer semester) {
        for (CurricularCourseScope curricularCourseScope : this.getScopesSet()) {
            if (!curricularCourseScope.getCurricularSemester().getSemester().equals(semester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveScopeInGivenSemesterForGivenBranch(CurricularSemester curricularSemester, Branch branch) {
        Set scopes = this.getScopesSet();
        for (CurricularCourseScope curricularCourseScope : scopes) {
            if (!curricularCourseScope.getCurricularSemester().equals(curricularSemester) || !curricularCourseScope.isActive().booleanValue() || !curricularCourseScope.getBranch().equals((Object)branch)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveScopeInGivenSemesterForGivenBranch(Integer semester, Branch branch) {
        Set scopes = this.getScopesSet();
        for (CurricularCourseScope curricularCourseScope : scopes) {
            if (!curricularCourseScope.getCurricularSemester().getSemester().equals(semester) || !curricularCourseScope.isActive().booleanValue() || !curricularCourseScope.getBranch().equals((Object)branch)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveScopeInGivenSemesterForCommonAndGivenBranch(final Integer semester, final Branch branch) {
        Set scopes = this.getScopesSet();
        List result = (List)CollectionUtils.select((Collection)scopes, (Predicate)new Predicate(){

            public boolean evaluate(Object obj) {
                CurricularCourseScope curricularCourseScope = (CurricularCourseScope)((Object)obj);
                return (curricularCourseScope.getBranch().getBranchType().equals((Object)BranchType.COMNBR) || curricularCourseScope.getBranch().equals((Object)branch)) && curricularCourseScope.getCurricularSemester().getSemester().equals(semester) && curricularCourseScope.isActive() != false;
            }
        });
        return !result.isEmpty();
    }

    private CurricularYear getCurricularYearWithLowerYear(List<CurricularCourseScope> listOfScopes, Date date) {
        if (listOfScopes.isEmpty()) {
            return null;
        }
        CurricularYear minCurricularYear = null;
        for (CurricularCourseScope curricularCourseScope : listOfScopes) {
            if (!curricularCourseScope.isActive(date).booleanValue()) continue;
            CurricularYear actualCurricularYear = curricularCourseScope.getCurricularSemester().getCurricularYear();
            if (minCurricularYear != null && minCurricularYear.getYear() <= actualCurricularYear.getYear()) continue;
            minCurricularYear = actualCurricularYear;
        }
        return minCurricularYear;
    }

    private String constructUniqueEnrollmentKey(String code, String name, DegreeType degreeType) {
        StringBuilder stringBuffer = new StringBuilder(50);
        stringBuffer.append(code);
        stringBuffer.append(name);
        if (degreeType != null) {
            stringBuffer.append(degreeType.toString());
        }
        return StringUtils.lowerCase((String)stringBuffer.toString());
    }

    public Curriculum editCurriculum(String program, String programEn, String generalObjectives, String generalObjectivesEn, String operacionalObjectives, String operacionalObjectivesEn, DateTime lastModification) {
        Curriculum curriculum = this.findLatestCurriculum();
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (!curriculum.getLastModificationDateDateTime().isBefore((ReadableInstant)currentExecutionYear.getBeginDateYearMonthDay().toDateMidnight()) && !curriculum.getLastModificationDateDateTime().isAfter((ReadableInstant)currentExecutionYear.getEndDateYearMonthDay().toDateMidnight())) {
            curriculum.edit(generalObjectives, operacionalObjectives, program, generalObjectivesEn, operacionalObjectivesEn, programEn);
        } else {
            curriculum = this.insertCurriculum(program, programEn, operacionalObjectives, operacionalObjectivesEn, generalObjectives, generalObjectivesEn, lastModification);
        }
        return curriculum;
    }

    public Curriculum insertCurriculum(String program, String programEn, String operacionalObjectives, String operacionalObjectivesEn, String generalObjectives, String generalObjectivesEn, DateTime lastModification) {
        Curriculum curriculum = new Curriculum();
        curriculum.setCurricularCourse(this);
        curriculum.setProgram(program);
        curriculum.setProgramEn(programEn);
        curriculum.setOperacionalObjectives(operacionalObjectives);
        curriculum.setOperacionalObjectivesEn(operacionalObjectivesEn);
        curriculum.setGeneralObjectives(generalObjectives);
        curriculum.setGeneralObjectivesEn(generalObjectivesEn);
        curriculum.setLastModificationDateDateTime(lastModification);
        return curriculum;
    }

    public List<ExecutionCourse> getExecutionCoursesByExecutionPeriod(final ExecutionSemester executionSemester) {
        return (List)CollectionUtils.select((Collection)this.getAssociatedExecutionCoursesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                ExecutionCourse executionCourse = (ExecutionCourse)((Object)o);
                return executionCourse.getExecutionPeriod().equals(executionSemester);
            }
        });
    }

    public List<ExecutionCourse> getExecutionCoursesByExecutionYear(final ExecutionYear executionYear) {
        return (List)CollectionUtils.select((Collection)this.getAssociatedExecutionCoursesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                ExecutionCourse executionCourse = (ExecutionCourse)((Object)o);
                return executionCourse.getExecutionPeriod().getExecutionYear().equals(executionYear);
            }
        });
    }

    public Curriculum findLatestCurriculum() {
        Curriculum latestCurriculum = null;
        for (Curriculum curriculum : this.getAssociatedCurriculumsSet()) {
            if (latestCurriculum != null && !latestCurriculum.getLastModificationDateDateTime().isBefore((ReadableInstant)curriculum.getLastModificationDateDateTime())) continue;
            latestCurriculum = curriculum;
        }
        return latestCurriculum;
    }

    public Curriculum findLatestCurriculumModifiedBefore(Date date) {
        Curriculum latestCurriculum = null;
        for (Curriculum curriculum : this.getAssociatedCurriculumsSet()) {
            if (curriculum.getLastModificationDateDateTime().toDate().compareTo(date) == 1) continue;
            if (latestCurriculum == null) {
                latestCurriculum = curriculum;
                continue;
            }
            DateTime currentLastModificationDate = latestCurriculum.getLastModificationDateDateTime();
            if (!currentLastModificationDate.isBefore((ReadableInstant)curriculum.getLastModificationDateDateTime())) continue;
            latestCurriculum = curriculum;
        }
        return latestCurriculum;
    }

    public final double getProblemsHours() {
        return this.getProblemsHours(null, null);
    }

    public final Double getProblemsHours(CurricularPeriod curricularPeriod) {
        return this.getProblemsHours(curricularPeriod, null);
    }

    public final double getProblemsHours(ExecutionSemester executionSemester) {
        return this.getProblemsHours(null, executionSemester);
    }

    public final Double getProblemsHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getProblemsHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final double getLaboratorialHours() {
        return this.getLaboratorialHours(null, null);
    }

    public final Double getLaboratorialHours(CurricularPeriod curricularPeriod) {
        return this.getLaboratorialHours(curricularPeriod, null);
    }

    public final double getLaboratorialHours(ExecutionSemester executionSemester) {
        return this.getLaboratorialHours(null, executionSemester);
    }

    public final Double getLaboratorialHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getLaboratorialHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final Double getSeminaryHours() {
        return this.getSeminaryHours(null, null);
    }

    public final Double getSeminaryHours(CurricularPeriod curricularPeriod) {
        return this.getSeminaryHours(curricularPeriod, null);
    }

    public final double getSeminaryHours(ExecutionSemester executionSemester) {
        return this.getSeminaryHours(null, executionSemester);
    }

    public final Double getSeminaryHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getSeminaryHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final double getFieldWorkHours() {
        return this.getFieldWorkHours(null, null);
    }

    public final Double getFieldWorkHours(CurricularPeriod curricularPeriod) {
        return this.getFieldWorkHours(curricularPeriod, null);
    }

    public final double getFieldWorkHours(ExecutionSemester executionSemester) {
        return this.getFieldWorkHours(null, executionSemester);
    }

    public final Double getFieldWorkHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getFieldWorkHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final double getTrainingPeriodHours() {
        return this.getTrainingPeriodHours(null, null);
    }

    public final Double getTrainingPeriodHours(CurricularPeriod curricularPeriod) {
        return this.getTrainingPeriodHours(curricularPeriod, null);
    }

    public final double getTrainingPeriodHours(ExecutionSemester executionSemester) {
        return this.getTrainingPeriodHours(null, executionSemester);
    }

    public final Double getTrainingPeriodHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getTrainingPeriodHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final double getTutorialOrientationHours() {
        return this.getTutorialOrientationHours(null, null);
    }

    public final Double getTutorialOrientationHours(CurricularPeriod curricularPeriod) {
        return this.getTutorialOrientationHours(curricularPeriod, null);
    }

    public final double getTutorialOrientationHours(ExecutionSemester executionSemester) {
        return this.getTutorialOrientationHours(null, executionSemester);
    }

    public final Double getTutorialOrientationHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getTutorialOrientationHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final double getAutonomousWorkHours() {
        return this.getAutonomousWorkHours((CurricularPeriod)null, (ExecutionSemester)null);
    }

    public final Double getAutonomousWorkHours(CurricularPeriod curricularPeriod) {
        return this.getAutonomousWorkHours(curricularPeriod, (ExecutionSemester)null);
    }

    public final double getAutonomousWorkHours(ExecutionSemester executionSemester) {
        return this.getAutonomousWorkHours((CurricularPeriod)null, executionSemester);
    }

    public final Double getAutonomousWorkHours(CurricularPeriod curricularPeriod, ExecutionYear executionYear) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getAutonomousWorkHours(curricularPeriod.getChildOrder(), executionYear) : 0.0;
    }

    public final Double getAutonomousWorkHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getAutonomousWorkHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
    }

    public final double getContactLoad() {
        return this.getContactLoad((CurricularPeriod)null, (ExecutionSemester)null);
    }

    public final Double getContactLoad(CurricularPeriod curricularPeriod) {
        return this.getContactLoad(curricularPeriod, (ExecutionSemester)null);
    }

    public final double getContactLoad(ExecutionSemester executionSemester) {
        return this.getContactLoad((CurricularPeriod)null, executionSemester);
    }

    public final Double getContactLoad(CurricularPeriod curricularPeriod, ExecutionYear executionYear) {
        return this.getContactLoad(curricularPeriod, executionYear == null ? null : executionYear.getLastExecutionPeriod());
    }

    public final Double getContactLoad(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse() != null ? this.getCompetenceCourse().getContactLoad(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
        }
        return this.getContactLoadForPreBolonha();
    }

    private Double getContactLoadForPreBolonha() {
        Double theoreticalHours = this.getTheoreticalHours() == null ? 0.0 : this.getTheoreticalHours();
        Double theoPratHours = this.getTheoPratHours() == null ? 0.0 : this.getTheoPratHours();
        Double praticalHours = this.getPraticalHours() == null ? 0.0 : this.getPraticalHours();
        Double labHours = this.getLabHours() == null ? 0.0 : this.getLabHours();
        return (double)CompetenceCourseLoad.NUMBER_OF_WEEKS * (theoreticalHours + theoPratHours + praticalHours + labHours);
    }

    public final double getTotalLoad() {
        return this.getTotalLoad((CurricularPeriod)null, (ExecutionSemester)null);
    }

    public final Double getTotalLoad(CurricularPeriod curricularPeriod) {
        return this.getTotalLoad(curricularPeriod, (ExecutionSemester)null);
    }

    public final double getTotalLoad(ExecutionSemester executionSemester) {
        return this.getTotalLoad((CurricularPeriod)null, executionSemester);
    }

    public final Double getTotalLoad(CurricularPeriod curricularPeriod, ExecutionYear executionYear) {
        return this.getTotalLoad(curricularPeriod, executionYear == null ? null : executionYear.getLastExecutionPeriod());
    }

    public final Double getTotalLoad(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse() != null ? this.getCompetenceCourse().getTotalLoad(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
        }
        return this.getAutonomousWorkHours() + this.getContactLoadForPreBolonha();
    }

    public final Double getLabHours() {
        return this.getLabHours(null, null);
    }

    public final Double getLabHours(CurricularPeriod curricularPeriod) {
        return this.getLabHours(curricularPeriod, null);
    }

    public final double getLabHours(ExecutionSemester executionSemester) {
        return this.getLabHours(null, executionSemester);
    }

    public final Double getLabHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse() != null ? this.getCompetenceCourse().getLaboratorialHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
        }
        Double labHours = super.getLabHours();
        return labHours == null ? 0.0 : labHours;
    }

    public final Double getTheoreticalHours() {
        return this.getTheoreticalHours(null, null);
    }

    public final Double getTheoreticalHours(CurricularPeriod curricularPeriod) {
        return this.getTheoreticalHours(curricularPeriod, null);
    }

    public final double getTheoreticalHours(ExecutionSemester executionSemester) {
        return this.getTheoreticalHours(null, executionSemester);
    }

    public final Double getTheoreticalHours(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse() != null ? this.getCompetenceCourse().getTheoreticalHours(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester) : 0.0;
        }
        Double theoreticalHours = super.getTheoreticalHours();
        return theoreticalHours == null ? 0.0 : theoreticalHours;
    }

    public final Double getPraticalHours() {
        Double praticalHours = super.getPraticalHours();
        return praticalHours == null ? 0.0 : praticalHours;
    }

    public final Double getTheoPratHours() {
        Double theoPratHours = super.getTheoPratHours();
        return theoPratHours == null ? 0.0 : theoPratHours;
    }

    public final Double getCredits() {
        return this.isBolonhaDegree() ? this.getEctsCredits() : super.getCredits();
    }

    public Double getEctsCredits() {
        return this.getEctsCredits((CurricularPeriod)null, (ExecutionSemester)null);
    }

    public Double getEctsCredits(CurricularPeriod curricularPeriod) {
        return this.getEctsCredits(curricularPeriod, (ExecutionSemester)null);
    }

    public Double getEctsCredits(ExecutionSemester executionSemester) {
        return this.getEctsCredits((CurricularPeriod)null, executionSemester);
    }

    public Double getEctsCredits(ExecutionYear executionYear) {
        return this.getEctsCredits((CurricularPeriod)null, executionYear);
    }

    public Double getEctsCredits(CurricularPeriod curricularPeriod, ExecutionYear executionYear) {
        return this.getEctsCredits(curricularPeriod, executionYear == null ? null : executionYear.getLastExecutionPeriod());
    }

    public Double getEctsCredits(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        return this.getEctsCredits(curricularPeriod == null ? null : curricularPeriod.getChildOrder(), executionSemester);
    }

    public Double getEctsCredits(Integer order, ExecutionSemester executionSemester) {
        if (this.isBolonhaDegree()) {
            if (this.getCompetenceCourse() != null) {
                return this.getCompetenceCourse().getEctsCredits(order, executionSemester);
            }
            if (this.isOptionalCurricularCourse()) {
                return 0.0;
            }
        } else {
            Double credits = this.getCredits();
            if (this.getDegreeType().isMasterDegree() && credits != null) {
                return credits;
            }
            return super.getEctsCredits();
        }
        throw new DomainException("CurricularCourse.with.no.ects.credits", new String[0]);
    }

    public Double getMaxEctsCredits(ExecutionSemester executionSemester) {
        return this.getEctsCredits(executionSemester);
    }

    public Double getMinEctsCredits(ExecutionSemester executionSemester) {
        return this.getEctsCredits(executionSemester);
    }

    @Deprecated
    public final Double getWeigth() {
        return this.getWeight();
    }

    public final Double getWeight() {
        if (this.isBolonhaDegree()) {
            return this.getEctsCredits();
        }
        if (this.getDegreeType().isMasterDegree()) {
            return this.getCredits();
        }
        return super.getWeigth();
    }

    public final Double getWeight(ExecutionSemester semester) {
        if (this.isBolonhaDegree()) {
            return this.getEctsCredits(semester);
        }
        if (this.getDegreeType().isMasterDegree()) {
            return this.getCredits();
        }
        return super.getWeigth();
    }

    public CurricularSemester getCurricularSemesterWithLowerYearBySemester(Integer semester, Date date) {
        CurricularSemester result = null;
        for (CurricularCourseScope curricularCourseScope : this.getScopesSet()) {
            if (!curricularCourseScope.getCurricularSemester().getSemester().equals(semester) || !curricularCourseScope.isActive(date).booleanValue()) continue;
            if (result == null) {
                result = curricularCourseScope.getCurricularSemester();
                continue;
            }
            if (result.getCurricularYear().getYear() <= curricularCourseScope.getCurricularSemester().getCurricularYear().getYear()) continue;
            result = curricularCourseScope.getCurricularSemester();
        }
        return result;
    }

    private List<Enrolment> getActiveEnrollments(ExecutionSemester executionSemester, Registration registration) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrollment = (Enrolment)((Object)curriculumModule);
            boolean filters = true;
            filters &= !enrollment.isAnnulled();
            filters &= executionSemester == null || enrollment.getExecutionPeriod().equals(executionSemester);
            if (!(filters &= registration == null || enrollment.getStudentCurricularPlan().getRegistration().equals((Object)registration))) continue;
            results.add(enrollment);
        }
        return results;
    }

    public void addNotAnulledEnrolmentsForExecutionPeriod(Collection<Enrolment> enrolments, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).isActive() || enrolment.getExecutionPeriod() != executionSemester) continue;
            enrolments.add(enrolment);
        }
    }

    @Deprecated
    public void addActiveEnrollments(Collection<Enrolment> enrolments, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || (enrolment = (Enrolment)((Object)curriculumModule)).isAnnulled() || enrolment.getExecutionPeriod() != executionSemester) continue;
            enrolments.add(enrolment);
        }
    }

    @Deprecated
    public List<Enrolment> getEnrolmentsByExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        this.addActiveEnrollments(result, executionSemester);
        return result;
    }

    public List<Enrolment> getEnrolmentsByAcademicInterval(AcademicInterval academicInterval) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        this.addActiveEnrollments(result, academicInterval);
        return result;
    }

    private void addActiveEnrollments(List<Enrolment> enrolments, AcademicInterval academicInterval) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || (enrolment = (Enrolment)((Object)curriculumModule)).isAnnulled() || !enrolment.getExecutionPeriod().getAcademicInterval().equals(academicInterval) && !enrolment.getExecutionPeriod().getExecutionYear().getAcademicInterval().equals(academicInterval)) continue;
            enrolments.add(enrolment);
        }
    }

    public List<Enrolment> getEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            result.add((Enrolment)((Object)curriculumModule));
        }
        return result;
    }

    public int countEnrolmentsByExecutionPeriod(ExecutionSemester executionSemester) {
        return this.getEnrolmentsByExecutionPeriod(executionSemester).size();
    }

    public List<Enrolment> getEnrolmentsByYear(String year) {
        return this.getEnrolmentsByExecutionYear(ExecutionYear.readExecutionYearByName(year));
    }

    public int getNumberOfStudentsWithFirstEnrolmentIn(ExecutionSemester executionSemester) {
        HashMap students = new HashMap();
        for (Enrolment enrolment : this.getAllEnrolmentsUntil(executionSemester)) {
            Student student = enrolment.getStudentCurricularPlan().getRegistration().getStudent();
            if (!students.containsKey((Object)student)) {
                ArrayList<Enrolment> enrolments = new ArrayList<Enrolment>();
                enrolments.add(enrolment);
                students.put(student, enrolments);
                continue;
            }
            ((List)students.get((Object)student)).add(enrolment);
        }
        int count = 0;
        for (Student student : students.keySet()) {
            boolean enrolledInExecutionPeriod = false;
            for (Enrolment enrolment : (List)students.get((Object)student)) {
                if (!enrolment.getExecutionPeriod().equals(executionSemester)) continue;
                enrolledInExecutionPeriod = true;
                break;
            }
            if (!enrolledInExecutionPeriod || ((List)students.get((Object)student)).size() != 1) continue;
            ++count;
        }
        return count;
    }

    private List<Enrolment> getAllEnrolmentsUntil(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrolment = (Enrolment)((Object)curriculumModule);
            ExecutionSemester enrolmentExecutionPeriod = enrolment.getExecutionPeriod();
            if (enrolment.isAnnulled() || !enrolmentExecutionPeriod.isBeforeOrEquals(executionSemester)) continue;
            result.add(enrolment);
        }
        return result;
    }

    public List<Enrolment> getEnrolmentsByExecutionYear(ExecutionYear executionYear) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
            result.add(enrolment);
        }
        return result;
    }

    public boolean hasEnrolmentsForExecutionYear(ExecutionYear executionYear) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
            return true;
        }
        return false;
    }

    public Enrolment getEnrolmentByStudentAndYear(Registration registration, String year) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).getStudentCurricularPlan().getRegistration().equals((Object)registration) || !enrolment.getExecutionPeriod().getExecutionYear().getYear().equals(year)) continue;
            return enrolment;
        }
        return null;
    }

    public List<Enrolment> getActiveEnrollments(Registration registration) {
        return this.getActiveEnrollments(null, registration);
    }

    public List<Enrolment> getActiveEnrollments() {
        return this.getActiveEnrollments(null, null);
    }

    public List<Enrolment> getActiveEnrollments(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> enrolments = new ArrayList<Enrolment>();
        this.addActiveEnrollments(enrolments, executionSemester);
        return enrolments;
    }

    public List<Dismissal> getDismissals(ExecutionSemester executionSemester) {
        ArrayList<Dismissal> dismissals = new ArrayList<Dismissal>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Dismissal dismissal;
            if (!curriculumModule.isDismissal() || (dismissal = (Dismissal)((Object)curriculumModule)).getExecutionPeriod() != executionSemester) continue;
            dismissals.add(dismissal);
        }
        return dismissals;
    }

    public List<Enrolment> getActiveEnrollments(ExecutionYear executionYear) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            results.addAll(this.getActiveEnrollments(executionSemester));
        }
        return results;
    }

    public String getName(ExecutionSemester period) {
        String superName = super.getName();
        return (superName == null || superName.length() == 0) && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getName(period) : superName;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getNameEn(ExecutionSemester period) {
        String superNameEn = super.getNameEn();
        return (superNameEn == null || superNameEn.length() == 0) && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getNameEn(period) : superNameEn;
    }

    public String getNameEn() {
        return this.getNameEn(null);
    }

    public String getAcronym(ExecutionSemester period) {
        return (super.getAcronym() == null || super.getAcronym().length() == 0) && this.getCompetenceCourse() != null ? this.getCompetenceCourse().getAcronym(period) : super.getAcronym();
    }

    public String getAcronym() {
        return this.getAcronym(null);
    }

    public DepartmentUnit getDepartmentUnit(ExecutionSemester semester) {
        return this.getCompetenceCourse().getDepartmentUnit(semester);
    }

    public DepartmentUnit getDepartmentUnit() {
        return this.getCompetenceCourse().getDepartmentUnit();
    }

    public Boolean getBasic(ExecutionSemester period) {
        return super.getBasic() == null && this.getCompetenceCourse() != null ? this.getCompetenceCourse().isBasic(period) : super.getBasic().booleanValue();
    }

    public Boolean getBasic() {
        return this.getBasic(null);
    }

    public String getObjectives(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getObjectives(period);
        }
        Curriculum curriculum = this.findLatestCurriculumModifiedBefore(period.getExecutionYear().getEndDate());
        if (curriculum != null) {
            return curriculum.getFullObjectives();
        }
        return null;
    }

    public String getObjectives() {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getObjectives();
        }
        Curriculum curriculum = this.findLatestCurriculum();
        if (curriculum != null) {
            return curriculum.getFullObjectives();
        }
        return null;
    }

    public String getObjectivesEn(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getObjectivesEn(period);
        }
        Curriculum curriculum = this.findLatestCurriculumModifiedBefore(period.getExecutionYear().getEndDate());
        if (curriculum != null) {
            return curriculum.getFullObjectivesEn();
        }
        return null;
    }

    public String getObjectivesEn() {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getObjectivesEn();
        }
        Curriculum curriculum = this.findLatestCurriculum();
        if (curriculum != null) {
            return curriculum.getFullObjectivesEn();
        }
        return null;
    }

    public MultiLanguageString getObjectivesI18N(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getObjectivesI18N(period);
        }
        Curriculum curriculum = this.findLatestCurriculumModifiedBefore(period.getExecutionYear().getEndDate());
        if (curriculum != null) {
            return curriculum.getFullObjectivesI18N();
        }
        return new MultiLanguageString();
    }

    public String getProgram(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getProgram(period);
        }
        Curriculum curriculum = this.findLatestCurriculumModifiedBefore(period.getExecutionYear().getEndDate());
        if (curriculum != null) {
            return curriculum.getProgram();
        }
        return null;
    }

    public String getProgram() {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getProgram();
        }
        Curriculum curriculum = this.findLatestCurriculum();
        if (curriculum != null) {
            return curriculum.getProgram();
        }
        return null;
    }

    public String getProgramEn(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getProgramEn(period);
        }
        Curriculum curriculum = this.findLatestCurriculum();
        if (curriculum != null) {
            return curriculum.getProgramEn();
        }
        return null;
    }

    public String getProgramEn() {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getProgramEn();
        }
        Curriculum curriculum = this.findLatestCurriculum();
        if (curriculum != null) {
            return curriculum.getProgramEn();
        }
        return null;
    }

    public MultiLanguageString getProgramI18N(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourse().getProgramI18N(period);
        }
        Curriculum curriculum = this.findLatestCurriculumModifiedBefore(period.getExecutionYear().getEndDate());
        if (curriculum != null) {
            return curriculum.getProgramI18N();
        }
        return new MultiLanguageString();
    }

    public MultiLanguageString getPrerequisitesI18N() {
        return new MultiLanguageString(MultiLanguageString.pt, this.getPrerequisites()).with(MultiLanguageString.en, this.getPrerequisitesEn());
    }

    public String getEvaluationMethod(ExecutionSemester period) {
        if (this.getCompetenceCourse() != null) {
            return this.getCompetenceCourse().getEvaluationMethod(period);
        }
        if (this.hasAnyExecutionCourseIn(period)) {
            return this.getExecutionCoursesByExecutionPeriod(period).iterator().next().getEvaluationMethodText();
        }
        return null;
    }

    public String getEvaluationMethod() {
        if (this.getCompetenceCourse() != null) {
            return this.getCompetenceCourse().getEvaluationMethod();
        }
        return null;
    }

    public String getEvaluationMethodEn(ExecutionSemester period) {
        if (this.getCompetenceCourse() != null) {
            return this.getCompetenceCourse().getEvaluationMethodEn(period);
        }
        if (this.hasAnyExecutionCourseIn(period)) {
            return this.getExecutionCoursesByExecutionPeriod(period).iterator().next().getEvaluationMethodTextEn();
        }
        return null;
    }

    public String getEvaluationMethodEn() {
        if (this.getCompetenceCourse() != null) {
            return this.getCompetenceCourse().getEvaluationMethodEn();
        }
        return null;
    }

    public MultiLanguageString getEvaluationMethodI18N(ExecutionSemester period) {
        if (this.isBolonhaDegree()) {
            return new MultiLanguageString(MultiLanguageString.pt, this.getCompetenceCourse().getEvaluationMethod(period)).with(MultiLanguageString.en, this.getCompetenceCourse().getEvaluationMethodEn(period));
        }
        List<ExecutionCourse> courses = this.getExecutionCoursesByExecutionPeriod(period);
        if (courses.isEmpty()) {
            return new MultiLanguageString();
        }
        return new MultiLanguageString(MultiLanguageString.pt, courses.iterator().next().getEvaluationMethodText()).with(MultiLanguageString.en, courses.iterator().next().getEvaluationMethodTextEn());
    }

    public RegimeType getRegime(ExecutionSemester period) {
        CompetenceCourse competenceCourse = this.getCompetenceCourse();
        return competenceCourse == null ? null : competenceCourse.getRegime(period);
    }

    public RegimeType getRegime(ExecutionYear executionYear) {
        CompetenceCourse competenceCourse = this.getCompetenceCourse();
        return competenceCourse == null ? null : competenceCourse.getRegime(executionYear);
    }

    public RegimeType getRegime() {
        if (this.getCompetenceCourse() != null) {
            return this.getCompetenceCourse().getRegime();
        }
        return this.isOptionalCurricularCourse() ? RegimeType.SEMESTRIAL : null;
    }

    public boolean hasRegime() {
        return this.getRegime() != null;
    }

    public boolean hasRegime(ExecutionYear executionYear) {
        return this.getRegime(executionYear) != null;
    }

    @Deprecated
    public final boolean isPropaedeutic() {
        return this.getType().equals((Object)CurricularCourseType.P_TYPE_COURSE);
    }

    public boolean isOptionalCurricularCourse() {
        return false;
    }

    public final boolean isOptional() {
        return this.getType() == CurricularCourseType.OPTIONAL_COURSE;
    }

    public final boolean isTFC() {
        return this.getType() == CurricularCourseType.TFC_COURSE;
    }

    public boolean isDissertation() {
        CompetenceCourse competenceCourse = this.getCompetenceCourse();
        return competenceCourse == null ? false : competenceCourse.isDissertation();
    }

    public boolean isAnual() {
        if (!this.isBolonhaDegree()) {
            return this.getRegimeType() == RegimeType.ANUAL;
        }
        return this.getCompetenceCourse() != null && this.getCompetenceCourse().isAnual();
    }

    public boolean isAnual(ExecutionYear executionYear) {
        if (!this.isBolonhaDegree()) {
            return this.getRegimeType() == RegimeType.ANUAL;
        }
        return this.getCompetenceCourse() != null && this.getCompetenceCourse().isAnual(executionYear);
    }

    public boolean isSemestrial(ExecutionYear executionYear) {
        if (!this.isBolonhaDegree()) {
            return this.getRegimeType() == RegimeType.SEMESTRIAL;
        }
        return this.getCompetenceCourse() != null && this.getCompetenceCourse().isSemestrial(executionYear);
    }

    public boolean isEquivalent(CurricularCourse oldCurricularCourse) {
        return this.equals((Object)oldCurricularCourse) || this.getCompetenceCourse() != null && this.getCompetenceCourse().getAssociatedCurricularCoursesSet().contains((Object)oldCurricularCourse);
    }

    public boolean hasScopeForCurricularYear(Integer curricularYear, ExecutionSemester executionSemester) {
        for (DegreeModuleScope degreeModuleScope : this.getDegreeModuleScopes()) {
            if (!degreeModuleScope.isActiveForExecutionPeriod(executionSemester) || !degreeModuleScope.getCurricularYear().equals(curricularYear)) continue;
            return true;
        }
        return false;
    }

    public static List<CurricularCourse> readByCurricularStage(CurricularStage curricularStage) {
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        for (CurricularCourse curricularCourse : CurricularCourse.readCurricularCourses()) {
            if (curricularCourse.getCurricularStage() == null || !curricularCourse.getCurricularStage().equals((Object)curricularStage)) continue;
            result.add(curricularCourse);
        }
        return result;
    }

    public Set<CurricularCourseScope> findCurricularCourseScopesIntersectingPeriod(Date beginDate, Date endDate) {
        HashSet<CurricularCourseScope> curricularCourseScopes = new HashSet<CurricularCourseScope>();
        for (CurricularCourseScope curricularCourseScope : this.getScopesSet()) {
            if (!curricularCourseScope.intersects(beginDate, endDate)) continue;
            curricularCourseScopes.add(curricularCourseScope);
        }
        return curricularCourseScopes;
    }

    public Set<CurricularCourseScope> findCurricularCourseScopesIntersectingExecutionCourse(ExecutionCourse executionCourse) {
        AcademicInterval academicInterval = executionCourse.getAcademicInterval();
        return this.findCurricularCourseScopesIntersectingPeriod(academicInterval.getStart().toDate(), academicInterval.getEnd().toDate());
    }

    public Set<Enrolment> getEnrolmentsNotInAnyMarkSheet(EvaluationSeason season, ExecutionSemester executionSemester) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrolment = (Enrolment)((Object)curriculumModule);
            if (enrolment.isValid(executionSemester) && (season.isSpecialAuthorization() || season.equals(enrolment.getEvaluationSeason()) && !enrolment.hasAssociatedMarkSheetOrFinalGrade(season))) {
                result.add(enrolment);
                continue;
            }
            if (!season.isImprovement() || !enrolment.hasImprovementFor(executionSemester) || enrolment.hasAssociatedMarkSheet(season)) continue;
            result.add(enrolment);
        }
        if (season.isImprovement()) {
            this.addImprovementEnrolmentsFromEquivalentCourses(result, executionSemester, season);
        }
        return result;
    }

    private void addImprovementEnrolmentsFromEquivalentCourses(Set<Enrolment> result, ExecutionSemester executionSemester, EvaluationSeason season) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        for (CurricularCourseEquivalence equivalence : this.getCurricularCourseEquivalencesSet()) {
            if (!equivalence.isFrom(degreeCurricularPlan)) continue;
            this.addImprovementEnrolments(equivalence, result, executionSemester, season);
        }
    }

    private void addImprovementEnrolments(CurricularCourseEquivalence equivalence, Set<Enrolment> result, ExecutionSemester executionSemester, EvaluationSeason season) {
        for (CurricularCourse curricularCourse : equivalence.getOldCurricularCoursesSet()) {
            if (!curricularCourse.getDegreeCurricularPlan().isBolonhaDegree()) continue;
            for (CurriculumModule module : curricularCourse.getCurriculumModulesSet()) {
                Enrolment enrolment;
                if (!module.isEnrolment() || !(enrolment = (Enrolment)((Object)module)).hasImprovementFor(executionSemester) || enrolment.hasAssociatedMarkSheet(season)) continue;
                result.add(enrolment);
            }
        }
    }

    public Set<Enrolment> getEnrolmentsNotInAnyMarkSheetForOldMarkSheets(EvaluationSeason season, ExecutionSemester executionSemester) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrolment = (Enrolment)((Object)curriculumModule);
            if (enrolment.isValid(executionSemester) && season.equals(enrolment.getEvaluationSeason())) {
                if (!season.isSpecialAuthorization() && !enrolment.canBeSubmittedForOldMarkSheet(season)) continue;
                result.add(enrolment);
                continue;
            }
            if (!season.isImprovement() || !enrolment.hasImprovementFor(executionSemester) || !enrolment.canBeSubmittedForOldMarkSheet(season)) continue;
            result.add(enrolment);
        }
        return result;
    }

    private boolean hasEnrolmentsNotInAnyMarkSheet(ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrolment = (Enrolment)((Object)curriculumModule);
            if (enrolment.isValid(executionSemester) && enrolment.getEvaluationSeason().isNormal() && !enrolment.hasAssociatedMarkSheetOrFinalGrade(EvaluationSeason.readNormalSeason())) {
                return true;
            }
            if (!enrolment.hasImprovement() || enrolment.hasAssociatedMarkSheet(EvaluationSeason.readImprovementSeason()) || !enrolment.hasImprovementFor(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public MarkSheet createNormalMarkSheet(ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, Boolean submittedByTeacher, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person person) {
        return MarkSheet.createNormal(this, executionSemester, responsibleTeacher, evaluationDate, season, submittedByTeacher, evaluationBeans, person);
    }

    public MarkSheet createOldNormalMarkSheet(ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person person) {
        return MarkSheet.createOldNormal(this, executionSemester, responsibleTeacher, evaluationDate, season, evaluationBeans, person);
    }

    public MarkSheet rectifyEnrolmentEvaluation(MarkSheet markSheet, EnrolmentEvaluation enrolmentEvaluation, Date evaluationDate, Grade grade, String reason, Person person) {
        if (markSheet == null || evaluationDate == null || grade.isEmpty()) {
            throw new DomainException("error.markSheet.invalid.arguments", new String[0]);
        }
        if (!markSheet.getEnrolmentEvaluationsSet().contains((Object)enrolmentEvaluation)) {
            throw new DomainException("error.no.student.in.markSheet", new String[0]);
        }
        if (markSheet.isNotConfirmed()) {
            throw new DomainException("error.markSheet.must.be.confirmed", new String[0]);
        }
        if (enrolmentEvaluation.getRectification() != null) {
            throw new DomainException("error.markSheet.student.alreadyRectified", enrolmentEvaluation.getEnrolment().getStudentCurricularPlan().getRegistration().getNumber().toString());
        }
        enrolmentEvaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
        MarkSheet rectificationMarkSheet = this.createRectificationMarkSheet(markSheet.getExecutionPeriod(), evaluationDate, markSheet.getResponsibleTeacher(), markSheet.getEvaluationSeason(), reason, new MarkSheetEnrolmentEvaluationBean(enrolmentEvaluation.getEnrolment(), evaluationDate, grade), person);
        ((EnrolmentEvaluation)((Object)rectificationMarkSheet.getEnrolmentEvaluationsSet().iterator().next())).setRectified(enrolmentEvaluation);
        return rectificationMarkSheet;
    }

    public MarkSheet rectifyOldEnrolmentEvaluation(EnrolmentEvaluation enrolmentEvaluation, EvaluationSeason season, Date evaluationDate, Grade newGrade, String reason, Person person) {
        if (enrolmentEvaluation == null || evaluationDate == null || newGrade.isEmpty()) {
            throw new DomainException("error.markSheet.invalid.arguments", new String[0]);
        }
        if (enrolmentEvaluation.getRectification() != null) {
            throw new DomainException("error.markSheet.student.alreadyRectified", enrolmentEvaluation.getEnrolment().getStudentCurricularPlan().getRegistration().getNumber().toString());
        }
        enrolmentEvaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
        MarkSheet rectificationMarkSheet = this.createRectificationOldMarkSheet(enrolmentEvaluation.getExecutionPeriod(), evaluationDate, enrolmentEvaluation.getPersonResponsibleForGrade().getTeacher(), season, reason, new MarkSheetEnrolmentEvaluationBean(enrolmentEvaluation.getEnrolment(), evaluationDate, newGrade), person);
        ((EnrolmentEvaluation)((Object)rectificationMarkSheet.getEnrolmentEvaluationsSet().iterator().next())).setRectified(enrolmentEvaluation);
        return rectificationMarkSheet;
    }

    private MarkSheet createRectificationMarkSheet(ExecutionSemester executionSemester, Date evaluationDate, Teacher responsibleTeacher, EvaluationSeason season, String reason, MarkSheetEnrolmentEvaluationBean evaluationBean, Person person) {
        return MarkSheet.createRectification(this, executionSemester, responsibleTeacher, evaluationDate, season, reason, evaluationBean, person);
    }

    public MarkSheet createRectificationOldMarkSheet(ExecutionSemester executionSemester, Date evaluationDate, Teacher responsibleTeacher, EvaluationSeason season, String reason, MarkSheetEnrolmentEvaluationBean evaluationBean, Person person) {
        return MarkSheet.createOldRectification(this, executionSemester, responsibleTeacher, evaluationDate, season, reason, evaluationBean, person);
    }

    public Collection<MarkSheet> searchMarkSheets(ExecutionSemester executionSemester, Teacher teacher, Date evaluationDate, MarkSheetState markSheetState, EvaluationSeason season) {
        String dateFormat = "dd/MM/yyyy";
        HashSet<MarkSheet> result = new HashSet<MarkSheet>();
        for (MarkSheet markSheet : this.getMarkSheetsSet()) {
            if (executionSemester != null && markSheet.getExecutionPeriod() != executionSemester || teacher != null && markSheet.getResponsibleTeacher() != teacher || evaluationDate != null && DateFormatUtil.compareDates("dd/MM/yyyy", evaluationDate, markSheet.getEvaluationDateDateTime().toDate()) != 0 || markSheetState != null && markSheet.getMarkSheetState() != markSheetState || season != null && !markSheet.getEvaluationSeason().equals(season)) continue;
            result.add(markSheet);
        }
        return result;
    }

    public boolean hasScopeInGivenSemesterAndCurricularYearInDCP(CurricularYear curricularYear, DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester) {
        if (degreeCurricularPlan == null || this.getDegreeCurricularPlan().equals((Object)degreeCurricularPlan)) {
            for (DegreeModuleScope degreeModuleScope : this.getDegreeModuleScopes()) {
                if (!degreeModuleScope.isActiveForExecutionPeriod(executionSemester) || curricularYear != null && !degreeModuleScope.getCurricularYear().equals(curricularYear.getYear())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGradeSubmissionAvailableFor(ExecutionSemester executionSemester) {
        return EvaluationSeason.all().anyMatch(s -> s.isGradeSubmissionAvailable(this, executionSemester));
    }

    public ExecutionDegree getExecutionDegreeFor(AcademicInterval academicInterval) {
        return this.getDegreeCurricularPlan().getExecutionDegreeByAcademicInterval(academicInterval);
    }

    @Deprecated
    public ExecutionDegree getExecutionDegreeFor(ExecutionYear executionYear) {
        return this.getDegreeCurricularPlan().getExecutionDegreeByYear(executionYear);
    }

    public boolean hasAnyDegreeGradeToSubmit(ExecutionSemester period) {
        return this.hasEnrolmentsNotInAnyMarkSheet(period);
    }

    public boolean hasAnyDegreeMarkSheetToConfirm(ExecutionSemester period) {
        for (MarkSheet markSheet : this.getMarkSheetsSet()) {
            if (!markSheet.getExecutionPeriod().equals(period) || !markSheet.isNotConfirmed()) continue;
            return true;
        }
        return false;
    }

    public List<DegreeModuleScope> getDegreeModuleScopes() {
        return DegreeModuleScope.getDegreeModuleScopes(this);
    }

    private int countAssociatedStudentsByExecutionPeriodAndEnrolmentNumber(ExecutionSemester executionSemester, int enrolmentNumber) {
        int curricularCourseAndExecutionPeriodAssociatedStudents = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolmentsEntry;
            if (!curriculumModule.isEnrolment() || (enrolmentsEntry = (Enrolment)((Object)curriculumModule)).getExecutionPeriod() != executionSemester) continue;
            StudentCurricularPlan studentCurricularPlanEntry = enrolmentsEntry.getStudentCurricularPlan();
            int numberOfEnrolmentsForThatCurricularCourseAndExecutionPeriod = 0;
            for (Enrolment enrolmentsFromStudentCPEntry : studentCurricularPlanEntry.getEnrolmentsSet()) {
                if (enrolmentsFromStudentCPEntry.getCurricularCourse() != this || enrolmentsFromStudentCPEntry.getExecutionPeriod().compareTo(executionSemester) > 0) continue;
                ++numberOfEnrolmentsForThatCurricularCourseAndExecutionPeriod;
            }
            if (numberOfEnrolmentsForThatCurricularCourseAndExecutionPeriod != enrolmentNumber) continue;
            ++curricularCourseAndExecutionPeriodAssociatedStudents;
        }
        return curricularCourseAndExecutionPeriodAssociatedStudents;
    }

    public Integer getTotalEnrolmentStudentNumber(ExecutionSemester executionSemester) {
        int curricularCourseAndExecutionPeriodStudentNumber = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolmentsEntry;
            if (!curriculumModule.isEnrolment() || (enrolmentsEntry = (Enrolment)((Object)curriculumModule)).getExecutionPeriod() != executionSemester) continue;
            ++curricularCourseAndExecutionPeriodStudentNumber;
        }
        return curricularCourseAndExecutionPeriodStudentNumber;
    }

    public Integer getFirstTimeEnrolmentStudentNumber(ExecutionSemester executionSemester) {
        return this.countAssociatedStudentsByExecutionPeriodAndEnrolmentNumber(executionSemester, 1);
    }

    public Integer getSecondTimeEnrolmentStudentNumber(ExecutionSemester executionSemester) {
        return this.getTotalEnrolmentStudentNumber(executionSemester) - this.getFirstTimeEnrolmentStudentNumber(executionSemester);
    }

    public List<ExecutionCourse> getMostRecentExecutionCourses() {
        for (ExecutionSemester period = ExecutionSemester.readActualExecutionSemester(); period != null; period = period.getPreviousExecutionPeriod()) {
            List<ExecutionCourse> executionCourses = this.getExecutionCoursesByExecutionPeriod(period);
            if (executionCourses == null || executionCourses.isEmpty()) continue;
            return executionCourses;
        }
        return new ArrayList<ExecutionCourse>();
    }

    public boolean isActive(ExecutionYear executionYear) {
        ExecutionYear executionYearToCheck = executionYear == null ? ExecutionYear.readCurrentExecutionYear() : executionYear;
        for (ExecutionSemester executionSemester : executionYearToCheck.getExecutionPeriodsSet()) {
            if (!this.isActive(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(ExecutionSemester executionSemester) {
        return this.getActiveScopesInExecutionPeriod(executionSemester).size() > 0 || this.getActiveDegreeModuleScopesInExecutionPeriod(executionSemester).size() > 0;
    }

    public boolean hasEnrolmentForPeriod(ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || (enrolment = (Enrolment)((Object)curriculumModule)).isAnnulled() || enrolment.getExecutionPeriod() != executionSemester) continue;
            return true;
        }
        return false;
    }

    public void getAllDegreeModules(Collection<DegreeModule> degreeModules) {
        degreeModules.add((DegreeModule)((Object)this));
    }

    public List<CurricularCourseEquivalence> getOldCurricularCourseEquivalences(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<CurricularCourseEquivalence> result = new ArrayList<CurricularCourseEquivalence>();
        for (CurricularCourseEquivalence curricularCourseEquivalence : this.getOldCurricularCourseEquivalencesSet()) {
            if (!curricularCourseEquivalence.isFrom(degreeCurricularPlan)) continue;
            result.add(curricularCourseEquivalence);
        }
        return result;
    }

    public List<CurricularCourseEquivalence> getCurricularCourseEquivalencesFor(CurricularCourse equivalentCurricularCourse) {
        ArrayList<CurricularCourseEquivalence> result = new ArrayList<CurricularCourseEquivalence>();
        for (CurricularCourseEquivalence curricularCourseEquivalence : this.getOldCurricularCourseEquivalencesSet()) {
            if (curricularCourseEquivalence.getEquivalentCurricularCourse() != equivalentCurricularCourse) continue;
            result.add(curricularCourseEquivalence);
        }
        return result;
    }

    public boolean isCurricularCourse() {
        return true;
    }

    public DegreeModuleScope getOldestDegreeModuleScope() {
        ArrayList<DegreeModuleScope> scopes = new ArrayList<DegreeModuleScope>(this.getDegreeModuleScopes());
        Collections.sort(scopes, DegreeModuleScope.COMPARATOR_BY_CURRICULAR_YEAR_AND_SEMESTER_AND_CURRICULAR_COURSE_NAME);
        return (DegreeModuleScope)scopes.iterator().next();
    }

    public Integer getMinimumValueForAcumulatedEnrollments() {
        return super.getMinimumValueForAcumulatedEnrollments() == null ? Integer.valueOf(0) : super.getMinimumValueForAcumulatedEnrollments();
    }

    public Integer getMaximumValueForAcumulatedEnrollments() {
        return super.getMaximumValueForAcumulatedEnrollments() == null ? Integer.valueOf(0) : super.getMaximumValueForAcumulatedEnrollments();
    }

    public BigDecimal getTotalHoursByShiftType(ShiftType type, ExecutionSemester executionSemester) {
        if (type != null) {
            Double hours = null;
            switch (type) {
                case TEORICA: {
                    hours = this.getTheoreticalHours(executionSemester);
                    break;
                }
                case TEORICO_PRATICA: {
                    hours = this.getTheoPratHours();
                    break;
                }
                case PRATICA: {
                    hours = this.getPraticalHours();
                    break;
                }
                case PROBLEMS: {
                    hours = this.getProblemsHours(executionSemester);
                    break;
                }
                case LABORATORIAL: {
                    hours = this.getLabHours(executionSemester);
                    break;
                }
                case TRAINING_PERIOD: {
                    hours = this.getTrainingPeriodHours(executionSemester);
                    break;
                }
                case SEMINARY: {
                    hours = this.getSeminaryHours(executionSemester);
                    break;
                }
                case TUTORIAL_ORIENTATION: {
                    hours = this.getTutorialOrientationHours(executionSemester);
                    break;
                }
                case FIELD_WORK: {
                    hours = this.getFieldWorkHours(executionSemester);
                    break;
                }
            }
            return hours != null ? BigDecimal.valueOf(hours).multiply(BigDecimal.valueOf(CompetenceCourseLoad.NUMBER_OF_WEEKS)) : null;
        }
        return null;
    }

    public boolean hasAnyExecutionCourseIn(ExecutionSemester executionSemester) {
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            if (!executionCourse.getExecutionPeriod().equals(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public Set<CurricularCourse> getAllCurricularCourses() {
        return Collections.singleton(this);
    }

    public Set<CurricularCourse> getAllCurricularCourses(ExecutionSemester executionSemester) {
        return this.getAllCurricularCourses();
    }

    public boolean getCanCreateMarkSheet() {
        return !this.isDissertation() || this.isDissertation() && MarkSheetPredicates.checkDissertation(this.getDegree());
    }

    public Collection<MarkSheet> getMarkSheetsByPeriod(ExecutionSemester executionSemester) {
        HashSet<MarkSheet> markSheets = new HashSet<MarkSheet>();
        for (MarkSheet markSheet : this.getMarkSheetsSet()) {
            if (markSheet.getExecutionPeriod() != executionSemester) continue;
            markSheets.add(markSheet);
        }
        return markSheets;
    }

    public void doForAllCurricularCourses(CurricularCourseFunctor curricularCourseFunctor) {
        curricularCourseFunctor.doWith(this);
    }

    public CompetenceCourseLevel getCompetenceCourseLevel() {
        return this.getCompetenceCourse() != null ? this.getCompetenceCourse().getCompetenceCourseLevel() : null;
    }

    public boolean hasCompetenceCourseLevel() {
        return this.getCompetenceCourseLevel() != null;
    }

    public List<EnrolmentEvaluation> getEnrolmentEvaluationsForOldMarkSheet(ExecutionSemester executionSemester, EvaluationSeason season) {
        ArrayList<EnrolmentEvaluation> res = new ArrayList<EnrolmentEvaluation>();
        for (Enrolment enrolment : this.getEnrolments()) {
            EnrolmentEvaluation latestEnrolmentEvaluationBy;
            if (season.isImprovement()) {
                latestEnrolmentEvaluationBy = enrolment.getLatestEnrolmentEvaluationBySeason(season);
                if (latestEnrolmentEvaluationBy == null || !latestEnrolmentEvaluationBy.getExecutionPeriod().equals(executionSemester) || !latestEnrolmentEvaluationBy.isFinal() || latestEnrolmentEvaluationBy.getExamDateYearMonthDay() == null) continue;
                res.add(latestEnrolmentEvaluationBy);
                continue;
            }
            if (!enrolment.isValid(executionSemester) || (latestEnrolmentEvaluationBy = enrolment.getLatestEnrolmentEvaluationBySeason(season)) == null || !latestEnrolmentEvaluationBy.isFinal() || latestEnrolmentEvaluationBy.getExamDateYearMonthDay() == null) continue;
            res.add(latestEnrolmentEvaluationBy);
        }
        return res;
    }

    public boolean hasExecutionDegreeByYearAndCampus(ExecutionYear executionYear, Space campus) {
        return this.getDegreeCurricularPlan().hasExecutionDegreeByYearAndCampus(executionYear, campus);
    }

    public boolean hasAnyExecutionDegreeFor(ExecutionYear executionYear) {
        return this.getDegreeCurricularPlan().hasAnyExecutionDegreeFor(executionYear);
    }

    public void applyToCurricularCourses(ExecutionYear executionYear, Predicate predicate) {
        predicate.evaluate((Object)this);
    }

    public void addAssociatedExecutionCourses(ExecutionCourse associatedExecutionCourses) {
        Set executionCourses = this.getAssociatedExecutionCoursesSet();
        for (ExecutionCourse executionCourse : executionCourses) {
            if (associatedExecutionCourses == executionCourse || executionCourse.getExecutionPeriod() != associatedExecutionCourses.getExecutionPeriod()) continue;
            throw new DomainException("error.executionCourse.curricularCourse.already.associated", new String[0]);
        }
        super.addAssociatedExecutionCourses(associatedExecutionCourses);
    }

    public String getCodeAndName(ExecutionInterval executionInterval) {
        String code = this.getCode();
        String name = this.getNameI18N(executionInterval).getContent();
        return (StringUtils.isEmpty((String)code) ? "" : code + " - ") + name;
    }

    public String getCode() {
        if (this.getCompetenceCourse() != null) {
            return this.getCompetenceCourse().getCode();
        }
        return super.getCode();
    }

    public void setWeight(BigDecimal input) {
        super.setWeigth(input == null ? null : Double.valueOf(input.doubleValue()));
    }

    @Deprecated
    public Double getBaseWeight() {
        return super.getWeigth();
    }

    public static class CurriculumFactory
    implements Serializable {
        private CurricularCourse curricularCourse;
        private String program;
        private String programEn;
        private String generalObjectives;
        private String generalObjectivesEn;
        private String operacionalObjectives;
        private String operacionalObjectivesEn;
        private DateTime lastModification;

        public CurriculumFactory(CurricularCourse curricularCourse) {
            this.setCurricularCourse(curricularCourse);
        }

        public String getGeneralObjectives() {
            return this.generalObjectives;
        }

        public void setGeneralObjectives(String generalObjectives) {
            this.generalObjectives = generalObjectives;
        }

        public String getGeneralObjectivesEn() {
            return this.generalObjectivesEn;
        }

        public void setGeneralObjectivesEn(String generalObjectivesEn) {
            this.generalObjectivesEn = generalObjectivesEn;
        }

        public String getOperacionalObjectives() {
            return this.operacionalObjectives;
        }

        public void setOperacionalObjectives(String operacionalObjectives) {
            this.operacionalObjectives = operacionalObjectives;
        }

        public String getOperacionalObjectivesEn() {
            return this.operacionalObjectivesEn;
        }

        public void setOperacionalObjectivesEn(String operacionalObjectivesEn) {
            this.operacionalObjectivesEn = operacionalObjectivesEn;
        }

        public String getProgram() {
            return this.program;
        }

        public void setProgram(String program) {
            this.program = program;
        }

        public String getProgramEn() {
            return this.programEn;
        }

        public void setProgramEn(String programEn) {
            this.programEn = programEn;
        }

        public DateTime getLastModification() {
            return this.lastModification;
        }

        public void setLastModification(DateTime lastModification) {
            this.lastModification = lastModification;
        }

        public CurricularCourse getCurricularCourse() {
            return this.curricularCourse;
        }

        public void setCurricularCourse(CurricularCourse curricularCourse) {
            this.curricularCourse = curricularCourse;
        }

        public String getObjectives() {
            if (!StringUtils.isEmpty((String)this.getGeneralObjectives()) && !StringUtils.isEmpty((String)this.getOperacionalObjectives())) {
                return this.getGeneralObjectives() + " " + this.getOperacionalObjectives();
            }
            return null;
        }

        public String getObjectivesEn() {
            if (!StringUtils.isEmpty((String)this.getGeneralObjectivesEn()) && !StringUtils.isEmpty((String)this.getOperacionalObjectivesEn())) {
                return this.getGeneralObjectivesEn() + " " + this.getOperacionalObjectivesEn();
            }
            return null;
        }
    }
}

