/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.enrollment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentPreConditions;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.student.enrollment.bolonha.CycleEnrolmentBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolInAffinityCycle;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.LocalDate;

@StrutsFunctionality(app=StudentApplication.StudentEnrollApp.class, path="courses", titleKey="link.student.enrollment")
@Mapping(module="student", path="/studentEnrollmentManagement")
@Forwards(value={@Forward(name="notAuthorized", path="/student/notAuthorized_bd.jsp"), @Forward(name="chooseRegistration", path="/student/enrollment/chooseRegistration.jsp"), @Forward(name="choosePersonalDataAuthorizationChoice", path="/student/enrollment/choosePersonalDataAuthorizationChoice.jsp"), @Forward(name="proceedToEnrolment", path="/student/bolonhaStudentEnrollment.do?method=showWelcome"), @Forward(name="showAffinityToEnrol", path="/student/enrollment/bolonha/showAffinityToEnrol.jsp"), @Forward(name="chooseSemester", path="/student/enrollment/chooseSemester.jsp"), @Forward(name="selectAffinityToEnrol", path="/student/enrollment/bolonha/selectAffinityToEnrol.jsp"), @Forward(name="enrollmentCannotProceed", path="/student/enrollment/bolonha/enrollmentCannotProceed.jsp")})
public class StudentEnrollmentManagementDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getLoggedStudent(request);
        if (!student.hasFilledAuthorizationInformationInCurrentExecutionYear()) {
            request.setAttribute("student", (Object)student);
            return mapping.findForward("choosePersonalDataAuthorizationChoice");
        }
        ExecutionSemester executionSemester = ExecutionSemester.readActualExecutionSemester();
        request.setAttribute("executionSemester", (Object)executionSemester);
        List<Registration> registrationsToEnrol = this.getRegistrationsToEnrolByStudent(request);
        if (registrationsToEnrol.size() == 1) {
            Registration registration = registrationsToEnrol.iterator().next();
            request.setAttribute("registration", (Object)registration);
            return this.getActionForwardForRegistration(mapping, request, registration, executionSemester);
        }
        request.setAttribute("registrationsToEnrol", registrationsToEnrol);
        request.setAttribute("registrationsToChooseSecondCycle", this.getRegistrationsToChooseSecondCycle(student));
        return mapping.findForward("chooseRegistration");
    }

    private List<Registration> getRegistrationsToChooseSecondCycle(Student student) {
        ArrayList result = Lists.newArrayList();
        if (!Registration.getEnrolmentsAllowStudentToCreateRegistrationForAffinityCycle().booleanValue()) {
            return result;
        }
        for (Registration registration : student.getRegistrationsSet()) {
            CycleCurriculumGroup firstCycle;
            StudentCurricularPlan studentCurricularPlan;
            if (!registration.isBolonha() || !registration.isConcluded() || (studentCurricularPlan = registration.getLastStudentCurricularPlan()).getDegreeType().isBolonhaMasterDegree() || (firstCycle = studentCurricularPlan.getFirstCycle()) == null || !firstCycle.isConcluded() || studentCurricularPlan.hasAnyActiveRegistrationWithFirstCycleAffinity()) continue;
            result.add(registration);
        }
        return result;
    }

    private ActionForward getActionForwardForRegistration(ActionMapping mapping, HttpServletRequest request, Registration registration, ExecutionSemester executionSemester) {
        StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(studentCurricularPlan.getPerson(), new LocalDate())) {
            request.setAttribute("debtsMessage", (Object)"error.StudentCurricularPlan.cannot.enrol.with.debts.for.previous.execution.years");
        }
        if (!studentCurricularPlan.isActive() && !studentCurricularPlan.getRegistration().isConcluded()) {
            request.setAttribute("registrationsToEnrol", Collections.singletonList(registration));
            this.addActionMessage(request, "error.studentCurricularPlan.is.not.active.or.concluded");
            return mapping.findForward("chooseRegistration");
        }
        if (studentCurricularPlan.getDegreeType().isBolonhaMasterDegree()) {
            request.setAttribute("registration", (Object)registration);
            return mapping.findForward("proceedToEnrolment");
        }
        CycleCurriculumGroup firstCycle = studentCurricularPlan.getFirstCycle();
        if (firstCycle == null || !firstCycle.isConcluded()) {
            request.setAttribute("registration", (Object)registration);
            return mapping.findForward("proceedToEnrolment");
        }
        if (!Registration.getEnrolmentsAllowStudentToCreateRegistrationForAffinityCycle().booleanValue()) {
            request.setAttribute("registration", (Object)registration);
            return mapping.findForward("proceedToEnrolment");
        }
        CycleCurriculumGroup secondCycle = studentCurricularPlan.getSecondCycle();
        if (secondCycle == null) {
            return this.prepareSelectAffinityToEnrol(mapping, request, studentCurricularPlan, executionSemester);
        }
        if (secondCycle.isExternal()) {
            Student student = studentCurricularPlan.getRegistration().getStudent();
            Registration newRegistration = student.getActiveRegistrationFor(secondCycle.getDegreeCurricularPlanOfDegreeModule());
            if (newRegistration != null) {
                request.setAttribute("registration", (Object)newRegistration);
                return mapping.findForward("proceedToEnrolment");
            }
            return this.showAffinityToEnrol(mapping, request, studentCurricularPlan, executionSemester, secondCycle);
        }
        request.setAttribute("registration", (Object)registration);
        return mapping.findForward("proceedToEnrolment");
    }

    private ActionForward prepareSelectAffinityToEnrol(ActionMapping mapping, HttpServletRequest request, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        if (!this.canContinueToEnrolment(request, studentCurricularPlan, executionSemester)) {
            return mapping.findForward("enrollmentCannotProceed");
        }
        request.setAttribute("cycleEnrolmentBean", (Object)new CycleEnrolmentBean(studentCurricularPlan, executionSemester, CycleType.FIRST_CYCLE, CycleType.SECOND_CYCLE));
        return mapping.findForward("selectAffinityToEnrol");
    }

    private ActionForward showAffinityToEnrol(ActionMapping mapping, HttpServletRequest request, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, CycleCurriculumGroup curriculumGroup) {
        if (!this.canContinueToEnrolment(request, studentCurricularPlan, executionSemester)) {
            return mapping.findForward("enrollmentCannotProceed");
        }
        request.setAttribute("cycleEnrolmentBean", (Object)new CycleEnrolmentBean(studentCurricularPlan, executionSemester, curriculumGroup.getCycleCourseGroup()));
        return mapping.findForward("showAffinityToEnrol");
    }

    public ActionForward showAffinityToEnrol(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CycleEnrolmentBean bean = this.getCycleEnrolmentBeanFromViewState();
        if (!this.canContinueToEnrolment(request, bean.getStudentCurricularPlan(), bean.getExecutionPeriod())) {
            return mapping.findForward("enrollmentCannotProceed");
        }
        request.setAttribute("cycleEnrolmentBean", (Object)bean);
        return mapping.findForward("showAffinityToEnrol");
    }

    private boolean canContinueToEnrolment(HttpServletRequest request, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        StudentCurricularPlanEnrolmentPreConditions.EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkPreConditionsToEnrol(studentCurricularPlan, executionSemester);
        if (!result.isValid()) {
            this.addActionMessage(request, result.message(), result.args());
            return false;
        }
        return true;
    }

    public ActionForward enrolInAffinityCycle(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CycleEnrolmentBean cycleEnrolmentBean = this.getCycleEnrolmentBeanFromViewState();
        try {
            Registration registration = EnrolInAffinityCycle.run(this.getLoggedPerson(request), cycleEnrolmentBean.getStudentCurricularPlan(), cycleEnrolmentBean.getCycleCourseGroupToEnrol(), cycleEnrolmentBean.getExecutionPeriod());
            request.setAttribute("registration", (Object)registration);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage(request, "error.NotAuthorized");
            request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
            return mapping.findForward("showAffinityToEnrol");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("cycleEnrolmentBean", (Object)cycleEnrolmentBean);
            return mapping.findForward("showAffinityToEnrol");
        }
        return mapping.findForward("proceedToEnrolment");
    }

    public ActionForward chooseRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = this.getRegistration(request);
        if (!this.registrationBelongsToRegistrationsToEnrol(request, registration) && !this.getRegistrationsToChooseSecondCycle(registration.getStudent()).contains((Object)registration)) {
            return mapping.findForward("notAuthorized");
        }
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterID");
        request.setAttribute("executionSemester", (Object)executionSemester);
        return this.getActionForwardForRegistration(mapping, request, registration, executionSemester);
    }

    private boolean registrationBelongsToRegistrationsToEnrol(HttpServletRequest request, Registration registration) {
        return this.getRegistrationsToEnrolByStudent(request).contains((Object)registration);
    }

    private Registration getRegistration(HttpServletRequest request) {
        return this.getRegistrationFrom(request, "registrationId");
    }

    private Registration getRegistrationFrom(HttpServletRequest request, String parameterName) {
        return (Registration)((Object)this.getDomainObject(request, parameterName));
    }

    public ActionForward choosePersonalDataAuthorizationChoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepare(mapping, form, request, response);
    }

    private List<Registration> getRegistrationsToEnrolByStudent(HttpServletRequest request) {
        return this.getLoggedStudent(request).getRegistrationsToEnrolByStudent();
    }

    private Student getLoggedStudent(HttpServletRequest request) {
        return this.getLoggedPerson(request).getStudent();
    }

    private CycleEnrolmentBean getCycleEnrolmentBeanFromViewState() {
        return (CycleEnrolmentBean)this.getRenderedObject();
    }
}

