/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.DomainObject;

@Mapping(path="/editCandidacyInformation", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="editCandidacyInformation", path="/academicAdminOffice/student/registration/editCandidacyInformation.jsp"), @Forward(name="visualizeStudent", path="/academicAdministration/student.do?method=visualizeStudent")})
public class EditCandidacyInformationDA
extends FenixDispatchAction {
    public ActionForward prepareEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonalInformationBean currentPersonalInformationBean = this.getPersonalInformationBean(request);
        if (currentPersonalInformationBean == null) {
            return mapping.findForward("visualizeStudent");
        }
        request.setAttribute("personalInformationBean", (Object)currentPersonalInformationBean);
        return mapping.findForward("editCandidacyInformation");
    }

    private PersonalInformationBean getPersonalInformationBean(HttpServletRequest request) {
        ChooseRegistrationOrPhd chooseRegistrationOrPhd = (ChooseRegistrationOrPhd)this.getRenderedObject("choosePhdOrRegistration");
        if (chooseRegistrationOrPhd.getPhdRegistrationWrapper() == null) {
            request.setAttribute("studentID", (Object)chooseRegistrationOrPhd.getStudent().getExternalId());
            return null;
        }
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (chooseRegistrationOrPhd.getPhdRegistrationWrapper().isRegistration()) {
            return chooseRegistrationOrPhd.getPhdRegistrationWrapper().getRegistration().getPersonalInformationBean(currentExecutionYear);
        }
        return chooseRegistrationOrPhd.getPhdRegistrationWrapper().getPhdIndividualProgramProcess().getPersonalInformationBean(currentExecutionYear);
    }

    public ActionForward prepareEditInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        request.setAttribute("personalInformationBean", (Object)personalInformationBean);
        return mapping.findForward("editCandidacyInformation");
    }

    public ActionForward prepareEditInstitutionPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        personalInformationBean.resetDegree();
        RenderUtils.invalidateViewState();
        request.setAttribute("personalInformationBean", (Object)personalInformationBean);
        return mapping.findForward("editCandidacyInformation");
    }

    public ActionForward schoolLevelPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        RenderUtils.invalidateViewState((String)"personalInformationBean.editPrecedentDegreeInformation");
        RenderUtils.invalidateViewState((String)"personalInformationBean.editPersonalInformation");
        personalInformationBean.resetInstitutionAndDegree();
        request.setAttribute("personalInformationBean", (Object)personalInformationBean);
        return mapping.findForward("editCandidacyInformation");
    }

    public ActionForward changePostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        RenderUtils.invalidateViewState((String)"personalInformationBean.editPrecedentDegreeInformation");
        request.setAttribute("personalInformationBean", (Object)personalInformationBean);
        return mapping.findForward("editCandidacyInformation");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Set<String> messages;
        PersonalInformationBean personalInformationBean = (PersonalInformationBean)this.getRenderedObject("personalInformationBean");
        if (personalInformationBean.getSchoolLevel() != null && personalInformationBean.getSchoolLevel().isHighSchoolOrEquivalent()) {
            personalInformationBean.setCountryWhereFinishedHighSchoolLevel(personalInformationBean.getCountryWhereFinishedPreviousCompleteDegree());
        }
        if (!(messages = personalInformationBean.validateForAcademicService()).isEmpty()) {
            for (String each : messages) {
                this.addActionMessage(request, each);
            }
            request.setAttribute("personalInformationBean", (Object)personalInformationBean);
            return mapping.findForward("editCandidacyInformation");
        }
        try {
            personalInformationBean.updatePersonalInformation(false);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("personalInformationBean", (Object)personalInformationBean);
            return mapping.findForward("editCandidacyInformation");
        }
        request.setAttribute("studentID", (Object)personalInformationBean.getStudent().getExternalId());
        return mapping.findForward("visualizeStudent");
    }

    public static class ChooseRegistrationOrPhd
    implements Serializable {
        private PhdRegistrationWrapper phdRegistrationWrapper;
        private Student student;

        public ChooseRegistrationOrPhd(Student student) {
            this.setStudent(student);
        }

        public PhdRegistrationWrapper getPhdRegistrationWrapper() {
            return this.phdRegistrationWrapper;
        }

        public void setPhdRegistrationWrapper(PhdRegistrationWrapper phdRegistrationWrapper) {
            this.phdRegistrationWrapper = phdRegistrationWrapper;
        }

        public void setStudent(Student student) {
            this.student = student;
        }

        public Student getStudent() {
            return this.student;
        }
    }

    public static class PhdRegistrationWrapper
    implements Serializable {
        private DomainObject phdOrRegistration;

        public PhdRegistrationWrapper(Registration registration) {
            this.setPhdOrRegistration((DomainObject)registration);
        }

        public PhdRegistrationWrapper(PhdIndividualProgramProcess phdIndividualProgramProcess) {
            this.setPhdOrRegistration((DomainObject)phdIndividualProgramProcess);
        }

        public String getDisplayName() {
            if (this.isRegistration()) {
                return this.getRegistration().getDegreeCurricularPlanName();
            }
            Locale locale = I18N.getLocale();
            StringBuilder stringBuilder = new StringBuilder(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd", (String[])new String[0])).append(" ");
            stringBuilder.append(this.getPhdIndividualProgramProcess().getPhdProgram().getName().getContent(locale));
            return stringBuilder.toString();
        }

        public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
            return (PhdIndividualProgramProcess)this.getPhdOrRegistration();
        }

        public Registration getRegistration() {
            return (Registration)this.getPhdOrRegistration();
        }

        public boolean isRegistration() {
            return this.getPhdOrRegistration() != null && this.getPhdOrRegistration() instanceof Registration;
        }

        public void setPhdOrRegistration(DomainObject phdOrRegistration) {
            this.phdOrRegistration = phdOrRegistration;
        }

        public DomainObject getPhdOrRegistration() {
            return this.phdOrRegistration;
        }

        public int hashCode() {
            if (!this.isRegistration()) {
                return this.getPhdIndividualProgramProcess().getRegistration() != null ? this.getPhdIndividualProgramProcess().getRegistration().hashCode() : this.getPhdIndividualProgramProcess().hashCode();
            }
            return this.getRegistration().hashCode();
        }

        public boolean equals(Object object) {
            if (object != null) {
                PhdRegistrationWrapper phdRegistrationWrapper = (PhdRegistrationWrapper)object;
                return phdRegistrationWrapper.hashCode() == this.hashCode();
            }
            return false;
        }
    }
}

