/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.coordinator.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadCurrentExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadExecutionPeriodsByDegreeCurricularPlan;
import org.fenixedu.academic.service.services.coordinator.ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import pt.ist.fenixframework.FenixFramework;

public class CoordinatorEvaluationManagementBackingBean
extends FenixBackingBean {
    private String degreeCurricularPlanID;
    private HtmlInputHidden degreeCurricularPlanIdHidden;
    private String executionPeriodID;
    private String curricularYearID;
    private HtmlInputHidden executionPeriodIdHidden;
    private HtmlInputHidden curricularYearIdHidden;
    private ExecutionSemester executionSemester;
    private String executionCourseID;
    private HtmlInputHidden executionCourseIdHidden;
    private List<ExecutionCourse> executionCourses;
    private List<SelectItem> executionPeriodsLabels;
    private List<SelectItem> curricularYearsLabels;
    private String evaluationID;
    private HtmlInputHidden evaluationIdHidden;
    protected Evaluation evaluation;
    private Integer day;
    private Integer month;
    private Integer year;
    private HtmlInputHidden dayHidden;
    private HtmlInputHidden monthHidden;
    private HtmlInputHidden yearHidden;
    private String evaluationType;
    private HtmlInputHidden evaluationTypeHidden;
    private ExecutionDegree executionDegree;

    public HtmlInputHidden getDegreeCurricularPlanIdHidden() {
        if (this.degreeCurricularPlanIdHidden == null) {
            String degreeCurricularPlanId = this.getDegreeCurricularPlanID();
            this.degreeCurricularPlanIdHidden = new HtmlInputHidden();
            this.degreeCurricularPlanIdHidden.setValue((Object)degreeCurricularPlanId);
        }
        return this.degreeCurricularPlanIdHidden;
    }

    public void setDegreeCurricularPlanIdHidden(HtmlInputHidden degreeCurricularPlanIdHidden) {
        if (degreeCurricularPlanIdHidden != null) {
            this.setDegreeCurricularPlanID(degreeCurricularPlanIdHidden.getValue().toString());
        }
        this.degreeCurricularPlanIdHidden = degreeCurricularPlanIdHidden;
    }

    public String getDegreeCurricularPlanID() {
        if (this.degreeCurricularPlanID == null) {
            if (this.degreeCurricularPlanIdHidden != null) {
                this.degreeCurricularPlanID = this.degreeCurricularPlanIdHidden.getValue().toString();
            } else if (this.getRequestParameter("degreeCurricularPlanID") != null) {
                this.degreeCurricularPlanID = this.getRequestParameter("degreeCurricularPlanID");
            } else if (this.getRequestAttribute("degreeCurricularPlanID") != null) {
                this.degreeCurricularPlanID = this.getRequestAttribute("degreeCurricularPlanID").toString();
            }
        }
        return this.degreeCurricularPlanID;
    }

    public void setDegreeCurricularPlanID(String degreeCurricularPlanID) {
        this.degreeCurricularPlanID = degreeCurricularPlanID;
    }

    public List<SelectItem> getExecutionPeriodsLabels() {
        if (this.executionPeriodsLabels == null) {
            this.executionPeriodsLabels = new ArrayList<SelectItem>();
            List<InfoExecutionPeriod> infoExecutionPeriods = this.getExecutionPeriods();
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("infoExecutionYear.year")));
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("semester")));
            Collections.sort(infoExecutionPeriods, comparatorChain);
            for (InfoExecutionPeriod infoExecutionPeriod : infoExecutionPeriods) {
                SelectItem selectItem = new SelectItem();
                selectItem.setValue((Object)infoExecutionPeriod.getExternalId());
                selectItem.setLabel(infoExecutionPeriod.getName() + " - " + infoExecutionPeriod.getInfoExecutionYear().getYear());
                this.executionPeriodsLabels.add(selectItem);
            }
        }
        return this.executionPeriodsLabels;
    }

    protected List<InfoExecutionPeriod> getExecutionPeriods() {
        return ReadExecutionPeriodsByDegreeCurricularPlan.run(this.getDegreeCurricularPlanID());
    }

    public List<SelectItem> getCurricularYearsLabels() {
        if (this.curricularYearsLabels == null) {
            this.curricularYearsLabels = new ArrayList<SelectItem>();
            this.curricularYearsLabels.add(new SelectItem((Object)0, "Todos"));
            for (int i = 1; i <= 5; ++i) {
                this.curricularYearsLabels.add(new SelectItem((Object)i, i + " \u00ba"));
            }
        }
        return this.curricularYearsLabels;
    }

    public ExecutionCourse getExecutionCourse() throws FenixServiceException {
        return (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
    }

    protected List<ExecutionCourse> getExecutionCourses() {
        if (this.executionCourses != null) {
            return this.executionCourses;
        }
        try {
            this.executionCourses = ReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear.runReadExecutionCoursesByDegreeCurricularPlanAndExecutionPeriodAndCurricularYear(this.getDegreeCurricularPlanID(), this.getExecutionPeriodID(), this.getCurricularYearID());
            return this.executionCourses;
        }
        catch (NotAuthorizedException notAuthorizedException) {
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
        }
        return new ArrayList<ExecutionCourse>();
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester == null ? (ExecutionSemester)FenixFramework.getDomainObject((String)this.getExecutionCourseID()) : this.executionSemester;
    }

    protected InfoExecutionPeriod getCurrentExecutionPeriod() {
        return ReadCurrentExecutionPeriod.run();
    }

    public List<SelectItem> getExecutionCoursesLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
            result.add(new SelectItem((Object)executionCourse.getExternalId(), executionCourse.getNome()));
        }
        Collections.sort(result, new BeanComparator("label"));
        return result;
    }

    public Evaluation getEvaluation() {
        try {
            if (this.evaluation == null && this.getEvaluationID() != null) {
                this.evaluation = (Evaluation)FenixFramework.getDomainObject((String)this.getEvaluationID());
            }
            return this.evaluation;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getCalendarBeginDate() {
        Date beginDate = this.getExecutionPeriod().getBeginDate();
        ExecutionDegree executionDegree = this.getExecutionDegree();
        if (executionDegree != null) {
            if (this.getExecutionPeriod().getSemester() == 1 && executionDegree.getPeriodLessonsFirstSemester().getStart() != null) {
                beginDate = executionDegree.getPeriodLessonsFirstSemester().getStart();
            } else if (this.getExecutionPeriod().getSemester() == 2 && executionDegree.getPeriodLessonsSecondSemester().getStart() != null) {
                beginDate = executionDegree.getPeriodLessonsSecondSemester().getStart();
            }
        }
        return beginDate;
    }

    public Date getCalendarEndDate() {
        Date endDate = this.getExecutionPeriod().getEndDate();
        ExecutionDegree executionDegree = this.getExecutionDegree();
        if (executionDegree != null) {
            if (this.getExecutionPeriod().getSemester() == 1 && executionDegree.getPeriodExamsFirstSemester().getEnd() != null) {
                endDate = executionDegree.getPeriodExamsFirstSemester().getEnd();
            } else if (this.getExecutionPeriod().getSemester() == 2 && executionDegree.getPeriodExamsSecondSemester().getEnd() != null) {
                endDate = executionDegree.getPeriodExamsSecondSemester().getEnd();
            }
        }
        return endDate;
    }

    private ExecutionDegree getExecutionDegree() {
        if (this.executionDegree == null) {
            for (ExecutionDegree executionDegree : this.getDegreeCurricularPlan().getExecutionDegreesSet()) {
                if (executionDegree.getExecutionYear() != this.getExecutionPeriod().getExecutionYear()) continue;
                this.executionDegree = executionDegree;
                return this.executionDegree;
            }
        }
        return this.executionDegree;
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)this.getDegreeCurricularPlanID());
    }

    protected void setRequestCommonAttributes() {
        this.setRequestAttribute("degreeCurricularPlanID", this.getDegreeCurricularPlanID());
        this.setRequestAttribute("executionPeriodID", this.getExecutionPeriodID());
        this.setRequestAttribute("curricularYearID", this.getCurricularYearID());
    }

    public String selectExecutionCourse() {
        this.setRequestCommonAttributes();
        this.setRequestAttribute("executionCourseID", this.getExecutionCourseID());
        this.setRequestAttribute("day", this.getDay());
        this.setRequestAttribute("month", this.getMonth());
        this.setRequestAttribute("year", this.getYear());
        return this.getEvaluationType();
    }

    public String searchExecutionCourses() {
        this.clearAttributes();
        return "";
    }

    protected void clearAttributes() {
        this.executionCourses = null;
    }

    public String getExecutionCourseID() {
        if (this.executionCourseID == null) {
            if (this.getExecutionCourseIdHidden().getValue() != null) {
                this.executionCourseID = this.getExecutionCourseIdHidden().getValue().toString();
            } else if (this.getRequestParameter("executionCourseID") != null) {
                this.executionCourseID = this.getRequestParameter("executionCourseID");
            } else if (this.getRequestAttribute("executionCourseID") != null) {
                this.executionCourseID = this.getRequestAttribute("executionCourseID").toString();
            }
        }
        return this.executionCourseID;
    }

    public void setExecutionCourseID(String executionCourseID) {
        if (executionCourseID != null) {
            this.getExecutionCourseIdHidden().setValue((Object)executionCourseID);
        }
        this.executionCourseID = executionCourseID;
    }

    public HtmlInputHidden getExecutionCourseIdHidden() {
        if (this.executionCourseIdHidden == null) {
            this.executionCourseIdHidden = new HtmlInputHidden();
            this.executionCourseIdHidden.setValue((Object)this.getExecutionCourseID());
        }
        return this.executionCourseIdHidden;
    }

    public void setExecutionCourseIdHidden(HtmlInputHidden executionCourseIdHidden) {
        if (executionCourseIdHidden != null) {
            this.setExecutionCourseID(executionCourseIdHidden.getValue().toString());
        }
        this.executionCourseIdHidden = executionCourseIdHidden;
    }

    public String getExecutionPeriodID() {
        if (this.executionPeriodID == null) {
            InfoExecutionPeriod currentExecutionPeriod;
            this.executionPeriodID = this.getExecutionPeriodIdHidden().getValue() != null ? this.getExecutionPeriodIdHidden().getValue().toString() : (this.getRequestParameter("executionPeriodID") != null ? this.getRequestParameter("executionPeriodID") : (this.getRequestAttribute("executionPeriodID") != null ? this.getRequestAttribute("executionPeriodID").toString() : ((currentExecutionPeriod = this.getCurrentExecutionPeriod()) != null ? currentExecutionPeriod.getExternalId() : null)));
        }
        return this.executionPeriodID;
    }

    public void setExecutionPeriodID(String executionPeriodID) {
        if (executionPeriodID != null) {
            this.getExecutionPeriodIdHidden().setValue((Object)executionPeriodID);
        }
        this.executionPeriodID = executionPeriodID;
    }

    public String getCurricularYearID() {
        if (this.curricularYearID == null) {
            this.curricularYearID = this.getCurricularYearIdHidden().getValue() != null ? this.getCurricularYearIdHidden().getValue().toString() : (this.getRequestParameter("curricularYearID") != null ? this.getRequestParameter("curricularYearID") : (this.getRequestAttribute("curricularYearID") != null ? this.getRequestAttribute("curricularYearID").toString() : null));
        }
        return this.curricularYearID;
    }

    public void setCurricularYearID(String curricularYearID) {
        if (curricularYearID != null) {
            this.getCurricularYearIdHidden().setValue((Object)curricularYearID);
        }
        this.curricularYearID = curricularYearID;
    }

    public HtmlInputHidden getExecutionPeriodIdHidden() {
        if (this.executionPeriodIdHidden == null) {
            this.executionPeriodIdHidden = new HtmlInputHidden();
            this.executionPeriodIdHidden.setValue((Object)this.getExecutionPeriodID());
        }
        return this.executionPeriodIdHidden;
    }

    public void setExecutionPeriodIdHidden(HtmlInputHidden executionPeriodIdHidden) {
        if (executionPeriodIdHidden != null) {
            this.setExecutionPeriodID(executionPeriodIdHidden.getValue().toString());
        }
        this.executionPeriodIdHidden = executionPeriodIdHidden;
    }

    public HtmlInputHidden getCurricularYearIdHidden() {
        if (this.curricularYearIdHidden == null) {
            this.curricularYearIdHidden = new HtmlInputHidden();
            this.curricularYearIdHidden.setValue((Object)this.getCurricularYearID());
        }
        return this.curricularYearIdHidden;
    }

    public void setCurricularYearIdHidden(HtmlInputHidden curricularYearIdHidden) {
        if (curricularYearIdHidden != null) {
            this.setCurricularYearID(curricularYearIdHidden.getValue().toString());
        }
        this.curricularYearIdHidden = curricularYearIdHidden;
    }

    public String getEvaluationID() {
        if (this.evaluationID == null) {
            if (this.getRequestParameter("evaluationID") != null) {
                this.setEvaluationID(this.getRequestParameter("evaluationID"));
            } else if (this.getEvaluationIdHidden().getValue() != null) {
                this.setEvaluationID(this.getEvaluationIdHidden().getValue().toString());
            }
        }
        return this.evaluationID;
    }

    public void setEvaluationID(String evaluationID) {
        this.evaluationID = evaluationID;
    }

    public HtmlInputHidden getEvaluationIdHidden() {
        if (this.evaluationIdHidden == null) {
            this.evaluationIdHidden = new HtmlInputHidden();
            this.evaluationIdHidden.setValue((Object)this.getEvaluationID());
        }
        return this.evaluationIdHidden;
    }

    public void setEvaluationIdHidden(HtmlInputHidden evaluationIdHidden) {
        if (evaluationIdHidden != null) {
            this.setEvaluationID(evaluationIdHidden.getValue().toString());
        }
        this.evaluationIdHidden = evaluationIdHidden;
    }

    public Integer getDay() {
        if (this.day == null) {
            if (this.getEvaluation() != null) {
                this.setDay(((WrittenEvaluation)((Object)this.getEvaluation())).getDay().get(5));
            } else if (this.getRequestParameter("day") != null) {
                this.setDay(Integer.valueOf(this.getRequestParameter("day")));
            } else if (this.getDayHidden().getValue() != null) {
                this.setDay(Integer.valueOf(this.getDayHidden().getValue().toString()));
            } else if (this.getRequestAttribute("day") != null) {
                this.setDay(Integer.valueOf(this.getRequestAttribute("day").toString()));
            }
        }
        return this.day;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getMonth() {
        if (this.month == null) {
            if (this.getEvaluation() != null) {
                this.setMonth(((WrittenEvaluation)((Object)this.getEvaluation())).getDay().get(2) + 1);
            } else if (this.getRequestParameter("month") != null) {
                this.setMonth(Integer.valueOf(this.getRequestParameter("month")));
            } else if (this.getMonthHidden().getValue() != null) {
                this.setMonth(Integer.valueOf(this.getMonthHidden().getValue().toString()));
            } else if (this.getRequestAttribute("month") != null) {
                this.setMonth(Integer.valueOf(this.getRequestAttribute("month").toString()));
            }
        }
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getYear() {
        if (this.year == null) {
            if (this.getEvaluation() != null) {
                this.setYear(((WrittenEvaluation)((Object)this.getEvaluation())).getDay().get(1));
            } else if (this.getRequestParameter("year") != null) {
                this.setYear(Integer.valueOf(this.getRequestParameter("year")));
            } else if (this.getYearHidden().getValue() != null) {
                this.setYear(Integer.valueOf(this.getYearHidden().getValue().toString()));
            } else if (this.getRequestAttribute("year") != null) {
                this.setYear(Integer.valueOf(this.getRequestAttribute("year").toString()));
            }
        }
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public HtmlInputHidden getDayHidden() {
        if (this.dayHidden == null) {
            this.dayHidden = new HtmlInputHidden();
            this.dayHidden.setValue((Object)this.getDay());
        }
        return this.dayHidden;
    }

    public void setDayHidden(HtmlInputHidden dayHidden) {
        this.dayHidden = dayHidden;
    }

    public HtmlInputHidden getMonthHidden() {
        if (this.monthHidden == null) {
            this.monthHidden = new HtmlInputHidden();
            this.monthHidden.setValue((Object)this.getMonth());
        }
        return this.monthHidden;
    }

    public void setMonthHidden(HtmlInputHidden monthHidden) {
        this.monthHidden = monthHidden;
    }

    public HtmlInputHidden getYearHidden() {
        if (this.yearHidden == null) {
            this.yearHidden = new HtmlInputHidden();
            this.yearHidden.setValue((Object)this.getYear());
        }
        return this.yearHidden;
    }

    public void setYearHidden(HtmlInputHidden yearHidden) {
        this.yearHidden = yearHidden;
    }

    public String getEvaluationType() {
        if (this.evaluationType == null && this.getRequestParameter("evaluationType") != null && !this.getRequestParameter("evaluationType").equals("")) {
            this.evaluationType = this.getRequestParameter("evaluationType");
        }
        return this.evaluationType;
    }

    public void setEvaluationType(String evaluationType) {
        this.evaluationType = evaluationType;
    }

    public HtmlInputHidden getEvaluationTypeHidden() {
        if (this.evaluationTypeHidden == null) {
            this.evaluationTypeHidden = new HtmlInputHidden();
            this.evaluationTypeHidden.setValue((Object)this.getEvaluationType());
        }
        return this.evaluationTypeHidden;
    }

    public void setEvaluationTypeHidden(HtmlInputHidden evaluationTypeHidden) {
        if (evaluationTypeHidden != null) {
            this.setEvaluationType(evaluationTypeHidden.getValue().toString());
        }
        this.evaluationTypeHidden = evaluationTypeHidden;
    }
}

