/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager.executionCourseManagement;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionCoursesByExecutionDegreeIdAndExecutionPeriodIdAndCurYear$callable$run;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadExecutionCoursesByExecutionDegreeIdAndExecutionPeriodIdAndCurYear {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List run(String string, String string2, Integer n) throws FenixServiceException {
        return (List)advice$run.perform((Callable)new ReadExecutionCoursesByExecutionDegreeIdAndExecutionPeriodIdAndCurYear$callable$run(string, string2, n));
    }

    static /* synthetic */ List advised$run(String executionDegreeId, String executionPeriodId, Integer curricularYearInt) throws FenixServiceException {
        List<ExecutionCourse> executionCourseList;
        if (executionPeriodId == null) {
            throw new FenixServiceException("nullExecutionPeriodId");
        }
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId);
        if (executionDegreeId == null && curricularYearInt == null) {
            executionCourseList = executionSemester.getExecutionCoursesWithNoCurricularCourses();
        } else {
            ExecutionDegree executionDegree = ReadExecutionCoursesByExecutionDegreeIdAndExecutionPeriodIdAndCurYear.findExecutionDegreeByID(executionSemester, executionDegreeId);
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            CurricularYear curricularYear = CurricularYear.readByYear(curricularYearInt);
            executionCourseList = executionSemester.getExecutionCoursesByDegreeCurricularPlanAndSemesterAndCurricularYearAndName(degreeCurricularPlan, curricularYear, "%");
        }
        ArrayList<InfoExecutionCourse> infoExecutionCourseList = new ArrayList<InfoExecutionCourse>(executionCourseList.size());
        for (ExecutionCourse executionCourse : executionCourseList) {
            infoExecutionCourseList.add(InfoExecutionCourse.newInfoFromDomain(executionCourse));
        }
        return infoExecutionCourseList;
    }

    private static ExecutionDegree findExecutionDegreeByID(ExecutionSemester executionSemester, String executionDegreeId) {
        ExecutionYear executionYear = executionSemester.getExecutionYear();
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            if (!executionDegree.getExternalId().equals(executionDegreeId)) continue;
            return executionDegree;
        }
        return null;
    }
}

