/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.department;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.dto.department.ExecutionCourseStatisticsDTO;
import org.fenixedu.academic.service.services.department.ComputeCourseStatistics;
import org.fenixedu.academic.service.services.department.ComputeExecutionCourseStatistics$callable$runComputeExecutionCourseStatistics;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ComputeExecutionCourseStatistics
extends ComputeCourseStatistics {
    private static final ComputeExecutionCourseStatistics serviceInstance;
    public static final Advice advice$runComputeExecutionCourseStatistics;

    public List<ExecutionCourseStatisticsDTO> run(CompetenceCourse competenceCourse, Degree degree, ExecutionSemester executionSemester) throws FenixServiceException {
        List<CurricularCourse> curricularCourses = competenceCourse.getAssociatedCurricularCoursesGroupedByDegree().get(degree);
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (CurricularCourse course : curricularCourses) {
            executionCourses.addAll(course.getExecutionCoursesByExecutionPeriod(executionSemester));
        }
        ArrayList<ExecutionCourseStatisticsDTO> results = new ArrayList<ExecutionCourseStatisticsDTO>();
        for (ExecutionCourse executionCourse : executionCourses) {
            ExecutionCourseStatisticsDTO executionCourseStatistics = new ExecutionCourseStatisticsDTO();
            executionCourseStatistics.setExternalId(competenceCourse.getExternalId());
            executionCourseStatistics.setName(competenceCourse.getNameI18N(executionSemester).getContent());
            executionCourseStatistics.setExecutionPeriod(executionCourse.getExecutionPeriod().getName());
            executionCourseStatistics.setTeachers(this.getResponsibleTeachersName(executionCourse));
            executionCourseStatistics.setExecutionYear(executionCourse.getExecutionPeriod().getExecutionYear().getYear());
            executionCourseStatistics.setDegrees(this.getDegrees(executionCourse));
            this.createCourseStatistics(executionCourseStatistics, executionCourse.getActiveEnrollments());
            results.add(executionCourseStatistics);
        }
        return results;
    }

    private List<String> getResponsibleTeachersName(ExecutionCourse executionCourse) {
        ArrayList<String> result = new ArrayList<String>();
        for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
            if (!professorship.getResponsibleFor().booleanValue()) continue;
            result.add(professorship.getPerson().getName());
        }
        return result;
    }

    private List<String> getDegrees(ExecutionCourse executionCourse) {
        HashSet<Degree> degrees = new HashSet<Degree>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            degrees.add(curricularCourse.getDegreeCurricularPlan().getDegree());
        }
        ExecutionYear executionYear = executionCourse.getExecutionYear();
        ArrayList<String> degreeNames = new ArrayList<String>();
        for (Degree degree : degrees) {
            degreeNames.add(degree.getNameFor(executionYear).getContent());
        }
        return degreeNames;
    }

    public static List<ExecutionCourseStatisticsDTO> runComputeExecutionCourseStatistics(CompetenceCourse competenceCourse, Degree degree, ExecutionSemester executionSemester) throws FenixServiceException {
        return (List)advice$runComputeExecutionCourseStatistics.perform((Callable)new ComputeExecutionCourseStatistics$callable$runComputeExecutionCourseStatistics(competenceCourse, degree, executionSemester));
    }

    static /* synthetic */ List<ExecutionCourseStatisticsDTO> advised$runComputeExecutionCourseStatistics(CompetenceCourse competenceCourse, Degree degree, ExecutionSemester executionSemester) throws FenixServiceException {
        return serviceInstance.run(competenceCourse, degree, executionSemester);
    }

    static {
        advice$runComputeExecutionCourseStatistics = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ComputeExecutionCourseStatistics();
    }
}

