/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class GradesToSubmitExecutionCourseSendMailBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DegreeCurricularPlan degreeCurricularPlan;
    private ExecutionCourse executionCourse;
    private boolean toSubmit;

    public GradesToSubmitExecutionCourseSendMailBean(DegreeCurricularPlan degreeCurricularPlan, ExecutionCourse executionCourse, boolean toSubmit) {
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setExecutionCourse(executionCourse);
        this.setToSubmit(toSubmit);
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = degreeCurricularPlan;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
    }

    public boolean isToSubmit() {
        return this.toSubmit;
    }

    public void setToSubmit(boolean toSubmit) {
        this.toSubmit = toSubmit;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionCourse.getExecutionPeriod();
    }

    public int getNumberOfEnroledStudents() {
        return this.executionCourse.getAttendsSet().size();
    }

    public int getNumberOfStudentsWithoutGrade() {
        int count = 0;
        for (CurricularCourse curricularCourse : this.executionCourse.getAssociatedCurricularCoursesSet()) {
            if (this.degreeCurricularPlan == null || !this.degreeCurricularPlan.equals((Object)curricularCourse.getDegreeCurricularPlan())) continue;
            count += this.getNumberOfStudentsWithoutGrade(curricularCourse);
        }
        return count;
    }

    private int getNumberOfStudentsWithoutGrade(CurricularCourse curricularCourse) {
        int total = 0;
        for (CurriculumModule curriculumModule : curricularCourse.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            Enrolment enrolment = (Enrolment)((Object)curriculumModule);
            if (enrolment.isValid(this.getExecutionSemester()) && enrolment.getEvaluationSeason().isNormal()) {
                if (enrolment.hasAssociatedMarkSheetOrFinalGrade(EvaluationSeason.readNormalSeason())) continue;
                ++total;
                continue;
            }
            if (!enrolment.hasImprovement() || enrolment.hasAssociatedMarkSheet(EvaluationSeason.readImprovementSeason()) || !enrolment.hasImprovementFor(this.getExecutionSemester())) continue;
            ++total;
        }
        return total;
    }

    public String getResponsibleTeacherNames() {
        StringBuilder builder = new StringBuilder();
        for (Professorship professorship : this.executionCourse.responsibleFors()) {
            Person person = professorship.getPerson();
            builder.append(person.getName());
            String email = person.getInstitutionalOrDefaultEmailAddressValue();
            if (!StringUtils.isEmpty((String)email)) {
                builder.append(" (").append(email).append(")");
            }
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

