/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.alumni;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.alumni.AlumniMailSendToBean;
import pt.ist.fenixframework.FenixFramework;

public class AlumniSearchBean
extends AlumniMailSendToBean {
    private int totalItems;
    private String name;
    private Integer studentNumber;
    private String documentIdNumber;
    private Degree degree;
    private List<Registration> alumni;
    private String email;
    private String mobileNumber;
    private String telephoneNumber;
    private ExecutionYear firstExecutionYear;
    private ExecutionYear finalExecutionYear;

    public AlumniSearchBean() {
        this("", ExecutionYear.readFirstExecutionYear(), ExecutionYear.readLastExecutionYear());
    }

    public AlumniSearchBean(DegreeType degreeType, String name, ExecutionYear firstYear, ExecutionYear lastYear) {
        this(name, firstYear, lastYear);
        this.setDegreeType(degreeType);
    }

    public AlumniSearchBean(String name, ExecutionYear firstYear, ExecutionYear lastYear) {
        this.setName(name);
        this.setFirstExecutionYear(firstYear);
        this.setFinalExecutionYear(lastYear);
        this.setDegreeType(null);
    }

    public List<Registration> getAlumni() {
        if (this.alumni == null) {
            return null;
        }
        ArrayList<Registration> alumni = new ArrayList<Registration>();
        for (Registration reference : this.alumni) {
            alumni.add(reference);
        }
        return alumni;
    }

    public void setAlumni(List<Registration> alumni) {
        if (this.alumni == null) {
            this.alumni = new ArrayList<Registration>(alumni.size());
        } else {
            this.alumni.clear();
        }
        for (Registration person : alumni) {
            this.alumni.add(person);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSearchElementsAsParameters() {
        String urlParameters = "&amp;beansearch=" + this.getDegreeType() + ":" + this.getName() + ":";
        urlParameters = urlParameters + (this.getFirstExecutionYear() == null ? "null" : this.getFirstExecutionYear().getExternalId()) + ":";
        urlParameters = urlParameters + (this.getFinalExecutionYear() == null ? "null" : this.getFinalExecutionYear().getExternalId());
        return urlParameters;
    }

    public static AlumniSearchBean getBeanFromParameters(String requestParameter) {
        ExecutionYear last;
        String[] values = requestParameter.split(":");
        String firstYear = values[2];
        String finalYear = values[3];
        ExecutionYear first = firstYear.equals("null") ? ExecutionYear.readFirstExecutionYear() : (ExecutionYear)FenixFramework.getDomainObject((String)firstYear);
        ExecutionYear executionYear = last = finalYear.equals("null") ? ExecutionYear.readLastExecutionYear() : (ExecutionYear)FenixFramework.getDomainObject((String)finalYear);
        if (values[0].equals("null")) {
            return new AlumniSearchBean(values[1], first, last);
        }
        return new AlumniSearchBean((DegreeType)FenixFramework.getDomainObject((String)values[0]), values[1], first, last);
    }

    public ExecutionYear getFinalExecutionYear() {
        return this.finalExecutionYear;
    }

    public void setFinalExecutionYear(ExecutionYear finalExecutionYear) {
        this.finalExecutionYear = finalExecutionYear;
    }

    public ExecutionYear getFirstExecutionYear() {
        return this.firstExecutionYear;
    }

    public void setFirstExecutionYear(ExecutionYear firstExecutionYear) {
        this.firstExecutionYear = firstExecutionYear;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public String getDocumentIdNumber() {
        return this.documentIdNumber;
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        this.documentIdNumber = documentIdNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }
}

