/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.ExtraCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.InternalCreditsSourceCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup_Base;
import org.fenixedu.academic.domain.studentCurriculum.PropaedeuticsCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;

public abstract class NoCourseGroupCurriculumGroup
extends NoCourseGroupCurriculumGroup_Base {
    protected NoCourseGroupCurriculumGroup() {
    }

    protected void init(RootCurriculumGroup curriculumGroup) {
        this.checkParameters(curriculumGroup);
        this.setCurriculumGroup((CurriculumGroup)((Object)curriculumGroup));
    }

    private void checkParameters(RootCurriculumGroup curriculumGroup) {
        if (curriculumGroup == null) {
            throw new DomainException("error.NoCourseGroupCurriculumGroup.invalid.curriculumGroup", new String[0]);
        }
    }

    public static NoCourseGroupCurriculumGroup create(NoCourseGroupCurriculumGroupType groupType, RootCurriculumGroup curriculumGroup) {
        switch (groupType) {
            case PROPAEDEUTICS: {
                return new PropaedeuticsCurriculumGroup(curriculumGroup);
            }
            case EXTRA_CURRICULAR: {
                return new ExtraCurriculumGroup(curriculumGroup);
            }
            case STANDALONE: {
                return new StandaloneCurriculumGroup(curriculumGroup);
            }
            case INTERNAL_CREDITS_SOURCE_GROUP: {
                return new InternalCreditsSourceCurriculumGroup(curriculumGroup);
            }
        }
        throw new DomainException("error.unknown.NoCourseGroupCurriculumGroupType", new String[0]);
    }

    public boolean isNoCourseGroupCurriculumGroup() {
        return true;
    }

    public MultiLanguageString getName() {
        return new MultiLanguageString(MultiLanguageString.pt, this.getNoCourseGroupCurriculumGroupType().getLocalizedName(MultiLanguageString.pt)).with(MultiLanguageString.en, this.getNoCourseGroupCurriculumGroupType().getLocalizedName(MultiLanguageString.en));
    }

    public List<Context> getCurricularCourseContextsToEnrol(ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    public List<Context> getCourseGroupContextsToEnrol(ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    public Collection<CurricularCourse> getCurricularCoursesToDismissal(ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.hasDegreeModule(degreeModule)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCourseGroup(CourseGroup courseGroup) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumGroup group;
            if (curriculumModule.isLeaf() || !(group = (CurriculumGroup)((Object)curriculumModule)).hasCourseGroup(courseGroup)) continue;
            return true;
        }
        return false;
    }

    public CurriculumGroup findCurriculumGroupFor(CourseGroup courseGroup) {
        for (CurriculumModule each : this.getCurriculumModulesSet()) {
            if (each.isLeaf() || each.getDegreeModule() != courseGroup) continue;
            return (CurriculumGroup)((Object)each);
        }
        return null;
    }

    public Integer getChildOrder(ExecutionSemester executionSemester) {
        return Integer.MAX_VALUE;
    }

    protected Integer searchChildOrderForChild(CurriculumGroup child, ExecutionSemester executionSemester) {
        ArrayList result = new ArrayList(this.getCurriculumModulesSet());
        Collections.sort(result, CurriculumModule.COMPARATOR_BY_NAME_AND_ID);
        return result.indexOf((Object)child);
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        return Collections.emptySet();
    }

    public Set<ICurricularRule> getCurricularRules(ExecutionSemester executionSemester) {
        return Collections.emptySet();
    }

    public CurriculumModule.ConclusionValue isConcluded(ExecutionYear executionYear) {
        return CurriculumModule.ConclusionValue.CONCLUDED;
    }

    public final Curriculum getCurriculum(DateTime when, ExecutionYear executionYear) {
        return Curriculum.createEmpty((CurriculumModule)((Object)this), executionYear);
    }

    public Double getCreditsConcluded(ExecutionYear executionYear) {
        return 0.0;
    }

    public boolean canAdd(CurriculumLine curriculumLine) {
        return false;
    }

    public Collection<CurriculumGroup> getCurricularCoursePossibleGroups(CurricularCourse curricularCourse) {
        return Collections.singleton(this);
    }

    public Collection<CurriculumGroup> getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups(CurricularCourse curricularCourse) {
        return Collections.emptyList();
    }

    public Double getAprovedEctsCredits() {
        return 0.0;
    }

    public Collection<NoCourseGroupCurriculumGroup> getNoCourseGroupCurriculumGroups() {
        HashSet<NoCourseGroupCurriculumGroup> res = new HashSet<NoCourseGroupCurriculumGroup>();
        res.add(this);
        res.addAll(super.getNoCourseGroupCurriculumGroups());
        return res;
    }

    public ICurricularRule getMostRecentActiveCurricularRule(CurricularRuleType ruleType, ExecutionYear executionYear) {
        return null;
    }

    public abstract NoCourseGroupCurriculumGroupType getNoCourseGroupCurriculumGroupType();

    public int getNumberOfAllApprovedCurriculumLines() {
        return 0;
    }

    public int getNumberOfAllApprovedEnrolments(ExecutionSemester executionSemester) {
        return 0;
    }

    public boolean allowAccumulatedEctsCredits() {
        return false;
    }

    public Set<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups() {
        return Collections.emptySet();
    }

    public boolean isVisible() {
        return true;
    }
}

