/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcessVersion;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcessVersion_Base;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess_Base;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public abstract class ConclusionProcess
extends ConclusionProcess_Base {
    protected final Stream<ConclusionProcessVersion> versions() {
        return this.getVersionsSet().stream().filter(ConclusionProcessVersion::isActive);
    }

    private Optional<ConclusionProcessVersion> getFirstVersion() {
        return this.versions().min(ConclusionProcessVersion.COMPARATOR_BY_CREATION_DATE_TIME_AND_ID);
    }

    public DateTime getCreationDateTime() {
        return this.getFirstVersion().map(ConclusionProcessVersion_Base::getCreationDateTime).orElse(null);
    }

    public DateTime getLastModificationDateTime() {
        return this.getLastVersion().getCreationDateTime();
    }

    public Person getResponsible() {
        return this.getFirstVersion().map(ConclusionProcessVersion_Base::getResponsible).orElse(null);
    }

    public Person getLastResponsible() {
        return this.getLastVersion().getResponsible();
    }

    public Grade getFinalGrade() {
        return this.getLastVersion().getFinalGrade();
    }

    public Grade getRawGrade() {
        return this.getLastVersion().getRawGrade();
    }

    public Grade getDescriptiveGrade() {
        return this.getLastVersion().getDescriptiveGrade();
    }

    public LocalDate getConclusionDate() {
        return this.getLastVersion().getConclusionDate();
    }

    @Deprecated
    public YearMonthDay getConclusionYearMonthDay() {
        return new YearMonthDay((Object)this.getConclusionDate());
    }

    public String getNotes() {
        return this.getLastVersion().getNotes();
    }

    public ExecutionYear getIngressionYear() {
        return this.getLastVersion().getIngressionYear();
    }

    public BigDecimal getCredits() {
        return this.getLastVersion().getCredits();
    }

    public abstract void update(Person var1, Grade var2, Grade var3, Grade var4, LocalDate var5, String var6);

    public abstract void update(RegistrationConclusionBean var1);

    protected final void addVersions(RegistrationConclusionBean bean) {
        super.addVersions(new ConclusionProcessVersion(bean));
        this.updateLastVersion();
        this.addSpecificVersionInfo();
    }

    public final void disableLastVersion() {
        this.getLastVersion().setActive(false);
        this.updateLastVersion();
    }

    private final void updateLastVersion() {
        super.setLastVersion((ConclusionProcessVersion)this.versions().max(ConclusionProcessVersion.COMPARATOR_BY_CREATION_DATE_TIME_AND_ID).orElse(null));
        super.setConclusionYear(this.getLastVersion() == null ? null : this.getLastVersion().getConclusionYear());
    }

    protected abstract void addSpecificVersionInfo();

    public final void addVersions(ConclusionProcessVersion versions) {
        throw new DomainException("error.ConclusionProcess.must.use.addVersions.with.bean", new String[0]);
    }

    public void removeVersions(ConclusionProcessVersion versions) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public void setLastVersion(ConclusionProcessVersion lastVersion) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public abstract Registration getRegistration();

    public Degree getDegree() {
        return this.getRegistration().getDegree();
    }

    public DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public LocalizedString getName() {
        return this.getGroup().getName().toLocalizedString();
    }

    public boolean isActive() {
        return this.getLastVersion() != null && this.getLastVersion().isActive();
    }
}

