/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.reports.GepReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.util.HtmlToTextConverterUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GepReportFile
extends GepReportFile_Base {
    private static final Logger logger = LoggerFactory.getLogger(GepReportFile.class);
    public static final String CODE_SEPARATOR = "_#_";

    public static String getExecutionSemesterCode(ExecutionSemester executionSemester) {
        return executionSemester.getSemester() + CODE_SEPARATOR + executionSemester.getYear();
    }

    public static String getExecutionCourseCode(ExecutionCourse executionCourse) {
        return executionCourse.getSigla() + CODE_SEPARATOR + GepReportFile.getExecutionSemesterCode(executionCourse.getExecutionPeriod());
    }

    public static String getExecutionDegreeCode(ExecutionDegree executionDegree) {
        return GepReportFile.getDegreeCurricularPlanCode(executionDegree.getDegreeCurricularPlan()) + CODE_SEPARATOR + executionDegree.getExecutionYear().getName();
    }

    private static String getDegreeCurricularPlanCode(DegreeCurricularPlan dcp) {
        return dcp.getName() + CODE_SEPARATOR + dcp.getDegree().getSigla();
    }

    public static String getCompetenceCourseCode(CompetenceCourse competenceCourse) {
        return competenceCourse.getAcronym();
    }

    public static String getProfessorshipCode(Professorship professorship) {
        return professorship.getPerson().getUsername() + CODE_SEPARATOR + GepReportFile.getExecutionCourseCode(professorship.getExecutionCourse());
    }

    public static String getShiftCode(Shift shift) {
        return shift.getNome() + CODE_SEPARATOR + GepReportFile.getExecutionCourseCode(shift.getExecutionCourse());
    }

    public static String getWrittenEvaluationCode(WrittenEvaluation writtenEvaluation) {
        StringBuilder code = new StringBuilder().append(writtenEvaluation.getInterval().toString()).append(writtenEvaluation.getFullName()).append(writtenEvaluation.getEvaluationType().toString());
        writtenEvaluation.getAssociatedExecutionCoursesSet().stream().forEach(ec -> code.append(GepReportFile.getExecutionCourseCode(ec)));
        return Hashing.murmur3_128().hashBytes(code.toString().getBytes(StandardCharsets.UTF_8)).toString();
    }

    public static ExecutionYear getExecutionYearFourYearsBack(ExecutionYear executionYear) {
        ExecutionYear executionYearFourYearsBack = executionYear;
        if (executionYear != null) {
            for (int i = 5; i > 1; --i) {
                ExecutionYear previousExecutionYear = executionYearFourYearsBack.getPreviousExecutionYear();
                if (previousExecutionYear == null) continue;
                executionYearFourYearsBack = previousExecutionYear;
            }
        }
        return executionYearFourYearsBack;
    }

    public String getDescription() {
        return " no formato " + this.getType().toUpperCase();
    }

    public abstract String getJobName();

    protected abstract String getPrefix();

    public String getFilename() {
        return this.getReportName().replace(' ', '_') + "." + this.getType();
    }

    private String getReportName() {
        StringBuilder result = new StringBuilder();
        result.append(this.getRequestDate().toString("yyyy_MM_dd_HH_mm")).append("_");
        result.append(this.getPrefix()).append("_");
        result.append(this.getDegreeType() == null ? "Todos_Cursos" : this.getDegreeType().getName().getContent()).append("_");
        result.append(this.getExecutionYear() == null ? "Todos_Anos" : this.getExecutionYear().getName().replace('/', '_'));
        return result.toString();
    }

    protected void setDegreeHeaders(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("tipo curso");
        spreadsheet.setHeader("nome curso");
        spreadsheet.setHeader("sigla curso");
    }

    protected void setDegreeHeaders(Spreadsheet spreadsheet, String suffix) {
        spreadsheet.setHeader("tipo curso " + suffix);
        spreadsheet.setHeader("nome curso " + suffix);
        spreadsheet.setHeader("sigla curso " + suffix);
    }

    protected void setDegreeCells(Spreadsheet.Row row, Degree degree) {
        row.setCell(degree.getDegreeType().getName().getContent());
        row.setCell(degree.getNameI18N().getContent());
        row.setCell(degree.getSigla());
    }

    protected boolean checkDegreeType(DegreeType degreeType, ConclusionProcess conclusionProcess) {
        return degreeType == null || conclusionProcess.getDegree().getDegreeType() == degreeType;
    }

    protected static boolean checkDegreeType(DegreeType degreeType, Degree degree) {
        return degreeType == null || degree.getDegreeType() == degreeType;
    }

    protected static boolean checkExecutionYear(ExecutionYear executionYear, DegreeCurricularPlan degreeCurricularPlan) {
        return executionYear == null || degreeCurricularPlan.hasExecutionDegreeFor(executionYear);
    }

    protected static boolean checkExecutionYear(ExecutionYear executionYear, CurricularCourse curricularCourse) {
        return executionYear == null || curricularCourse.isActive(executionYear);
    }

    protected static boolean checkExecutionYear(ExecutionYear executionYear, ExecutionCourse executionCourse) {
        return executionYear == null || executionCourse.getExecutionYear().equals(executionYear);
    }

    protected boolean isActive(Degree degree) {
        for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
            if (!GepReportFile.checkExecutionYear(this.getExecutionYear(), degreeCurricularPlan)) continue;
            return true;
        }
        return false;
    }

    protected String normalize(String text) {
        if (!StringUtils.isEmpty((String)text)) {
            String result = "";
            try {
                result = HtmlToTextConverterUtil.convertToText(text);
            }
            catch (Exception ex) {
                result = HtmlToTextConverterUtil.convertToTextWithRegEx(text);
            }
            return result.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
        }
        return "";
    }

    public abstract void renderReport(Spreadsheet var1) throws Exception;

    public QueueJobResult execute() throws Exception {
        Spreadsheet spreadsheet = new Spreadsheet(this.getReportName());
        this.renderReport(spreadsheet);
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        if ("csv".compareTo(this.getType()) == 0) {
            spreadsheet.exportToCSV((OutputStream)byteArrayOS, "\t");
        } else {
            spreadsheet.exportToXLSSheet((OutputStream)byteArrayOS);
        }
        QueueJobResult queueJobResult = new QueueJobResult();
        queueJobResult.setContentType("application/txt");
        queueJobResult.setContent(byteArrayOS.toByteArray());
        logger.info("Job " + this.getFilename() + " completed");
        return queueJobResult;
    }

    public String getUpperCaseType() {
        return this.getType().toUpperCase();
    }

    protected static List<Registration> getFullRegistrationPath(Registration current) {
        if (current.getDegreeType().isBolonhaDegree() || current.getDegreeType().isIntegratedMasterDegree()) {
            Registration source;
            ArrayList<Registration> path = new ArrayList<Registration>();
            path.add(current);
            if (current.getSourceRegistration() != null && (!(source = current.getSourceRegistration()).isBolonha() || GepReportFile.isValidSourceLink(source))) {
                path.addAll(GepReportFile.getFullRegistrationPath(source));
            } else {
                source = GepReportFile.findSourceRegistrationByEquivalencePlan(current);
                if (source != null) {
                    path.addAll(GepReportFile.getFullRegistrationPath(source));
                }
            }
            Collections.sort(path, Registration.COMPARATOR_BY_START_DATE);
            return path;
        }
        return Collections.singletonList(current);
    }

    protected static boolean isValidSourceLink(Registration source) {
        return source.getActiveStateType().equals((Object)RegistrationStateType.TRANSITED) || source.getActiveStateType().equals((Object)RegistrationStateType.FLUNKED) || source.getActiveStateType().equals((Object)RegistrationStateType.INTERNAL_ABANDON) || source.getActiveStateType().equals((Object)RegistrationStateType.EXTERNAL_ABANDON) || source.getActiveStateType().equals((Object)RegistrationStateType.INTERRUPTED);
    }

    private static Registration findSourceRegistrationByEquivalencePlan(Registration targetRegistration) {
        DegreeCurricularPlan targetDegreeCurricularPlan = targetRegistration.getLastDegreeCurricularPlan();
        if (targetDegreeCurricularPlan.getEquivalencePlan() != null) {
            for (Registration sourceRegistration : targetRegistration.getStudent().getRegistrationsSet()) {
                DegreeCurricularPlan sourceDegreeCurricularPlan = sourceRegistration.getLastDegreeCurricularPlan();
                if (sourceRegistration == targetRegistration || sourceRegistration.getActiveStateType() != RegistrationStateType.TRANSITED || !targetDegreeCurricularPlan.getEquivalencePlan().getSourceDegreeCurricularPlan().equals((Object)sourceDegreeCurricularPlan)) continue;
                return sourceRegistration;
            }
        }
        return null;
    }
}

