/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.reports;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public abstract class PhdReport {
    private CellStyle headerStyle;
    protected HSSFWorkbook workbook;

    protected PhdReport(HSSFWorkbook workbook) {
        this.workbook = workbook;
        this.headerStyle = this.headerBackgroundStyle();
    }

    protected abstract void setHeaders(HSSFSheet var1);

    protected CellStyle headerBackgroundStyle() {
        HSSFCellStyle style = this.workbook.createCellStyle();
        style.setFillBackgroundColor(IndexedColors.AQUA.getIndex());
        style.setFillPattern((short)9);
        return style;
    }

    protected String onNullEmptyString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof DateTime) {
            return ((DateTime)value).toString("dd/MM/yyyy");
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).toString("dd/MM/yyyy");
        }
        if (value instanceof YearMonthDay) {
            return ((YearMonthDay)value).toString("dd/MM/yyyy");
        }
        if (value instanceof Boolean) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)((Boolean)value != false ? "label.yes" : "label.no"), (String[])new String[0]);
        }
        return value.toString();
    }

    protected void addCellValue(HSSFRow row, String value, int cellNumber) {
        HSSFCell cell = row.createCell(cellNumber);
        cell.setCellValue(value);
    }

    protected void addHeaderCell(HSSFSheet sheet, String value, int columnNumber) {
        HSSFRow row = sheet.getRow(0);
        if (row == null) {
            row = sheet.createRow(0);
        }
        HSSFCell cell = row.createCell(columnNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.headerStyle);
        cell.setCellValue(value);
        sheet.addMergedRegion(new CellRangeAddress(0, 1, columnNumber, columnNumber));
    }
}

