/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.text.MessageFormat;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.InternalPhdStudyPlanEntry_Base;
import org.fenixedu.academic.domain.phd.PhdStudyPlan;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntryType;

public class InternalPhdStudyPlanEntry
extends InternalPhdStudyPlanEntry_Base {
    protected InternalPhdStudyPlanEntry() {
    }

    public InternalPhdStudyPlanEntry(PhdStudyPlanEntryType type, PhdStudyPlan studyPlan, CompetenceCourse competenceCourse) {
        this();
        this.init(type, studyPlan, competenceCourse);
    }

    protected void init(PhdStudyPlanEntryType type, PhdStudyPlan studyPlan, CompetenceCourse competenceCourse) {
        String[] args = new String[]{};
        if (competenceCourse == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.enclosing_type.competenceCourse.cannot.be.null", args);
        }
        super.setCompetenceCourse(competenceCourse);
        super.init(type, studyPlan);
    }

    public void setCompetenceCourse(CompetenceCourse competenceCourse) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.InternalPhdStudyPlanEntry.cannot.modify.competenceCourse", new String[0]);
    }

    public String getCourseDescription() {
        return MessageFormat.format("{0} ({1}) - {2} ects", this.getCompetenceCourse().getName(), this.getCompetenceCourse().getDepartmentUnit().getName(), this.getCompetenceCourse().getEctsCredits());
    }

    public boolean isInternalEntry() {
        return true;
    }

    public boolean isSimilar(PhdStudyPlanEntry entry) {
        if (entry.isInternalEntry()) {
            return ((InternalPhdStudyPlanEntry)((Object)entry)).getCompetenceCourse() == this.getCompetenceCourse();
        }
        return false;
    }

    public void delete() {
        super.setCompetenceCourse(null);
        super.delete();
    }
}

