/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.organizationalStructure.UnitNamePart_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;

public class UnitNamePart
extends UnitNamePart_Base {
    private static final Map<String, UnitNamePart> unitNamePartIndexMap = new HashMap<String, UnitNamePart>();

    public UnitNamePart(String namePart) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setNamePart(namePart);
    }

    public void setNamePart(String namePart) {
        if (namePart == null) {
            throw new DomainException("error.name.part.cannot.be.null", new String[0]);
        }
        UnitNamePart unitNamePart = UnitNamePart.find(namePart);
        if (unitNamePart != null && unitNamePart != this) {
            throw new DomainException("error.duplicate.name.part", namePart);
        }
        super.setNamePart(namePart);
    }

    public static String normalize(String string) {
        return StringNormalizer.normalize((String)string.trim());
    }

    public static String[] getNameParts(String name) {
        return UnitNamePart.normalize(name).split(" ");
    }

    public static UnitNamePart find(String namePart) {
        String normalizedNamePart = StringNormalizer.normalize((String)namePart);
        UnitNamePart indexedUnitNamePart = unitNamePartIndexMap.get(normalizedNamePart);
        if (indexedUnitNamePart != null) {
            return indexedUnitNamePart;
        }
        for (UnitNamePart unitNamePart : Bennu.getInstance().getUnitNamePartSet()) {
            String otherUnitNamePart = unitNamePart.getNamePart();
            if (!unitNamePartIndexMap.containsKey(otherUnitNamePart)) {
                unitNamePartIndexMap.put(otherUnitNamePart, unitNamePart);
            }
            if (!normalizedNamePart.equals(otherUnitNamePart)) continue;
            return unitNamePart;
        }
        return null;
    }

    protected static UnitNamePart findAndCreateIfNotFound(String namePart) {
        UnitNamePart unitNamePart = UnitNamePart.find(namePart);
        return unitNamePart == null ? new UnitNamePart(namePart) : unitNamePart;
    }

    protected static void index(UnitName unitName, String namePart) {
        UnitNamePart unitNamePart = UnitNamePart.findAndCreateIfNotFound(namePart);
        unitNamePart.addUnitName(unitName);
    }

    protected static void index(UnitName unitName, String[] nameParts) {
        for (String namePart : nameParts) {
            UnitNamePart.index(unitName, namePart);
        }
    }

    protected static void index(UnitName unitName) {
        UnitNamePart.index(unitName, UnitNamePart.getNameParts(unitName.getName()));
    }

    public static void reindex(UnitName unitName) {
        unitName.getUnitNamePartSet().clear();
        UnitNamePart.index(unitName);
    }

    public void deleteIfEmpty() {
        if (this.getUnitNameSet().isEmpty()) {
            this.setRootDomainObject(null);
            this.deleteDomainObject();
        }
    }
}

