/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class SchoolUnit
extends SchoolUnit_Base {
    private SchoolUnit() {
        super.setType(PartyTypeEnum.SCHOOL);
    }

    public boolean isSchoolUnit() {
        return true;
    }

    public static SchoolUnit createNewSchoolUnit(MultiLanguageString schoolName, String schoolNameCard, Unit parentUnit, Boolean official, String code, AcademicalInstitutionType institutionType) {
        SchoolUnit schoolUnit = new SchoolUnit();
        schoolUnit.setPartyName(schoolName);
        schoolUnit.setIdentificationCardLabel(schoolNameCard);
        schoolUnit.setOfficial(official);
        schoolUnit.setCode(code);
        schoolUnit.setInstitutionType(institutionType);
        schoolUnit.setBeginDateYearMonthDay(YearMonthDay.fromDateFields((Date)new GregorianCalendar().getTime()));
        schoolUnit.setCanBeResponsibleOfSpaces(Boolean.FALSE);
        return SchoolUnit.createNewUnit(parentUnit, schoolUnit, Boolean.FALSE);
    }

    public static SchoolUnit createNewSchoolUnit(MultiLanguageString schoolName, String schoolNameCard, Integer costCenterCode, String schoolAcronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        SchoolUnit schoolUnit = new SchoolUnit();
        schoolUnit.init(schoolName, schoolNameCard, costCenterCode, schoolAcronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        return SchoolUnit.createNewUnit(parentUnit, schoolUnit, Boolean.TRUE);
    }

    private static SchoolUnit createNewUnit(Unit parentUnit, SchoolUnit schoolUnit, Boolean checkExistingUnit) {
        if (parentUnit.isCountryUnit()) {
            schoolUnit.addParentUnit(parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.GEOGRAPHIC));
        } else if (parentUnit.isUniversityUnit()) {
            schoolUnit.addParentUnit(parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE));
        }
        if (checkExistingUnit.booleanValue()) {
            SchoolUnit.checkIfAlreadyExistsOneSchoolWithSameAcronymAndName(schoolUnit);
        }
        return schoolUnit;
    }

    public void edit(MultiLanguageString name, String acronym) {
        super.edit(name, acronym);
        SchoolUnit.checkIfAlreadyExistsOneSchoolWithSameAcronymAndName(this);
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        SchoolUnit.checkIfAlreadyExistsOneSchoolWithSameAcronymAndName(this);
    }

    protected static void checkIfAlreadyExistsOneSchoolWithSameAcronymAndName(SchoolUnit schoolUnit) {
        for (Unit parentUnit : schoolUnit.getParentUnits()) {
            for (Unit unit : parentUnit.getAllSubUnits()) {
                if (unit.equals((Object)schoolUnit) || !unit.isSchoolUnit() || (schoolUnit.getAcronym() == null || !schoolUnit.getAcronym().equalsIgnoreCase(unit.getAcronym())) && !schoolUnit.getName().equalsIgnoreCase(unit.getName())) continue;
                throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
            }
        }
    }

    public List<ExternalCurricularCourse> getAllExternalCurricularCourses() {
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>(this.getExternalCurricularCoursesSet());
        for (Unit subUnit : this.getSubUnits()) {
            if (!subUnit.isDepartmentUnit()) continue;
            result.addAll(subUnit.getExternalCurricularCoursesSet());
        }
        return result;
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (!(parentUnit == null || parentUnit.isOfficialExternal() && (parentUnit.isPlanetUnit() || parentUnit.isCountryUnit() || parentUnit.isUniversityUnit()))) {
            throw new DomainException("error.unit.invalid.parentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public String getFullPresentationName() {
        StringBuilder output = new StringBuilder();
        output.append(this.getName().trim());
        output.append(" da ");
        List parents = this.getParentUnitsPath();
        output.append(((Unit)((Object)parents.get(parents.size() - 1))).getName());
        return output.toString();
    }
}

