/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.util.Collection;
import java.util.Set;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.EnrolmentEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.LabelFormatter;

public abstract class EnrolmentEvent
extends EnrolmentEvent_Base {
    protected EnrolmentEvent() {
    }

    protected void init(AdministrativeOffice administrativeOffice, EventType eventType, Person person, Collection<EnrolmentEvaluation> enrolmentEvaluations) {
        this.checkParameters(enrolmentEvaluations);
        this.addAll(enrolmentEvaluations);
        super.init(administrativeOffice, eventType, person);
    }

    protected abstract void addAll(Collection<EnrolmentEvaluation> var1);

    protected abstract Set<EnrolmentEvaluation> getAllEnrolmentEvaluationsSet();

    private void checkParameters(Collection<EnrolmentEvaluation> enrolmentEvaluations) {
        if (enrolmentEvaluations == null || enrolmentEvaluations.isEmpty()) {
            throw new DomainException("error.accounting.events.EnrolmentInSpecialSeasonEvaluationEvent.enrolmentEvaluations.cannot.be.null", new String[0]);
        }
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        this.getDetailedDescription(labelFormatter);
        return labelFormatter;
    }

    private void getDetailedDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (").appendLabel(this.getEnrolmentsDescription()).appendLabel(")");
    }

    private String getEnrolmentsDescription() {
        StringBuilder result = new StringBuilder();
        for (EnrolmentEvaluation enrolmentEvaluation : this.getAllEnrolmentEvaluationsSet()) {
            result.append(enrolmentEvaluation.getEnrolment().getName().getContent()).append(", ");
        }
        if (result.toString().endsWith(", ")) {
            result.delete(result.length() - 2, result.length());
        }
        return result.toString();
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.getDetailedDescription(labelFormatter);
        return labelFormatter;
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getAccountBy(AccountType.INTERNAL);
    }

    public PostingRule getPostingRule() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }
}

