/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.accounting.ReceiptPrintVersion_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class ReceiptPrintVersion
extends ReceiptPrintVersion_Base {
    private ReceiptPrintVersion() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    ReceiptPrintVersion(Receipt receipt, Person person) {
        this();
        this.init(receipt, person);
    }

    private void init(Receipt receipt, Person person) {
        this.checkParameters(receipt, person);
        super.setWhenCreated(new DateTime());
        super.setReceipt(receipt);
        super.setPerson(person);
    }

    private void checkParameters(Receipt receipt, Person person) {
        if (receipt == null) {
            throw new DomainException("error.accounting.receiptVersion.receipt.cannot.be.null", new String[0]);
        }
        if (person == null) {
            throw new DomainException("error.accounting.receiptVersion.person.cannot.be.null", new String[0]);
        }
    }

    public void setPerson(Person person) {
        throw new DomainException("error.accounting.receiptVersion.cannot.modify.person", new String[0]);
    }

    public void setReceipt(Receipt receipt) {
        throw new DomainException("error.accounting.receiptVersion.cannot.modify.receipt", new String[0]);
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.accounting.receiptVersion.cannot.modify.whenCreated", new String[0]);
    }

    void delete() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setPerson(null);
        super.setReceipt(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }
}

