/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentTeacherGroup;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

@GroupOperator(value="teacher")
public class TeacherGroup
extends FenixGroup {
    private static final long serialVersionUID = 4333469299499201648L;
    @GroupArgument
    private Degree degree;
    @GroupArgument
    private ExecutionCourse executionCourse;
    @GroupArgument
    private Space campus;
    @GroupArgument
    private Department department;
    @GroupArgument
    private ExecutionYear executionYear;

    private TeacherGroup() {
    }

    private TeacherGroup(Degree degree, ExecutionCourse executionCourse, Space campus, Department department, ExecutionYear executionYear) {
        this();
        this.degree = degree;
        this.executionCourse = executionCourse;
        this.campus = campus;
        this.department = department;
        this.executionYear = executionYear;
    }

    public static TeacherGroup get(Degree degree) {
        return new TeacherGroup(degree, null, null, null, null);
    }

    public static TeacherGroup get(Space campus) {
        return new TeacherGroup(null, null, campus, null, null);
    }

    public static TeacherGroup get(Department department, ExecutionYear executionYear) {
        return new TeacherGroup(null, null, null, department, executionYear);
    }

    public static TeacherGroup get(ExecutionCourse executionCourse) {
        return new TeacherGroup(null, executionCourse, null, null, null);
    }

    public static TeacherGroup get(Degree degree, ExecutionCourse executionCourse, Space campus, Department department, ExecutionYear executionYear) {
        return new TeacherGroup(degree, executionCourse, campus, department, executionYear);
    }

    private ExecutionYear getExecutionYear() {
        return this.executionYear != null ? this.executionYear : ExecutionYear.readCurrentExecutionYear();
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        ArrayList<String> parts = new ArrayList<String>();
        String connector = "";
        if (this.degree != null) {
            parts.add(this.degree.getPresentationName());
        }
        if (this.executionCourse != null) {
            parts.add(this.executionCourse.getName() + " (" + this.executionCourse.getSigla() + ") " + this.executionCourse.getAcademicInterval().getPathName());
        }
        if (this.department != null) {
            parts.add(this.department.getName());
        }
        if (this.executionYear != null) {
            parts.add(this.executionYear.getName());
        }
        if (this.campus != null) {
            parts.add(this.campus.getName());
        }
        if (!parts.isEmpty()) {
            connector = parts.size() == 1 && this.campus != null ? BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.campus", (String[])new String[0]) : (this.degree == null && this.executionCourse == null ? BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.male", (String[])new String[0]) : BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.default", (String[])new String[0]));
        }
        return new String[]{connector, Joiner.on((String)", ").join(parts)};
    }

    public Set<User> getMembers() {
        User user;
        HashSet<User> users = new HashSet<User>();
        if (this.degree != null) {
            for (DegreeCurricularPlan degreeCurricularPlan : this.degree.getActiveDegreeCurricularPlans()) {
                for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
                    for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                        if (!executionCourse.getExecutionYear().isCurrent()) continue;
                        for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                            User user2 = professorship.getPerson().getUser();
                            if (user2 == null) continue;
                            users.add(user2);
                        }
                    }
                }
            }
        }
        if (this.campus != null) {
            for (User user3 : RoleType.TEACHER.actualGroup().getMembers()) {
                if (user3.getPerson() == null || !user3.getPerson().getTeacher().teachesAt(this.campus)) continue;
                users.add(user3);
            }
        }
        if (this.department != null) {
            for (Teacher teacher : this.department.getAllTeachers(this.getExecutionYear())) {
                user = teacher.getPerson().getUser();
                if (user == null) continue;
                users.add(user);
            }
        }
        if (this.executionCourse != null) {
            for (Professorship professorship : this.executionCourse.getProfessorshipsSet()) {
                user = professorship.getPerson().getUser();
                if (user == null) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        if (user.getPerson().getTeacher() != null) {
            for (Professorship professorship : user.getPerson().getTeacher().getProfessorshipsSet()) {
                ExecutionCourse course = professorship.getExecutionCourse();
                if (this.degree != null) {
                    for (CurricularCourse curricularCourse : course.getAssociatedCurricularCoursesSet()) {
                        if (!curricularCourse.getDegree().equals(this.degree)) continue;
                        return true;
                    }
                }
                if (this.executionCourse != null && course.equals((Object)this.executionCourse)) {
                    return true;
                }
                if (this.campus == null || !course.functionsAt(this.campus)) continue;
                return true;
            }
            if (this.department != null && this.department.equals((Object)user.getPerson().getTeacher().getLastDepartment(this.getExecutionYear().getAcademicInterval()))) {
                return true;
            }
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentTeacherGroup.getInstance(this.degree, this.executionCourse, this.campus, this.department, this.executionYear);
    }

    public boolean equals(Object object) {
        if (object instanceof TeacherGroup) {
            TeacherGroup other = (TeacherGroup)((Object)object);
            return Objects.equal((Object)this.degree, (Object)other.degree) && Objects.equal((Object)((Object)this.executionCourse), (Object)((Object)other.executionCourse)) && Objects.equal((Object)this.campus, (Object)other.campus) && Objects.equal((Object)((Object)this.department), (Object)((Object)other.department)) && Objects.equal((Object)this.executionYear, (Object)other.executionYear);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.degree, this.executionCourse, this.campus, this.department, this.executionYear});
    }
}

