/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.text.Collator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.Branch;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope_Base;
import org.fenixedu.academic.domain.CurricularSemester;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.dto.comparators.CalendarDateComparator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class CurricularCourseScope
extends CurricularCourseScope_Base {
    public static Comparator<CurricularCourseScope> CURRICULAR_COURSE_NAME_COMPARATOR = new ComparatorChain();

    public CurricularCourseScope() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CurricularCourseScope(Branch branch, CurricularCourse curricularCourse, CurricularSemester curricularSemester, Calendar beginDate, Calendar endDate, String Annotation2) {
        this();
        if (curricularCourse.hasActiveScopeInGivenSemesterForGivenBranch(curricularSemester, branch)) {
            throw new DomainException("error.curricular.course.scope.conflict.creation", new String[0]);
        }
        this.setBranch(branch);
        this.setCurricularCourse(curricularCourse);
        this.setCurricularSemester(curricularSemester);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setAnotation(Annotation2);
    }

    public Calendar getBeginDate() {
        if (this.getBegin() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getBegin());
            return result;
        }
        return null;
    }

    public void setBeginDate(Calendar beginDate) {
        if (beginDate != null) {
            this.setBegin(beginDate.getTime());
        } else {
            this.setBegin(null);
        }
    }

    public Calendar getEndDate() {
        if (this.getEnd() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnd());
            return result;
        }
        return null;
    }

    public void setEndDate(Calendar endDate) {
        if (endDate != null) {
            this.setEnd(endDate.getTime());
        } else {
            this.setEnd(null);
        }
    }

    public Boolean isActive() {
        return this.isActive(new Date());
    }

    public boolean getActive() {
        return this.isActive();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAssociatedWrittenEvaluationsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.curricular.course.scope.has.written.evaluations", (String[])new String[0]));
        }
    }

    public Boolean isDeletable() {
        return this.getDeletionBlockers().isEmpty();
    }

    public void edit(Branch branch, CurricularSemester curricularSemester, Calendar beginDate, Calendar endDate, String Annotation2) {
        this.setBranch(branch);
        this.setCurricularSemester(curricularSemester);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setAnotation(Annotation2);
    }

    public void end(Calendar endDate) {
        this.setEndDate(endDate);
    }

    public void delete() throws DomainException {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setCurricularSemester(null);
        this.setCurricularCourse(null);
        this.setBranch(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public Boolean isActive(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CalendarDateComparator calendarDateComparator = new CalendarDateComparator();
        Boolean result = Boolean.FALSE;
        if (calendarDateComparator.compare(this.getBeginDate(), calendar) <= 0 && (this.getEndDate() == null || calendarDateComparator.compare(this.getEndDate(), calendar) >= 0)) {
            result = Boolean.TRUE;
        }
        return result;
    }

    public boolean intersects(Date begin, Date end) {
        return this.intersects(YearMonthDay.fromDateFields((Date)begin), YearMonthDay.fromDateFields((Date)end));
    }

    public boolean intersects(YearMonthDay begin, YearMonthDay end) {
        return !this.getBeginYearMonthDay().isAfter((ReadablePartial)end) && (this.getEndYearMonthDay() == null || !this.getEndYearMonthDay().isBefore((ReadablePartial)begin));
    }

    public boolean isActiveForAcademicInterval(AcademicInterval academicInterval) {
        return this.isActiveForCalendarEntry(academicInterval.getAcademicCalendarEntry());
    }

    private boolean isActiveForCalendarEntry(AcademicCalendarEntry entry) {
        if (entry instanceof AcademicCalendarRootEntry) {
            return false;
        }
        if (entry instanceof AcademicYearCE) {
            return this.intersects(entry.getBegin().toDate(), entry.getEnd().toDate());
        }
        if (this.intersects(entry.getBegin().toDate(), entry.getEnd().toDate()) && new Integer(entry.getAcademicSemesterOfAcademicYear(entry.getAcademicChronology())).equals(this.getCurricularSemester().getSemester())) {
            return true;
        }
        return this.isActiveForCalendarEntry(entry.getParentEntry());
    }

    public boolean isActiveForExecutionPeriod(ExecutionSemester executionSemester) {
        return this.intersects(executionSemester.getBeginDateYearMonthDay(), executionSemester.getEndDateYearMonthDay()) && executionSemester.getSemester().equals(this.getCurricularSemester().getSemester());
    }

    public boolean isActiveForExecutionYear(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isActiveForExecutionPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public DegreeModuleScopeCurricularCourseScope getDegreeModuleScopeCurricularCourseScope() {
        return new DegreeModuleScopeCurricularCourseScope(this);
    }

    public boolean hasEndYearMonthDay() {
        return this.getEndYearMonthDay() != null;
    }

    @Deprecated
    public Date getBegin() {
        YearMonthDay ymd = this.getBeginYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setBegin(Date date) {
        if (date == null) {
            this.setBeginYearMonthDay(null);
        } else {
            this.setBeginYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEnd() {
        YearMonthDay ymd = this.getEndYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEnd(Date date) {
        if (date == null) {
            this.setEndYearMonthDay(null);
        } else {
            this.setEndYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    static {
        ((ComparatorChain)CURRICULAR_COURSE_NAME_COMPARATOR).addComparator((Comparator)new BeanComparator("curricularCourse.name", (Comparator)Collator.getInstance()));
        ((ComparatorChain)CURRICULAR_COURSE_NAME_COMPARATOR).addComparator((Comparator)new BeanComparator("curricularCourse.externalId"));
    }

    public static class DegreeModuleScopeCurricularCourseScope
    extends DegreeModuleScope {
        private final CurricularCourseScope curricularCourseScope;

        private DegreeModuleScopeCurricularCourseScope(CurricularCourseScope curricularCourseScope) {
            this.curricularCourseScope = curricularCourseScope;
        }

        @Override
        public String getExternalId() {
            return this.curricularCourseScope.getExternalId();
        }

        @Override
        public Integer getCurricularSemester() {
            return this.curricularCourseScope.getCurricularSemester().getSemester();
        }

        @Override
        public Integer getCurricularYear() {
            return this.curricularCourseScope.getCurricularSemester().getCurricularYear().getYear();
        }

        @Override
        public String getBranch() {
            return this.curricularCourseScope.getBranch() == null ? "" : this.curricularCourseScope.getBranch().getName();
        }

        public CurricularCourseScope getCurricularCourseScope() {
            return this.curricularCourseScope;
        }

        @Override
        public boolean isActiveForExecutionPeriod(ExecutionSemester executionSemester) {
            return this.curricularCourseScope.isActiveForExecutionPeriod(executionSemester);
        }

        @Override
        public boolean isActiveForAcademicInterval(AcademicInterval academicInterval) {
            return this.curricularCourseScope.isActiveForAcademicInterval(academicInterval);
        }

        @Override
        public CurricularCourse getCurricularCourse() {
            return this.curricularCourseScope.getCurricularCourse();
        }

        @Override
        public String getAnotation() {
            return this.curricularCourseScope.getAnotation();
        }

        @Override
        public String getClassName() {
            return ((Object)((Object)this.curricularCourseScope)).getClass().getName();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DegreeModuleScopeCurricularCourseScope)) {
                return false;
            }
            return this.curricularCourseScope.equals((Object)((DegreeModuleScopeCurricularCourseScope)obj).getCurricularCourseScope());
        }

        public int hashCode() {
            return this.curricularCourseScope.hashCode();
        }
    }
}

