/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.BusinessArea_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class BusinessArea
extends BusinessArea_Base {
    public BusinessArea(Integer level, String code, String description) {
        if (level == null) {
            throw new DomainException("businessArea.creation.level.null", new String[0]);
        }
        if (code == null) {
            throw new DomainException("businessArea.creation.code.null", new String[0]);
        }
        if (description == null) {
            throw new DomainException("businessArea.creation.description.null", new String[0]);
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.setLevel(level);
        this.setCode(code);
        this.setDescription(description);
    }

    public BusinessArea(Integer level, String code, String description, BusinessArea parentArea) {
        this(level, code, description);
        this.setParentArea(parentArea);
    }

    public static List<BusinessArea> getParentBusinessAreas() {
        ArrayList<BusinessArea> parentAreas = new ArrayList<BusinessArea>();
        for (BusinessArea area : Bennu.getInstance().getBusinessAreasSet()) {
            if (area.getParentArea() != null) continue;
            parentAreas.add(area);
        }
        return parentAreas;
    }

    public static Object getChildBusinessAreas(BusinessArea parentArea) {
        ArrayList<BusinessArea> childAreas = new ArrayList<BusinessArea>();
        for (BusinessArea area : Bennu.getInstance().getBusinessAreasSet()) {
            if (area.getParentArea() == null || !area.getParentArea().equals((Object)parentArea)) continue;
            childAreas.add(area);
        }
        return childAreas;
    }
}

