/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Alumni$callable$validateEmailFromRegistrationProcess;
import org.fenixedu.academic.domain.AlumniIdentityCheckRequest;
import org.fenixedu.academic.domain.AlumniRequestType;
import org.fenixedu.academic.domain.Alumni_Base;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.alumni.AlumniSearchBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Alumni
extends Alumni_Base {
    public static final Advice advice$validateEmailFromRegistrationProcess = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public Alumni(Student student) {
        this(student, null, Boolean.FALSE);
    }

    public Alumni(Student student, UUID uuid, Boolean registered) {
        if (student == null) {
            throw new DomainException("alumni.creation.student.null", new String[0]);
        }
        this.setStudent(student);
        if (uuid != null) {
            this.setUrlRequestToken(uuid);
        }
        this.setRegisteredWhen(new DateTime());
        this.setRegistered(registered);
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Alumni readByStudentNumber(Integer studentNumber) {
        return Student.readStudentByNumber(studentNumber).getAlumni();
    }

    public Boolean hasDocumentIdNumber(String documentIdNumber) {
        return this.getDocumentIdNumber().equals(documentIdNumber);
    }

    public Boolean hasStudentNumber(Integer studentNumber) {
        return this.getStudentNumber().equals(studentNumber);
    }

    public static Alumni readAlumniByStudentNumber(Integer studentNumber) {
        for (Alumni alumni : Bennu.getInstance().getAlumnisSet()) {
            if (!alumni.getStudent().getNumber().equals(studentNumber)) continue;
            return alumni;
        }
        return null;
    }

    public Integer getStudentNumber() {
        return this.getStudent().getNumber();
    }

    public String getDocumentIdNumber() {
        return this.getStudent().getPerson().getDocumentIdNumber();
    }

    public MobilePhone getPersonalMobilePhone() {
        for (MobilePhone phone : this.getStudent().getPerson().getMobilePhones()) {
            if (!phone.isPersonalType()) continue;
            return phone;
        }
        return null;
    }

    public Boolean hasPersonalMobilePhone() {
        return this.getPersonalMobilePhone() != null;
    }

    public EmailAddress getPersonalEmail() {
        for (EmailAddress email : this.getStudent().getPerson().getEmailAddresses()) {
            if (!email.isPersonalType()) continue;
            return email;
        }
        return null;
    }

    public Boolean hasPersonalEmail() {
        return this.getPersonalEmail() != null;
    }

    public Phone getPersonalPhone() {
        for (Phone phone : this.getStudent().getPerson().getPhones()) {
            if (!phone.isPersonalType()) continue;
            return phone;
        }
        return null;
    }

    public Boolean hasPersonalPhone() {
        return this.getPersonalPhone() != null;
    }

    public PhysicalAddress getLastPersonalAddress() {
        TreeSet<DomainObject> addressSet = new TreeSet<DomainObject>(DomainObjectUtil.COMPARATOR_BY_ID);
        addressSet.addAll(this.getStudent().getPerson().getPhysicalAddresses());
        return !addressSet.isEmpty() && addressSet.last() != null ? (PhysicalAddress)((Object)addressSet.last()) : null;
    }

    public PhysicalAddress getPersonalAddress() {
        if (this.getStudent().getPerson().hasDefaultPhysicalAddress()) {
            return this.getStudent().getPerson().getDefaultPhysicalAddress();
        }
        return null;
    }

    public Boolean hasAnyJobs() {
        return !this.getStudent().getPerson().getJobsSet().isEmpty();
    }

    public List<Job> getJobs() {
        ArrayList<Job> jobs = new ArrayList<Job>(this.getStudent().getPerson().getJobsSet());
        Collections.sort(jobs, Job.REVERSE_COMPARATOR_BY_BEGIN_DATE);
        return jobs;
    }

    public Job getLastJob() {
        List<Job> jobs = this.getJobs();
        return jobs.get(jobs.size() - 1);
    }

    public Boolean canChangePersonalAddress() {
        Person p = this.getStudent().getPerson();
        if (RoleType.TEACHER.isMember(p.getUser())) {
            return Boolean.FALSE;
        }
        if (RoleType.STUDENT.isMember(p.getUser())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public List<Formation> getFormations() {
        ArrayList<Formation> formations = new ArrayList<Formation>(this.getStudent().getPerson().getFormations());
        Collections.sort(formations, Formation.COMPARATOR_BY_BEGIN_YEAR);
        return formations;
    }

    public PhysicalAddress getUpdatableAddress() {
        List partyContacts = this.getStudent().getPerson().getPartyContacts(PhysicalAddress.class);
        for (int i = 0; i < partyContacts.size(); ++i) {
            PhysicalAddress address = (PhysicalAddress)((Object)partyContacts.get(i));
            if (address.isDefault()) continue;
            return address;
        }
        return null;
    }

    public PartyContact getUpdatablePartyContact(Class<? extends PartyContact> clazz) {
        List partyContacts = this.getStudent().getPerson().getPartyContacts(clazz);
        for (int i = 0; i < partyContacts.size(); ++i) {
            if (((PartyContact)((Object)partyContacts.get(i))).isDefault()) continue;
            return (PartyContact)((Object)partyContacts.get(i));
        }
        return null;
    }

    public EmailAddress getUpdatableMobilePhone() {
        List partyContacts = this.getStudent().getPerson().getPartyContacts(EmailAddress.class);
        for (int i = 0; i < partyContacts.size(); ++i) {
            EmailAddress email = (EmailAddress)((Object)partyContacts.get(i));
            if (email.isDefault()) continue;
            return email;
        }
        return null;
    }

    public static List<Registration> readAlumniRegistrations(AlumniSearchBean bean) {
        if (StringUtils.isEmpty((String)bean.getName())) {
            return new ArrayList<Registration>();
        }
        ExecutionYear firstYear = bean.getFirstExecutionYear() == null ? ExecutionYear.readFirstExecutionYear() : bean.getFirstExecutionYear();
        ExecutionYear finalYear = bean.getFinalExecutionYear() == null ? ExecutionYear.readLastExecutionYear() : bean.getFinalExecutionYear();
        ArrayList<Registration> resultRegistrations = new ArrayList<Registration>();
        for (Person person : Person.readPersonsByNameAndRoleType(bean.getName(), RoleType.ALUMNI)) {
            if (person.getStudent() == null || bean.getStudentNumber() != null && !person.getStudent().getNumber().equals(bean.getStudentNumber())) continue;
            for (Registration registration : bean.getDegreeType() == null ? person.getStudent().getRegistrationsSet() : person.getStudent().getRegistrationsMatchingDegreeType(Predicate.isEqual(bean.getDegreeType()))) {
                if (!registration.isConcluded()) continue;
                if (bean.getDegree() != null) {
                    if (!registration.hasStartedBetween(firstYear, finalYear) || !registration.getDegree().equals(bean.getDegree())) continue;
                    resultRegistrations.add(registration);
                    continue;
                }
                if (!registration.hasStartedBetween(firstYear, finalYear)) continue;
                resultRegistrations.add(registration);
            }
        }
        return resultRegistrations;
    }

    public static List<Registration> readRegistrations(AlumniSearchBean bean) {
        ArrayList<Registration> filteredResultRegistrations;
        block21: {
            String email;
            String mobileNumber;
            String telephoneNumber;
            block20: {
                Person person;
                Collection<Person> persons;
                String personName = bean.getName();
                Integer studentNumber = bean.getStudentNumber();
                String documentIdNumber = bean.getDocumentIdNumber();
                ArrayList<Object> resultRegistrations = new ArrayList<Object>();
                if (!StringUtils.isEmpty((String)personName)) {
                    for (Object person2 : Person.readPersonsByNameAndRoleType(personName, RoleType.ALUMNI)) {
                        if (!Alumni.matchStudentNumber(person2, studentNumber) || !Alumni.matchDocumentIdNumber(person2, documentIdNumber)) continue;
                        for (Registration registration : person2.getStudent().getRegistrationsSet()) {
                            if (!registration.isConcluded()) continue;
                            resultRegistrations.add((Object)registration);
                        }
                    }
                } else if (studentNumber != null) {
                    Student student = Student.readStudentByNumber(studentNumber);
                    if (student != null && Alumni.matchDocumentIdNumber(student.getPerson(), documentIdNumber)) {
                        for (Object registration : student.getRegistrationsSet()) {
                            if (!registration.isConcluded()) continue;
                            resultRegistrations.add(registration);
                        }
                    }
                } else if (documentIdNumber != null && !(persons = Person.readByDocumentIdNumber(documentIdNumber)).isEmpty() && Alumni.matchStudentNumber(person = persons.iterator().next(), studentNumber) && person.getStudent() != null) {
                    for (Registration registration : person.getStudent().getRegistrationsSet()) {
                        if (!registration.isConcluded()) continue;
                        resultRegistrations.add((Object)registration);
                    }
                }
                telephoneNumber = bean.getTelephoneNumber();
                mobileNumber = bean.getMobileNumber();
                email = bean.getEmail();
                filteredResultRegistrations = new ArrayList<Registration>();
                if (StringUtils.isEmpty((String)personName) && studentNumber == null && StringUtils.isEmpty((String)documentIdNumber)) break block20;
                for (Registration registration : resultRegistrations) {
                    boolean match = true;
                    if (!(StringUtils.isEmpty((String)telephoneNumber) && StringUtils.isEmpty((String)email) && StringUtils.isEmpty((String)mobileNumber))) {
                        if (registration.getPerson().getPartyContactsSet().isEmpty() || !StringUtils.isEmpty((String)mobileNumber) && !registration.getPerson().hasAnyPartyContact(MobilePhone.class) || !StringUtils.isEmpty((String)telephoneNumber) && !registration.getPerson().hasAnyPartyContact(Phone.class) || !StringUtils.isEmpty((String)email) && !registration.getPerson().hasAnyPartyContact(EmailAddress.class)) continue;
                        for (PartyContact contact : registration.getPerson().getPartyContactsSet()) {
                            if (!StringUtils.isEmpty((String)mobileNumber) && contact.isMobile() && !mobileNumber.equals(contact.getPresentationValue())) {
                                match = false;
                                break;
                            }
                            if (!StringUtils.isEmpty((String)telephoneNumber) && contact.isPhone() && !telephoneNumber.equals(contact.getPresentationValue())) {
                                match = false;
                                break;
                            }
                            if (StringUtils.isEmpty((String)email) || !contact.isEmailAddress() || email.equals(contact.getPresentationValue())) continue;
                            match = false;
                            break;
                        }
                    }
                    if (!match) continue;
                    filteredResultRegistrations.add(registration);
                }
                break block21;
            }
            if (StringUtils.isEmpty((String)telephoneNumber) && StringUtils.isEmpty((String)email) && StringUtils.isEmpty((String)mobileNumber)) break block21;
            ArrayList<Class<MobilePhone>> clazzList = new ArrayList<Class<MobilePhone>>();
            if (!StringUtils.isEmpty((String)telephoneNumber)) {
                clazzList.add(Phone.class);
            }
            if (!StringUtils.isEmpty((String)email)) {
                clazzList.add(EmailAddress.class);
            }
            if (!StringUtils.isEmpty((String)mobileNumber)) {
                clazzList.add(MobilePhone.class);
            }
            HashSet<Person> hashSet = new HashSet<Person>();
            Set<PartyContact> contacts = PartyContact.readPartyContactsOfType(clazzList.toArray(new Class[0]));
            for (PartyContact contact : contacts) {
                if (!StringUtils.isEmpty((String)mobileNumber) && (!contact.isMobile() || !mobileNumber.equals(contact.getPresentationValue())) || !StringUtils.isEmpty((String)telephoneNumber) && (!contact.isPhone() || !telephoneNumber.equals(contact.getPresentationValue())) || !StringUtils.isEmpty((String)email) && (!contact.isEmailAddress() || !email.equals(contact.getPresentationValue())) || !contact.getParty().isPerson() || hashSet.contains(contact.getParty())) continue;
                Person person = (Person)((Object)contact.getParty());
                hashSet.add(person);
                if (!RoleType.ALUMNI.isMember(person.getUser()) || person.getStudent() == null) continue;
                for (Registration registration : person.getStudent().getRegistrationsSet()) {
                    if (!registration.isConcluded()) continue;
                    filteredResultRegistrations.add(registration);
                }
            }
        }
        return filteredResultRegistrations;
    }

    private static boolean matchDocumentIdNumber(Person person, String documentIdNumber) {
        return StringUtils.isEmpty((String)documentIdNumber) || !StringUtils.isEmpty((String)person.getDocumentIdNumber()) && person.getDocumentIdNumber().equals(documentIdNumber);
    }

    private static boolean matchStudentNumber(Person person, Integer studentNumber) {
        return studentNumber == null || person.getStudent() != null && person.getStudent().getNumber().equals(studentNumber);
    }

    public Boolean hasEmailAddress(String emailAddress) {
        for (EmailAddress personEmail : this.getStudent().getPerson().getPartyContacts(EmailAddress.class)) {
            if (!personEmail.getValue().equals(emailAddress)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void addIfNotExistsEmail(String email) {
        EmailAddress.createEmailAddress((Party)((Object)this.getStudent().getPerson()), email, PartyContactType.PERSONAL, false);
    }

    public boolean isRegistered() {
        return this.getRegistered();
    }

    public boolean hasPastLogin() {
        return false;
    }

    public boolean hasAnyPendingIdentityRequests() {
        for (AlumniIdentityCheckRequest request : this.getIdentityRequestsSet()) {
            if (request.getApproved() != null) continue;
            return true;
        }
        return false;
    }

    public AlumniIdentityCheckRequest getLastIdentityRequest() {
        TreeSet<AlumniIdentityCheckRequest> orderedSet = new TreeSet<AlumniIdentityCheckRequest>((Comparator<AlumniIdentityCheckRequest>)new ReverseComparator((Comparator)new BeanComparator("creationDateTime")));
        for (AlumniIdentityCheckRequest request : this.getIdentityRequestsSet()) {
            orderedSet.add(request);
        }
        return orderedSet.size() != 0 ? (AlumniIdentityCheckRequest)((Object)orderedSet.iterator().next()) : null;
    }

    public String getLoginUsername() {
        return this.getStudent().getPerson().getUsername();
    }

    public boolean hasStartedPublicRegistry() {
        return this.getUrlRequestToken() != null;
    }

    public boolean hasFinishedPublicRegistry() {
        return this.hasStartedPublicRegistry() && this.isRegistered();
    }

    public String getName() {
        return this.getStudent().getPerson().getName();
    }

    public void delete() {
        this.setStudent(null);
        this.getIdentityRequestsSet().clear();
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isRecoveringPassword() {
        boolean hasPasswordRequestAccepted = false;
        boolean hasPasswordRequest = false;
        for (AlumniIdentityCheckRequest request : this.getIdentityRequestsSet()) {
            if (!AlumniRequestType.PASSWORD_REQUEST.equals((Object)request.getRequestType())) continue;
            if (!hasPasswordRequest) {
                hasPasswordRequest = true;
            }
            if (!request.getApproved().booleanValue()) continue;
            hasPasswordRequestAccepted = true;
            break;
        }
        return hasPasswordRequest && !hasPasswordRequestAccepted;
    }

    public void validateEmailFromRegistrationProcess() {
        Object object = advice$validateEmailFromRegistrationProcess.perform((Callable)new Alumni$callable$validateEmailFromRegistrationProcess(this));
    }

    static /* synthetic */ void advised$validateEmailFromRegistrationProcess(Alumni this_) {
        Person person = this_.getStudent().getPerson();
        for (EmailAddress address : person.getPendingEmailAddresses()) {
            if (!PartyContactType.PERSONAL.equals((Object)address.getType())) continue;
            address.setValid();
        }
    }
}

