/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.enrollment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInClassesCandidate;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.academic.ui.struts.action.student.enrollment.EnrolmentContextHandler;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentApplication.StudentEnrollApp.class, path="schoolClass-student-enrollment", titleKey="link.schoolClass.student.enrolment")
@Mapping(module="student", path="/schoolClassStudentEnrollment")
@Forwards(value={@Forward(name="showSchoolClasses", path="/student/enrollment/schoolClass/schoolClassesSelection.jsp")})
public class SchoolClassStudentEnrollmentDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Student student = SchoolClassStudentEnrollmentDA.getUserView(request).getPerson().getStudent();
        SchoolClass selectedSchoolClass = (SchoolClass)((Object)request.getAttribute("selectedSchoolClass"));
        EnrolmentPeriod selectedEnrolmentPeriod = (EnrolmentPeriod)((Object)request.getAttribute("selectedEnrolmentPeriod"));
        ArrayList<SchoolClassStudentEnrollmentDTO> enrollmentBeans = new ArrayList<SchoolClassStudentEnrollmentDTO>();
        Collection<Registration> registrationsToShow = null;
        String workflowRegistrationOid = request.getParameter("workflowRegistrationOid");
        if (workflowRegistrationOid != null) {
            Registration workflowRegistation = (Registration)FenixFramework.getDomainObject((String)workflowRegistrationOid);
            registrationsToShow = Collections.singleton(workflowRegistation);
            request.setAttribute("workflowRegistrationOid", (Object)workflowRegistrationOid);
            Optional<String> returnURLForStudentInClasses = EnrolmentContextHandler.getRegisteredEnrolmentContextHandler().getReturnURLForStudentInFullClasses(request, workflowRegistation);
            if (returnURLForStudentInClasses.isPresent()) {
                request.setAttribute("returnURL", (Object)returnURLForStudentInClasses.get());
            }
        } else {
            registrationsToShow = student.getRegistrationsToEnrolInShiftByStudent();
        }
        for (Registration registration : registrationsToShow) {
            if (EnrolmentContextHandler.getRegisteredEnrolmentContextHandler().getReturnURLForStudentInFullClasses(request, registration).isPresent() && !registration.getExternalId().equals(workflowRegistrationOid)) continue;
            for (EnrolmentPeriod enrolmentPeriod : registration.getActiveDegreeCurricularPlan().getEnrolmentPeriodsSet()) {
                if (!this.isValidPeriodForUser(enrolmentPeriod, registration.getActiveStudentCurricularPlan())) continue;
                enrollmentBeans.add(new SchoolClassStudentEnrollmentDTO(registration, enrolmentPeriod, selectedEnrolmentPeriod == enrolmentPeriod ? selectedSchoolClass : null));
            }
        }
        enrollmentBeans.sort(Comparator.naturalOrder());
        request.setAttribute("enrollmentBeans", enrollmentBeans);
        return mapping.findForward("showSchoolClasses");
    }

    public ActionForward viewSchoolClass(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SchoolClass schoolClass = (SchoolClass)((Object)this.getDomainObject(request, "schoolClassID"));
        EnrolmentPeriod enrolmentPeriod = (EnrolmentPeriod)((Object)this.getDomainObject(request, "enrolmentPeriodID"));
        request.setAttribute("selectedSchoolClass", (Object)schoolClass);
        request.setAttribute("selectedEnrolmentPeriod", (Object)enrolmentPeriod);
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward enrollInSchoolClass(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SchoolClass schoolClass = (SchoolClass)((Object)this.getDomainObject(request, "schoolClassID"));
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationID"));
        EnrolmentPeriod enrolmentPeriod = (EnrolmentPeriod)((Object)this.getDomainObject(request, "enrolmentPeriodID"));
        try {
            this.atomic(() -> registration.replaceSchoolClass(schoolClass, enrolmentPeriod.getExecutionPeriod()));
            String successMessage = schoolClass != null ? "message.schoolClassStudentEnrollment.enrollInSchoolClass.success" : "message.schoolClassStudentEnrollment.unenrollInSchoolClass.success";
            this.addActionMessage("success", request, successMessage);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        request.setAttribute("selectedSchoolClass", (Object)schoolClass);
        request.setAttribute("selectedEnrolmentPeriod", (Object)enrolmentPeriod);
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward removeShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SchoolClass schoolClass = (SchoolClass)((Object)this.getDomainObject(request, "schoolClassID"));
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationID"));
        EnrolmentPeriod enrolmentPeriod = (EnrolmentPeriod)((Object)this.getDomainObject(request, "enrolmentPeriodID"));
        Shift shift = (Shift)((Object)this.getDomainObject(request, "shiftID"));
        try {
            this.atomic(() -> registration.removeShifts(shift));
            this.addActionMessage("success", request, "message.schoolClassStudentEnrollment.removeShift.success");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        request.setAttribute("selectedSchoolClass", (Object)schoolClass);
        request.setAttribute("selectedEnrolmentPeriod", (Object)enrolmentPeriod);
        return this.prepare(mapping, form, request, response);
    }

    private boolean isValidPeriodForUser(EnrolmentPeriod ep, StudentCurricularPlan studentCurricularPlan) {
        if (ep.isValid()) {
            if (studentCurricularPlan.isInCandidateEnrolmentProcess(ep.getExecutionPeriod().getExecutionYear())) {
                return ep instanceof EnrolmentPeriodInClassesCandidate;
            }
            return ep.isForClasses();
        }
        return false;
    }

    public static class SchoolClassStudentEnrollmentDTO
    implements Serializable,
    Comparable<SchoolClassStudentEnrollmentDTO> {
        private final Registration registration;
        private final EnrolmentPeriod enrolmentPeriod;
        private final SchoolClass schoolClassToDisplay;

        public SchoolClassStudentEnrollmentDTO(Registration registration, EnrolmentPeriod enrolmentPeriod, SchoolClass schoolClassToDisplay) {
            this.registration = registration;
            this.enrolmentPeriod = enrolmentPeriod;
            this.schoolClassToDisplay = schoolClassToDisplay;
        }

        public Registration getRegistration() {
            return this.registration;
        }

        public EnrolmentPeriod getEnrolmentPeriod() {
            return this.enrolmentPeriod;
        }

        public SchoolClass getCurrentSchoolClass() {
            return this.getRegistration().getSchoolClassBy(this.getEnrolmentPeriod().getExecutionPeriod()).orElse(null);
        }

        public SchoolClass getSchoolClassToDisplay() {
            if (this.schoolClassToDisplay != null) {
                return this.schoolClassToDisplay;
            }
            SchoolClass currentSchoolClass = this.getCurrentSchoolClass();
            return currentSchoolClass != null ? currentSchoolClass : (SchoolClass)this.getSchoolClassesToEnrol().stream().findFirst().orElse(null);
        }

        public int getMatchedCoursesNumber() {
            SchoolClass schoolClassToDisplay = this.getSchoolClassToDisplay();
            if (schoolClassToDisplay != null) {
                return this.getAttendingShifts(schoolClassToDisplay).stream().map(s -> s.getExecutionCourse()).collect(Collectors.toSet()).size();
            }
            return 0;
        }

        public boolean isSchoolClassToDisplayFree() {
            SchoolClass schoolClassToDisplay = this.getSchoolClassToDisplay();
            if (schoolClassToDisplay != null) {
                return !this.getAttendingShifts(schoolClassToDisplay).stream().anyMatch(s -> s.getLotacao() <= s.getStudentsSet().size());
            }
            return false;
        }

        public List<Shift> getSchoolClassToDisplayShifts() {
            SchoolClass schoolClassToDisplay = this.getSchoolClassToDisplay();
            SchoolClass currentSchoolClass = this.getCurrentSchoolClass();
            if (schoolClassToDisplay != null) {
                List<Shift> shifts = this.getAttendingShifts(schoolClassToDisplay);
                if (schoolClassToDisplay == currentSchoolClass) {
                    List<Shift> enrolledShifts = this.registration.getShiftsFor(schoolClassToDisplay.getExecutionPeriod());
                    shifts = shifts.stream().filter(s -> enrolledShifts.contains(s)).collect(Collectors.toList());
                }
                return shifts;
            }
            return Collections.emptyList();
        }

        protected List<Shift> getAttendingShifts(SchoolClass schoolClassToDisplay) {
            List<ExecutionCourse> attendingExecutionCourses = this.registration.getAttendingExecutionCoursesFor(schoolClassToDisplay.getExecutionPeriod());
            return schoolClassToDisplay.getAssociatedShiftsSet().stream().filter(s -> attendingExecutionCourses.contains((Object)s.getExecutionCourse())).collect(Collectors.toList());
        }

        public String getSchoolClassToDisplayLessonsJson() {
            JsonArray result = new JsonArray();
            for (Shift shift : this.getSchoolClassToDisplayShifts()) {
                for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                    DateTime now = new DateTime();
                    DateTime weekDay = now.withDayOfWeek(lesson.getDiaSemana().getDiaSemanaInDayOfWeekJodaFormat());
                    DateTime startTime = weekDay.withTime(lesson.getBeginHourMinuteSecond().getHour(), lesson.getBeginHourMinuteSecond().getMinuteOfHour(), 0, 0);
                    DateTime endTime = weekDay.withTime(lesson.getEndHourMinuteSecond().getHour(), lesson.getEndHourMinuteSecond().getMinuteOfHour(), 0, 0);
                    JsonObject event = new JsonObject();
                    event.addProperty("id", lesson.getExternalId());
                    event.addProperty("start", startTime.toString());
                    event.addProperty("end", endTime.toString());
                    event.addProperty("title", shift.getExecutionCourse().getName() + " (" + shift.getShiftTypesCodePrettyPrint() + ")");
                    event.addProperty("shiftId", shift.getExternalId());
                    event.addProperty("shiftLessons", shift.getLessonPresentationString());
                    event.addProperty("shiftTypes", shift.getShiftTypesPrettyPrint());
                    result.add((JsonElement)event);
                }
            }
            return result.toString();
        }

        public List<SchoolClass> getSchoolClassesToEnrol() {
            int curricularYear = this.getCurricularYear();
            return this.getRegistration().getSchoolClassesToEnrolBy(this.getRegistration().getActiveDegreeCurricularPlan(), this.getEnrolmentPeriod().getExecutionPeriod()).stream().filter(s -> s.getAnoCurricular().equals(curricularYear)).sorted((s1, s2) -> s1.getNome().compareTo(s2.getNome())).collect(Collectors.toList());
        }

        public int getCurricularYear() {
            ExecutionSemester executionSemester = this.getEnrolmentPeriod().getExecutionPeriod();
            return this.getRegistration().getCurricularYear(executionSemester.getExecutionYear());
        }

        @Override
        public int compareTo(SchoolClassStudentEnrollmentDTO o) {
            int result = Degree.COMPARATOR_BY_NAME_AND_ID.compare(this.getRegistration().getDegree(), o.getRegistration().getDegree());
            return result == 0 ? this.getEnrolmentPeriod().getExecutionPeriod().compareTo(o.getEnrolmentPeriod().getExecutionPeriod()) : result;
        }
    }
}

