/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices.StudentAcademicOfficeServices;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentAcademicOfficeServices.class, path="view-document-requests", titleKey="documents.requirement.consult")
@Mapping(path="/viewDocumentRequests", module="student", formBean="documentRequestCreateForm")
@Forwards(value={@Forward(name="viewDocumentRequests", path="/student/administrativeOfficeServices/documentRequest/viewDocumentRequests.jsp"), @Forward(name="prepareCancelAcademicServiceRequest", path="/student/administrativeOfficeServices/documentRequest/prepareCancelAcademicServiceRequest.jsp"), @Forward(name="cancelSuccess", path="/student/administrativeOfficeServices/documentRequest/cancelSuccess.jsp"), @Forward(name="viewDocumentRequest", path="/student/administrativeOfficeServices/documentRequest/viewDocumentRequest.jsp")})
public class ViewDocumentRequestsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward viewDocumentRequests(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("student", (Object)this.getLoggedPerson(request).getStudent());
        request.setAttribute("documentRequests", this.getDocumentRequest());
        return mapping.findForward("viewDocumentRequests");
    }

    private List<AcademicServiceRequest> getDocumentRequest() {
        ArrayList<AcademicServiceRequest> result = new ArrayList<AcademicServiceRequest>();
        for (Registration registration : AccessControl.getPerson().getStudent().getRegistrationsSet()) {
            result.addAll(registration.getAcademicServiceRequestsSet());
        }
        return result;
    }

    public ActionForward viewDocumentRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("documentRequest", (Object)FenixFramework.getDomainObject((String)request.getParameter("documentRequestId")));
        return mapping.findForward("viewDocumentRequest");
    }

    public ActionForward prepareCancelAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.getAndSetAcademicServiceRequest(request);
        return mapping.findForward("prepareCancelAcademicServiceRequest");
    }

    public ActionForward cancelAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        AcademicServiceRequest academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        String justification = ((DynaActionForm)actionForm).getString("justification");
        try {
            academicServiceRequest.cancel(justification);
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            return mapping.findForward("prepareCancelAcademicServiceRequest");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
            return mapping.findForward("prepareCancelAcademicServiceRequest");
        }
        return mapping.findForward("cancelSuccess");
    }

    private AcademicServiceRequest getAndSetAcademicServiceRequest(HttpServletRequest request) {
        AcademicServiceRequest academicServiceRequest = (AcademicServiceRequest)FenixFramework.getDomainObject((String)request.getParameter("academicServiceRequestId"));
        request.setAttribute("academicServiceRequest", (Object)academicServiceRequest);
        return academicServiceRequest;
    }
}

