/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.erasmus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusApplyForSemesterType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreeCourseInformationBean
implements Serializable,
DataProvider {
    private static final long serialVersionUID = 1L;
    Degree chosenDegree;
    CurricularCourse chosenCourse;
    ExecutionYear executionYear;
    MobilityApplicationProcess mobilityApplicationProcess;

    public DegreeCourseInformationBean(ExecutionYear executionYear, MobilityApplicationProcess mobilityApplicationProcess) {
        this.setExecutionYear(executionYear);
        this.setMobilityApplicationProcess(mobilityApplicationProcess);
    }

    public DegreeCourseInformationBean() {
    }

    public Degree getChosenDegree() {
        return this.chosenDegree;
    }

    public void setChosenDegree(Degree chosenDegree) {
        this.chosenDegree = chosenDegree;
    }

    public CurricularCourse getChosenCourse() {
        return this.chosenCourse;
    }

    public void setChosenCourse(CurricularCourse chosenCourse) {
        this.chosenCourse = chosenCourse;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    private List<DegreeCurricularPlan> getChosenDegreeCurricularPlans() {
        if (this.getChosenDegree() != null) {
            return this.getChosenDegree().getDegreeCurricularPlansForYear(this.getExecutionYear());
        }
        return new ArrayList<DegreeCurricularPlan>();
    }

    private SortedSet<CurricularCourse> getCurricularCoursesForChosenDegree() {
        TreeSet<CurricularCourse> result = new TreeSet<CurricularCourse>(CurricularCourse.COMPARATOR_BY_NAME);
        for (DegreeCurricularPlan degreeCurricularPlan : this.getChosenDegreeCurricularPlans()) {
            ExecutionSemester firstSemester = this.getExecutionYear().getExecutionSemesterFor(1);
            ExecutionSemester secondSemester = this.getExecutionYear().getExecutionSemesterFor(2);
            if (this.getMobilityApplicationProcess().getForSemester().equals((Object)ErasmusApplyForSemesterType.FIRST_SEMESTER)) {
                result.addAll(degreeCurricularPlan.getActiveCurricularCourses(firstSemester));
            }
            result.addAll(degreeCurricularPlan.getActiveCurricularCourses(secondSemester));
        }
        return result;
    }

    public Object provide(Object source, Object currentValue) {
        DegreeCourseInformationBean chooseDegreeBean = (DegreeCourseInformationBean)source;
        return chooseDegreeBean.getCurricularCoursesForChosenDegree();
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }

    public MobilityApplicationProcess getMobilityApplicationProcess() {
        return this.mobilityApplicationProcess;
    }

    public void setMobilityApplicationProcess(MobilityApplicationProcess mobilityApplicationProcess) {
        this.mobilityApplicationProcess = mobilityApplicationProcess;
    }
}

