/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.alumni;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.alumni.AlumniSearchBean;
import org.fenixedu.academic.ui.struts.action.alumni.AlumniApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AlumniApplication.AlumniAcademicPathApp.class, path="search-alumni", titleKey="link.search.alumni")
@Mapping(module="alumni", path="/searchAlumni")
@Forwards(value={@Forward(name="viewAlumniDetails", path="/alumni/viewAlumniDetails.jsp"), @Forward(name="showAlumniList", path="/alumni/showAlumniList.jsp")})
public class AlumniSearchDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward showAlumniList(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniSearchBean searchBean = this.reconstructBeanFromRequest(request);
        if (!StringUtils.isEmpty((String)searchBean.getName()) || searchBean.getDegreeType() != null) {
            List resultRegistrations = this.readAlumniRegistrations(searchBean);
            resultRegistrations = request.getParameter("sort") != null && request.getParameter("sort").length() > 0 ? RenderUtils.sortCollectionWithCriteria((Collection)resultRegistrations, (String)request.getParameter("sort")) : RenderUtils.sortCollectionWithCriteria(resultRegistrations, (String)"student.person.name");
            searchBean.setAlumni(new ArrayList<Registration>(resultRegistrations));
            searchBean.setTotalItems(resultRegistrations.size());
        }
        request.setAttribute("searchAlumniBean", (Object)searchBean);
        return mapping.findForward("showAlumniList");
    }

    public ActionForward degreeTypePostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniSearchBean searchBean = this.reconstructBeanFromRequest(request);
        RenderUtils.invalidateViewState();
        request.setAttribute("searchAlumniBean", (Object)searchBean);
        return mapping.findForward("showAlumniList");
    }

    protected AlumniSearchBean reconstructBeanFromRequest(HttpServletRequest request) {
        IViewState viewState = RenderUtils.getViewState((String)"searchAlumniBean");
        if (viewState != null) {
            return (AlumniSearchBean)viewState.getMetaObject().getObject();
        }
        if (request.getParameter("beansearch") != null && request.getParameter("beansearch").length() > 0) {
            return AlumniSearchBean.getBeanFromParameters(request.getParameter("beansearch"));
        }
        return new AlumniSearchBean();
    }

    public ActionForward visualizeAlumni(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniData", this.getDomainObject(request, "studentId"));
        return mapping.findForward("viewAlumniDetails");
    }

    protected List<Registration> readAlumniRegistrations(AlumniSearchBean searchBean) {
        return Alumni.readAlumniRegistrations(searchBean);
    }
}

