/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller;

import java.io.IOException;
import java.io.InputStream;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.photograph.PictureMode;
import org.fenixedu.bennu.core.domain.Avatar;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.joda.time.DateTime;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/user/photo"})
public class PhotographController {
    @RequestMapping(value={"{username:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> get(@PathVariable String username, @RequestParam(value="s", required=false, defaultValue="100") Integer size, @RequestHeader(value="If-None-Match", required=false) String ifNoneMatch) throws IOException {
        User user = User.findByUsername((String)username);
        if (user != null && user.getPerson() != null) {
            Photograph personalPhoto = user.getPerson().isPhotoAvailableToCurrentUser() ? user.getPerson().getPersonalPhoto() : null;
            HttpHeaders headers = new HttpHeaders();
            String etag = "W/\"" + (personalPhoto == null ? "mm-av" : personalPhoto.getExternalId()) + "-" + size + "\"";
            headers.setETag(etag);
            headers.setExpires(DateTime.now().plusWeeks(2).getMillis());
            headers.setCacheControl("max-age=1209600");
            if (etag.equals(ifNoneMatch)) {
                return new ResponseEntity((MultiValueMap)headers, HttpStatus.NOT_MODIFIED);
            }
            if (personalPhoto != null) {
                headers.set("Content-Type", personalPhoto.getOriginal().getPictureFileFormat().getMimeType());
                return new ResponseEntity((Object)personalPhoto.getCustomAvatar(size, size, PictureMode.ZOOM), (MultiValueMap)headers, HttpStatus.OK);
            }
            try (InputStream mm = PhotographController.class.getClassLoader().getResourceAsStream("META-INF/resources/img/mysteryman.png");){
                headers.set("Content-Type", "image/png");
                ResponseEntity responseEntity = new ResponseEntity((Object)Avatar.process((InputStream)mm, (String)"image/png", (int)size), (MultiValueMap)headers, HttpStatus.OK);
                return responseEntity;
            }
        }
        throw BennuCoreDomainException.resourceNotFound((String)username);
    }

    @RequestMapping(value={"{size}/{username:.+}"})
    public ResponseEntity<byte[]> getWithSize(@PathVariable String username, @PathVariable Integer size, @RequestHeader(value="If-None-Match", required=false) String ifNoneMatch) throws IOException {
        return this.get(username, size, ifNoneMatch);
    }
}

