/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.person;

import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.awt.color.CMMException;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Base64;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.academic.util.FileUtils;

public class PhotographUploadBean
implements Serializable {
    private static final long serialVersionUID = 1207257680390113173L;
    private static final int OUTPUT_PHOTO_WIDTH = 100;
    private static final int OUTPUT_PHOTO_HEIGHT = 100;
    private transient byte[] rawContents;
    private transient byte[] compressedContents;
    private File temporaryFile;
    private File tempCompressedFile;
    private String filename;
    private String contentType;
    private String base64RawThumbnail;
    private String base64RawContent;
    private String username;

    public InputStream getFileInputStream() throws FileNotFoundException {
        if (this.base64RawContent != null && this.base64RawThumbnail != null) {
            this.rawContents = BaseEncoding.base64().decode((CharSequence)this.base64RawContent);
            this.compressedContents = BaseEncoding.base64().decode((CharSequence)this.base64RawThumbnail);
            return new ByteArrayInputStream(this.rawContents);
        }
        if (this.rawContents != null) {
            return new ByteArrayInputStream(this.rawContents);
        }
        if (this.temporaryFile != null) {
            return new FileInputStream(this.temporaryFile);
        }
        return null;
    }

    public String getBase64Photo() throws IOException {
        try (InputStream stream = this.getFileInputStream();){
            String string = Base64.getEncoder().encodeToString(ByteStreams.toByteArray((InputStream)stream));
            return string;
        }
    }

    public void setFileInputStream(InputStream inputStream) throws IOException {
        this.rawContents = inputStream != null ? ByteStreams.toByteArray((InputStream)inputStream) : null;
    }

    public String getBase64RawThumbnail() {
        return this.base64RawThumbnail;
    }

    public void setBase64RawThumbnail(String base64RawThumbnail) {
        this.base64RawThumbnail = base64RawThumbnail;
    }

    public String getBase64RawContent() {
        return this.base64RawContent;
    }

    public void setBase64RawContent(String base64RawContent) {
        this.base64RawContent = base64RawContent;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public InputStream getCompressedInputStream() throws FileNotFoundException {
        if (this.compressedContents != null) {
            return new ByteArrayInputStream(this.compressedContents);
        }
        if (this.tempCompressedFile != null) {
            return new FileInputStream(this.tempCompressedFile);
        }
        return null;
    }

    public int getRawSize() {
        return this.rawContents.length;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void createTemporaryFiles() throws IOException {
        this.temporaryFile = this.rawContents != null ? FileUtils.copyToTemporaryFile(new ByteArrayInputStream(this.rawContents)) : null;
        this.tempCompressedFile = this.compressedContents != null ? FileUtils.copyToTemporaryFile(new ByteArrayInputStream(this.compressedContents)) : null;
    }

    public File getTemporaryFile() {
        return this.temporaryFile;
    }

    public File getTempCompressedFile() {
        return this.tempCompressedFile;
    }

    public void deleteTemporaryFiles() {
        if (this.temporaryFile != null) {
            this.temporaryFile.delete();
        }
        if (this.tempCompressedFile != null) {
            this.tempCompressedFile.delete();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void processImage() throws IOException, UnableToProcessTheImage {
        if (this.base64RawContent != null && this.base64RawThumbnail != null) {
            return;
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.rawContents));
            if (image == null) {
                throw new UnableToProcessTheImage();
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            double resizeFactor = Math.min(100.0 / (double)image.getWidth(), 100.0 / (double)image.getHeight());
            if (resizeFactor == 1.0) {
                this.compressedContents = this.rawContents;
            } else {
                AffineTransform tx = new AffineTransform();
                tx.scale(resizeFactor, resizeFactor);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                image = op.filter(image, null);
                ImageWriter writer = ImageIO.getImageWritersByMIMEType(ContentType.getContentType(this.contentType).getMimeType()).next();
                ImageWriteParam param = writer.getDefaultWriteParam();
                if (this.contentType.equals((Object)ContentType.JPG)) {
                    param.setCompressionMode(2);
                    param.setCompressionQuality(1.0f);
                }
                writer.setOutput(ImageIO.createImageOutputStream(outputStream));
                writer.write(null, new IIOImage(image, null, null), param);
                this.compressedContents = outputStream.toByteArray();
            }
        }
        catch (CMMException ex) {
            throw new UnableToProcessTheImage();
        }
    }

    public static class UnableToProcessTheImage
    extends Exception {
        private static final long serialVersionUID = 1728978041377445492L;
    }
}

