/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.accounting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academic.dto.accounting.SelectableEntryBean;
import org.fenixedu.academic.util.Money;
import org.joda.time.YearMonthDay;

public class CreateReceiptBean
implements Serializable {
    private static final long serialVersionUID = -3609194839690577766L;
    private Person person;
    private Party contributorParty;
    private List<SelectableEntryBean> entries;
    private String contributorNumber;
    private Integer year;
    private String contributorName;
    private String contributorAddress;
    private boolean usingContributorParty;

    public CreateReceiptBean() {
        this.setYear(new YearMonthDay().getYear());
    }

    public Party getContributorParty() {
        return this.contributorParty != null ? this.contributorParty : (StringUtils.isEmpty((String)this.contributorNumber) ? null : Party.readByContributorNumber(this.contributorNumber));
    }

    public void setContributorParty(Party contributorParty) {
        this.contributorParty = contributorParty;
        if (contributorParty != null) {
            this.contributorName = contributorParty.getName();
            this.contributorNumber = contributorParty.getSocialSecurityNumber();
            this.contributorAddress = contributorParty.getAddress() + (!StringUtils.isEmpty((String)contributorParty.getAreaCode()) ? contributorParty.getAreaCode() + " " + contributorParty.getAreaOfAreaCode() : null);
        }
    }

    public boolean isUsingContributorParty() {
        return this.usingContributorParty;
    }

    public void setUsingContributorParty(boolean usingContributorParty) {
        this.usingContributorParty = usingContributorParty;
    }

    public PartySocialSecurityNumber getContributorPartySocialSecurityNumber() {
        return this.contributorParty != null ? this.contributorParty.getPartySocialSecurityNumber() : null;
    }

    public void setContributorPartySocialSecurityNumber(PartySocialSecurityNumber partySocialSecurityNumber) {
        this.contributorParty = partySocialSecurityNumber != null ? partySocialSecurityNumber.getParty() : null;
    }

    public void setPerson(Person person) {
        this.person = person;
        this.setContributorParty((Party)((Object)this.person));
    }

    public Person getPerson() {
        return this.person;
    }

    public List<SelectableEntryBean> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SelectableEntryBean> entries) {
        this.entries = entries;
    }

    public String getContributorNumber() {
        return StringUtils.isEmpty((String)this.contributorNumber) && this.person != null ? this.person.getSocialSecurityNumber() : this.contributorNumber;
    }

    public void setContributorNumber(String contributorNumber) {
        this.contributorNumber = contributorNumber;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getContributorName() {
        return this.contributorName;
    }

    public void setContributorName(String contributorName) {
        this.contributorName = contributorName;
    }

    public String getContributorAddress() {
        return this.contributorAddress;
    }

    public void setContributorAddress(String contributorAddress) {
        this.contributorAddress = contributorAddress;
    }

    public List<Entry> getSelectedEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (SelectableEntryBean selectableEntryBean : this.getEntries()) {
            if (!selectableEntryBean.isSelected()) continue;
            result.add(selectableEntryBean.getEntry());
        }
        return result;
    }

    public Money getTotalAmount() {
        Money result = Money.ZERO;
        for (Entry entry : this.getSelectedEntries()) {
            result = result.add(entry.getAmountWithAdjustment());
        }
        return result;
    }
}

