/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reimbursementGuide;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.reimbursementGuide.ReimbursementGuideSituation;
import org.fenixedu.academic.domain.reimbursementGuide.ReimbursementGuide_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.YearMonthDay;

public class ReimbursementGuide
extends ReimbursementGuide_Base {
    static final Comparator<ReimbursementGuide> NUMBER_COMPARATOR = new BeanComparator("number");

    public ReimbursementGuide() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Calendar getCreationDate() {
        if (this.getCreation() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getCreation());
            return result;
        }
        return null;
    }

    public void setCreationDate(Calendar creationDate) {
        if (creationDate != null) {
            this.setCreation(creationDate.getTime());
        } else {
            this.setCreation(null);
        }
    }

    public ReimbursementGuideSituation getActiveReimbursementGuideSituation() {
        return (ReimbursementGuideSituation)((Object)CollectionUtils.find((Collection)this.getReimbursementGuideSituationsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object obj) {
                ReimbursementGuideSituation situation = (ReimbursementGuideSituation)((Object)obj);
                return situation.getState().getState().equals(1);
            }
        }));
    }

    public static Integer generateReimbursementGuideNumber() {
        Set reimbursementGuides = Bennu.getInstance().getReimbursementGuidesSet();
        return reimbursementGuides.isEmpty() ? Integer.valueOf(1) : Collections.max(reimbursementGuides, NUMBER_COMPARATOR).getNumber() + 1;
    }

    public boolean isPayed() {
        return this.getActiveReimbursementGuideSituation().isPayed();
    }

    @Deprecated
    public Date getCreation() {
        YearMonthDay ymd = this.getCreationYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setCreation(Date date) {
        if (date == null) {
            this.setCreationYearMonthDay(null);
        } else {
            this.setCreationYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }
}

