/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.conclusion;

import java.math.BigDecimal;
import java.util.Comparator;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcessBean;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcess_Base;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdConclusionProcess
extends PhdConclusionProcess_Base {
    public static final Comparator<PhdConclusionProcess> VERSION_COMPARATOR = new Comparator<PhdConclusionProcess>(){

        @Override
        public int compare(PhdConclusionProcess o1, PhdConclusionProcess o2) {
            return o1.getVersion().compareTo(o2.getVersion()) * -1;
        }
    };

    protected PhdConclusionProcess() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected PhdConclusionProcess(PhdConclusionProcessBean conclusionProcessBean, Person responsible) {
        this();
        this.init(conclusionProcessBean, responsible);
    }

    protected void init(PhdConclusionProcessBean conclusionProcessBean, Person responsible) {
        PhdIndividualProgramProcess process2 = conclusionProcessBean.getPhdIndividualProgramProcess();
        LocalDate conclusionDate = conclusionProcessBean.getConclusionDate();
        PhdThesisFinalGrade grade = conclusionProcessBean.getGrade();
        BigDecimal thesisEctsCredits = conclusionProcessBean.getThesisEctsCredits();
        BigDecimal studyPlanEctsCredits = conclusionProcessBean.getStudyPlanEctsCredits();
        if (!process2.isConcluded()) {
            throw new DomainException("error.phd.PhdConclusionProcess.process.is.not.concluded", new String[0]);
        }
        if (responsible == null) {
            throw new DomainException("error.phd.PhdConclusionProcess.responsible.is.required", new String[0]);
        }
        if (conclusionDate == null) {
            throw new DomainException("error.phd.PhdConclusionProcess.conclusionDate.is.required", new String[0]);
        }
        if (grade == null) {
            throw new DomainException("error.phd.PhdConclusionProcess.grade.is.required", new String[0]);
        }
        if (process2.getRegistration() != null && !process2.getRegistration().getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).isConclusionProcessed()) {
            throw new DomainException("error.phd.PhdConclusionProcess.registration.must.be.concluded.first", new String[0]);
        }
        if (thesisEctsCredits == null) {
            throw new DomainException("error.phd.PhdConclusionProcess.thesisEctsCredits.is.required", new String[0]);
        }
        if (!process2.getCandidacyProcess().isStudyPlanExempted() && studyPlanEctsCredits == null) {
            throw new DomainException("error.phd.PhdConclusionProcess.studyPlanEctsCredits.is.required", new String[0]);
        }
        this.setResponsible(responsible);
        this.setConclusionDate(conclusionDate);
        this.setVersion(process2.getLastConclusionProcess() != null ? process2.getLastConclusionProcess().getVersion() + 1 : 1);
        this.setPhdProcess(process2);
        this.setWhenCreated(new DateTime());
        this.setFinalGrade(grade);
        this.setThesisEctsCredits(thesisEctsCredits);
        this.setStudyPlanEctsCredits(studyPlanEctsCredits);
    }

    public static PhdConclusionProcess create(PhdConclusionProcessBean conclusionProcessBean, Person responsible) {
        return new PhdConclusionProcess(conclusionProcessBean, responsible);
    }

    public BigDecimal getTotalEctsCredits() {
        if (this.getPhdProcess().getCandidacyProcess().isStudyPlanExempted()) {
            return this.getThesisEctsCredits();
        }
        return this.getThesisEctsCredits().add(this.getStudyPlanEctsCredits());
    }
}

