/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.mobility.outbound;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$addExecutionDegreeService;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$addMobilityCoordinatorService;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$concludeCandidateNotification;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$concludeCandidateSelection;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$removeExecutionDegreeService;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$removeMobilityCoordinatorService;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$revertConcludeCandidateNotification;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$revertConcludeCandidateSelection;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$selectCandidates;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup$callable$setGrades;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup_Base;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmissionGrade;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OutboundMobilityCandidacyContestGroup
extends OutboundMobilityCandidacyContestGroup_Base
implements Comparable<OutboundMobilityCandidacyContestGroup> {
    private static final Logger logger;
    public static final Advice advice$addExecutionDegreeService;
    public static final Advice advice$removeExecutionDegreeService;
    public static final Advice advice$addMobilityCoordinatorService;
    public static final Advice advice$removeMobilityCoordinatorService;
    public static final Advice advice$setGrades;
    public static final Advice advice$selectCandidates;
    public static final Advice advice$concludeCandidateSelection;
    public static final Advice advice$revertConcludeCandidateSelection;
    public static final Advice advice$concludeCandidateNotification;
    public static final Advice advice$revertConcludeCandidateNotification;

    public OutboundMobilityCandidacyContestGroup(OutboundMobilityCandidacyContest contest, Set<ExecutionDegree> executionDegrees) {
        if (contest == null) {
            throw new NullPointerException("error.OutboundMobilityCandidacyContestGroup.must.have.contest");
        }
        if (executionDegrees.isEmpty()) {
            throw new NullPointerException("error.OutboundMobilityCandidacyContestGroup.must.have.execution.degree");
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.addOutboundMobilityCandidacyContest(contest);
        this.getExecutionDegreeSet().addAll(executionDegrees);
        this.getOutboundMobilityCandidacyContestSet().size();
        this.getExecutionDegreeSet().size();
    }

    public OutboundMobilityCandidacyContestGroup(Set<ExecutionDegree> executionDegrees) {
        if (executionDegrees.isEmpty()) {
            throw new NullPointerException("error.OutboundMobilityCandidacyContestGroup.must.have.execution.degree");
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.getExecutionDegreeSet().addAll(executionDegrees);
        this.getOutboundMobilityCandidacyContestSet().size();
        this.getExecutionDegreeSet().size();
    }

    @Override
    public int compareTo(OutboundMobilityCandidacyContestGroup o) {
        int dc = this.getDescription().compareTo(o.getDescription());
        return dc == 0 ? this.getExternalId().compareTo(o.getExternalId()) : dc;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        for (ExecutionDegree executionDegree : this.getSortedExecutionDegrees()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(executionDegree.getDegree().getSigla());
        }
        return builder.toString();
    }

    public SortedSet<ExecutionDegree> getSortedExecutionDegrees() {
        TreeSet<ExecutionDegree> result = new TreeSet<ExecutionDegree>(ExecutionDegree.COMPARATOR_BY_DEGREE_CODE);
        result.addAll(this.getExecutionDegreeSet());
        return result;
    }

    public void addExecutionDegreeService(ExecutionDegree executionDegree) {
        Object object = advice$addExecutionDegreeService.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$addExecutionDegreeService(this, executionDegree));
    }

    static /* synthetic */ void advised$addExecutionDegreeService(OutboundMobilityCandidacyContestGroup this_, ExecutionDegree executionDegree) {
        this_.addExecutionDegree(executionDegree);
    }

    public void removeExecutionDegreeService(ExecutionDegree executionDegree) {
        Object object = advice$removeExecutionDegreeService.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$removeExecutionDegreeService(this, executionDegree));
    }

    static /* synthetic */ void advised$removeExecutionDegreeService(OutboundMobilityCandidacyContestGroup this_, ExecutionDegree executionDegree) {
        this_.removeExecutionDegree(executionDegree);
    }

    public void addMobilityCoordinatorService(Person person) {
        Object object = advice$addMobilityCoordinatorService.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$addMobilityCoordinatorService(this, person));
    }

    static /* synthetic */ void advised$addMobilityCoordinatorService(OutboundMobilityCandidacyContestGroup this_, Person person) {
        this_.addMobilityCoordinator(person);
    }

    public void removeMobilityCoordinatorService(Person person) {
        Object object = advice$removeMobilityCoordinatorService.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$removeMobilityCoordinatorService(this, person));
    }

    static /* synthetic */ void advised$removeMobilityCoordinatorService(OutboundMobilityCandidacyContestGroup this_, Person person) {
        this_.removeMobilityCoordinator(person);
    }

    public static OutboundMobilityCandidacyContestGroup findOrCreateGroup(ExecutionDegree executionDegree) {
        for (OutboundMobilityCandidacyContestGroup mobilityGroup : executionDegree.getOutboundMobilityCandidacyContestGroupSet()) {
            if (mobilityGroup.getExecutionDegreeSet().size() != 1) continue;
            return mobilityGroup;
        }
        return new OutboundMobilityCandidacyContestGroup(Collections.singleton(executionDegree));
    }

    public void delete() {
        this.getExecutionDegreeSet().clear();
        this.getMobilityCoordinatorSet().clear();
        for (OutboundMobilityCandidacyContest contest : this.getOutboundMobilityCandidacyContestSet()) {
            contest.delete();
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public boolean handles(Degree degree) {
        for (ExecutionDegree executionDegree : this.getExecutionDegreeSet()) {
            if (executionDegree.getDegree() != degree) continue;
            return true;
        }
        return false;
    }

    public Spreadsheet getCandidatesInformationSpreadSheet(OutboundMobilityCandidacyPeriod period) {
        String filename = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.mobility.candidates.information.filename", (String[])new String[0]);
        Spreadsheet spreadsheetCurricularInfo = new Spreadsheet(filename);
        Spreadsheet spreadsheetOptions = spreadsheetCurricularInfo.addSpreadsheet(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.mobility.candidates.options", (String[])new String[0]));
        Spreadsheet spreadsheetContactInformation = spreadsheetOptions.addSpreadsheet(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.contact.information", (String[])new String[0]));
        Spreadsheet spreadsheetOtherCurricularInfo = spreadsheetOptions.addSpreadsheet(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.other.curricular.info", (String[])new String[0]));
        HashSet<Registration> processed = new HashSet<Registration>();
        for (OutboundMobilityCandidacyContest contest : this.getOutboundMobilityCandidacyContestSet()) {
            for (OutboundMobilityCandidacy candidacy : contest.getOutboundMobilityCandidacySet()) {
                OutboundMobilityCandidacySubmission submission = candidacy.getOutboundMobilityCandidacySubmission();
                Registration registration = submission.getRegistration();
                OutboundMobilityCandidacySubmission.Calculator calculator = new OutboundMobilityCandidacySubmission.Calculator(registration.getStudent());
                if (processed.contains((Object)registration)) continue;
                Person person = registration.getPerson();
                Spreadsheet.Row row = spreadsheetCurricularInfo.addRow();
                BigDecimal candidacyGrade = submission.getGrade(this);
                row.setCell(this.getString("label.username"), person.getUsername());
                row.setCell(this.getString("label.name"), person.getName());
                row.setCell(this.getString("label.degree"), registration.getDegree().getSigla());
                row.setCell(this.getString("label.candidate.classification"), candidacyGrade == null ? "" : candidacyGrade.toString());
                row.setCell(this.getString("label.ects.first.cycle"), calculator.completedECTSCycle1.toString());
                row.setCell(this.getString("label.ects.average"), calculator.getEctsAverage().toString());
                row.setCell(this.getString("label.ects.average.first.and.second.cycle"), calculator.getEctsEverateFirstAndSecondCycle().toString());
                row.setCell(this.getString("label.ects.completed"), calculator.completedECTS.toString());
                row.setCell(this.getString("label.ects.enrolled"), calculator.enrolledECTS.toString());
                for (Registration otherRegistration : registration.getStudent().getRegistrationsSet()) {
                    Spreadsheet.Row rowOCI = spreadsheetOtherCurricularInfo.addRow();
                    ICurriculum curriculumOther = otherRegistration.getCurriculum();
                    rowOCI.setCell(this.getString("label.username"), person.getUsername());
                    rowOCI.setCell(this.getString("label.name"), person.getName());
                    rowOCI.setCell(this.getString("label.degree"), otherRegistration.getDegree().getSigla());
                    rowOCI.setCell(this.getString("label.curricular.year"), curriculumOther.getCurricularYear());
                    rowOCI.setCell(this.getString("label.ects.completed.degree"), curriculumOther.getSumEctsCredits().toString());
                    rowOCI.setCell(this.getString("label.average.degree"), curriculumOther.getRawGrade().getValue());
                    this.fillCycleDetails(rowOCI, CycleType.FIRST_CYCLE, otherRegistration, this.getString("label.ects.completed.cycle.first"), this.getString("label.average.cycle.first"));
                    this.fillCycleDetails(rowOCI, CycleType.SECOND_CYCLE, otherRegistration, this.getString("label.ects.completed.cycle.second"), this.getString("label.average.cycle.second"));
                }
                for (OutboundMobilityCandidacy c : submission.getSortedOutboundMobilityCandidacySet()) {
                    OutboundMobilityCandidacyContest contestFromCandidacy = c.getOutboundMobilityCandidacyContest();
                    MobilityAgreement mobilityAgreement = contestFromCandidacy.getMobilityAgreement();
                    UniversityUnit unit = mobilityAgreement.getUniversityUnit();
                    Country country = unit.getCountry();
                    Spreadsheet.Row row2 = spreadsheetOptions.addRow();
                    row2.setCell(this.getString("label.username"), person.getUsername());
                    row2.setCell(this.getString("label.preference.order"), c.getPreferenceOrder());
                    row2.setCell(this.getString("label.degrees"), contestFromCandidacy.getOutboundMobilityCandidacyContestGroup().getDescription());
                    row2.setCell(this.getString("label.mobility.program"), mobilityAgreement.getMobilityProgram().getRegistrationProtocol().getDescription().getContent());
                    row2.setCell(this.getString("label.country"), country == null ? "" : country.getName());
                    row2.setCell(this.getString("label.university"), unit.getPresentationName());
                }
                Spreadsheet.Row contactRow = spreadsheetContactInformation.addRow();
                contactRow.setCell(this.getString("label.username"), person.getUsername());
                contactRow.setCell(this.getString("label.name"), person.getName());
                contactRow.setCell(this.getString("label.email"), person.getEmailForSendingEmails());
                contactRow.setCell(this.getString("label.phone"), person.getDefaultPhoneNumber());
                contactRow.setCell(this.getString("label.mobile"), person.getDefaultMobilePhoneNumber());
                processed.add(registration);
            }
        }
        return spreadsheetCurricularInfo;
    }

    public void fillCandidateOptions(Spreadsheet spreadsheet, OutboundMobilityCandidacyPeriod period) {
    }

    void fillCycleDetails(Spreadsheet.Row row, CycleType cycleType, Registration registration, String header1, String header2) {
        if (this.isForCycle(cycleType, registration)) {
            ICurriculum curriculum = registration.getCurriculum(cycleType);
            row.setCell(header1, curriculum.getSumEctsCredits().toString());
            row.setCell(header2, curriculum.getRawGrade().getValue());
        } else {
            row.setCell(header1, "");
            row.setCell(header2, "");
        }
    }

    private boolean isForCycle(CycleType cycleType, Registration registration) {
        for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
            if (studentCurricularPlan.getCycle(cycleType) == null) continue;
            return true;
        }
        return false;
    }

    private String getString(String key) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])new String[0]);
    }

    public void setGrades(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod, String string) {
        Object object = advice$setGrades.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$setGrades(this, outboundMobilityCandidacyPeriod, string));
    }

    static /* synthetic */ void advised$setGrades(OutboundMobilityCandidacyContestGroup this_, OutboundMobilityCandidacyPeriod candidacyPeriod, String contents) {
        StringBuilder problems = new StringBuilder();
        int l = 0;
        for (String line : contents.split("\r?\n")) {
            ++l;
            String[] parts = line.split("\t");
            Person person = Person.findByUsername(parts[0]);
            if (person == null) {
                problems.append(this_.getMessage("error.mobility.outbound.username.not.valid.on.line", this_.truncateDots(parts[0], 12), Integer.toString(l)));
                problems.append("; ");
                continue;
            }
            try {
                BigDecimal grade = new BigDecimal(parts[1]);
                OutboundMobilityCandidacySubmission submission = candidacyPeriod.findSubmissionFor(person);
                submission.setGrade(this_, grade);
            }
            catch (NumberFormatException ex) {
                problems.append(this_.getMessage("error.mobility.outbound.invalid.grade.on.one", this_.truncateDots(parts[1], 4), Integer.toString(l)));
                problems.append("; ");
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                problems.append(this_.getMessage("error.mobility.outbound.invalid.format.on.line", Integer.toString(l)));
                problems.append(".");
                break;
            }
        }
        if (problems.length() > 0) {
            throw new DomainException("error.mobility.outbound.unable.to.set.grades", problems.toString());
        }
    }

    private String getMessage(String key, String ... args) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])args);
    }

    private String truncateDots(String stringToTruncate, int length) {
        return stringToTruncate.length() > length ? stringToTruncate.substring(0, length) + "(...)" : stringToTruncate;
    }

    public boolean areAllStudentsGraded(OutboundMobilityCandidacyPeriod period) {
        for (OutboundMobilityCandidacyContest contest : this.getOutboundMobilityCandidacyContestSet()) {
            for (OutboundMobilityCandidacy candidacy : contest.getOutboundMobilityCandidacySet()) {
                OutboundMobilityCandidacySubmission submission = candidacy.getOutboundMobilityCandidacySubmission();
                if (submission.getOutboundMobilityCandidacyPeriod() != period || this.hasGrade(submission)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasGrade(OutboundMobilityCandidacySubmission submission) {
        for (OutboundMobilityCandidacySubmissionGrade grade : submission.getOutboundMobilityCandidacySubmissionGradeSet()) {
            if (grade.getOutboundMobilityCandidacyContestGroup() != this) continue;
            return true;
        }
        return false;
    }

    public boolean isCandidacySelectionConcluded(OutboundMobilityCandidacyPeriod period) {
        return this.getConcludedCandidateSelectionForPeriodSet().contains(period);
    }

    public boolean isCandidateNotificationConcluded(OutboundMobilityCandidacyPeriod period) {
        return this.getCandidatesNotifiedOfSelectionResultsForPeriodSet().contains(period);
    }

    public boolean areCandidatesNotofiedOfSelectionResults(OutboundMobilityCandidacyPeriod period) {
        return this.getCandidatesNotifiedOfSelectionResultsForPeriodSet().contains(period);
    }

    public boolean haveAllCandidatesConfirmed(OutboundMobilityCandidacyPeriod period) {
        for (OutboundMobilityCandidacyContest contest : this.getOutboundMobilityCandidacyContestSet()) {
            for (OutboundMobilityCandidacy candidacy : contest.getOutboundMobilityCandidacySet()) {
                OutboundMobilityCandidacySubmission submission = candidacy.getSubmissionFromSelectedCandidacy();
                if (submission == null || submission.hasConfirmedPlacement()) continue;
                return false;
            }
        }
        return true;
    }

    public void selectCandidates(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod) {
        Object object = advice$selectCandidates.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$selectCandidates(this, outboundMobilityCandidacyPeriod));
    }

    static /* synthetic */ void advised$selectCandidates(OutboundMobilityCandidacyContestGroup this_, OutboundMobilityCandidacyPeriod period) {
        for (OutboundMobilityCandidacyContest contest : this_.getOutboundMobilityCandidacyContestSet()) {
            if (contest.getOutboundMobilityCandidacyPeriod() != period) continue;
            for (OutboundMobilityCandidacy candidacy : contest.getOutboundMobilityCandidacySet()) {
                OutboundMobilityCandidacySubmission submission = candidacy.getSubmissionFromSelectedCandidacy();
                if (submission == null) continue;
                candidacy.unselect();
            }
        }
        TreeSet<OutboundMobilityCandidacySubmissionGrade> grades = new TreeSet<OutboundMobilityCandidacySubmissionGrade>();
        this_.collectGradesForGroup(grades, period);
        for (OutboundMobilityCandidacyContestGroup otherGroup : this_.getRootDomainObject().getOutboundMobilityCandidacyContestGroupSet()) {
            if (otherGroup == this_ || !this_.intersect(otherGroup)) continue;
            otherGroup.collectGradesForGroup(grades, period);
        }
        for (OutboundMobilityCandidacySubmissionGrade submissionGrade : grades) {
            logger.info("Selecting for: " + submissionGrade.getOutboundMobilityCandidacySubmission().getRegistration().getPerson().getUsername());
            BigDecimal grade = submissionGrade.getGrade();
            if (grade.signum() != 1) continue;
            submissionGrade.getOutboundMobilityCandidacySubmission().select();
        }
    }

    private void unselectCandidates(OutboundMobilityCandidacyPeriod period) {
        for (OutboundMobilityCandidacyContest contest : this.getOutboundMobilityCandidacyContestSet()) {
            if (contest.getOutboundMobilityCandidacyPeriod() != period) continue;
            for (OutboundMobilityCandidacy candidacy : contest.getOutboundMobilityCandidacySet()) {
                OutboundMobilityCandidacySubmission submission = candidacy.getSubmissionFromSelectedCandidacy();
                if (submission == null) continue;
                candidacy.unselect();
            }
        }
    }

    private boolean intersect(OutboundMobilityCandidacyContestGroup otherGroup) {
        return CollectionUtils.containsAny((Collection)this.getExecutionDegreeSet(), (Collection)otherGroup.getExecutionDegreeSet());
    }

    private void collectGradesForGroup(SortedSet<OutboundMobilityCandidacySubmissionGrade> grades, OutboundMobilityCandidacyPeriod period) {
        for (OutboundMobilityCandidacySubmissionGrade submissionGrade : this.getOutboundMobilityCandidacySubmissionGradeSet()) {
            OutboundMobilityCandidacySubmission submission = submissionGrade.getOutboundMobilityCandidacySubmission();
            if (submission.getOutboundMobilityCandidacyPeriod() != period) continue;
            grades.add(submissionGrade);
        }
    }

    public void concludeCandidateSelection(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod) {
        Object object = advice$concludeCandidateSelection.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$concludeCandidateSelection(this, outboundMobilityCandidacyPeriod));
    }

    static /* synthetic */ void advised$concludeCandidateSelection(OutboundMobilityCandidacyContestGroup this_, OutboundMobilityCandidacyPeriod period) {
        this_.addConcludedCandidateSelectionForPeriod(period);
    }

    public void revertConcludeCandidateSelection(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod) {
        Object object = advice$revertConcludeCandidateSelection.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$revertConcludeCandidateSelection(this, outboundMobilityCandidacyPeriod));
    }

    static /* synthetic */ void advised$revertConcludeCandidateSelection(OutboundMobilityCandidacyContestGroup this_, OutboundMobilityCandidacyPeriod period) {
        this_.removeConcludedCandidateSelectionForPeriod(period);
    }

    public void concludeCandidateNotification(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod) {
        Object object = advice$concludeCandidateNotification.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$concludeCandidateNotification(this, outboundMobilityCandidacyPeriod));
    }

    static /* synthetic */ void advised$concludeCandidateNotification(OutboundMobilityCandidacyContestGroup this_, OutboundMobilityCandidacyPeriod period) {
        this_.addCandidatesNotifiedOfSelectionResultsForPeriod(period);
    }

    public void revertConcludeCandidateNotification(OutboundMobilityCandidacyPeriod outboundMobilityCandidacyPeriod) {
        Object object = advice$revertConcludeCandidateNotification.perform((Callable)new OutboundMobilityCandidacyContestGroup$callable$revertConcludeCandidateNotification(this, outboundMobilityCandidacyPeriod));
    }

    static /* synthetic */ void advised$revertConcludeCandidateNotification(OutboundMobilityCandidacyContestGroup this_, OutboundMobilityCandidacyPeriod period) {
        this_.removeCandidatesNotifiedOfSelectionResultsForPeriod(period);
    }

    static {
        advice$addExecutionDegreeService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeExecutionDegreeService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$addMobilityCoordinatorService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeMobilityCoordinatorService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setGrades = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$selectCandidates = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$concludeCandidateSelection = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$revertConcludeCandidateSelection = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$concludeCandidateNotification = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$revertConcludeCandidateNotification = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(OutboundMobilityCandidacyContestGroup.class);
    }
}

