/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.EvenOddRule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.EvenOddRuleVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class EvenOddRule
extends EvenOddRule_Base {
    public EvenOddRule(DegreeModule toApplyRule, CourseGroup contextCourseGroup, Integer semester, AcademicPeriod academicPeriod, Boolean even, ExecutionSemester begin, ExecutionSemester end) {
        this.checkParameters(toApplyRule, semester, academicPeriod, even);
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.EVEN_ODD);
        this.setEven(even);
        this.setCurricularPeriodOrder(semester);
        this.setAcademicPeriod(academicPeriod);
    }

    private void checkParameters(DegreeModule toApplyRule, Integer semester, AcademicPeriod academicPeriod, Boolean even) {
        if (semester == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (even == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (academicPeriod == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (!toApplyRule.isLeaf()) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("label.in", true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>("label.semester." + this.getCurricularPeriodOrder(), true));
        labelList.add(new GenericPair<String, Boolean>(", ", false));
        labelList.add(new GenericPair<String, Boolean>("label.only.students", true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        String evenOdd = this.getEven() != false ? "even" : "odd";
        labelList.add(new GenericPair<String, Boolean>("label." + evenOdd, true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>("label.can.be.enroled", true));
        return labelList;
    }

    protected void removeOwnParameters() {
    }

    public boolean appliesToContext(Context context) {
        return super.appliesToContext(context) && this.appliesToPeriod(context);
    }

    private boolean appliesToPeriod(Context context) {
        return context == null || context.getCurricularPeriod().hasCurricularPeriod(this.getAcademicPeriod(), this.getCurricularPeriodOrder());
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new EvenOddRuleVerifier();
    }

    public String getEvenOddString() {
        return new MultiLanguageString(MultiLanguageString.pt, BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)new Locale("pt", "PT"), (String)("label." + (this.getEven() != false ? "even" : "odd")), (String[])new String[0])).toString();
    }
}

