/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.Callable;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.candidacy.GenericApplication$callable$submitApplication;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation;
import org.fenixedu.academic.domain.candidacy.GenericApplication_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.period.GenericApplicationPeriod;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GenericApplication
extends GenericApplication_Base {
    public static final Comparator<GenericApplication> COMPARATOR_BY_APPLICATION_NUMBER;
    public static final Advice advice$submitApplication;

    public GenericApplication(GenericApplicationPeriod period, String email) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setGenericApplicationPeriod(period);
        this.setApplicationNumber(period.generateApplicationNumber());
        if (email == null || email.isEmpty()) {
            throw new NullPointerException("error.email.cannot.be.null");
        }
        this.setEmail(email);
        this.sendEmailForApplication();
        this.setIdDocumentType(IDDocumentType.IDENTITY_CARD);
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        if (institutionUnit != null) {
            this.setNationality(institutionUnit.getCountry());
        }
    }

    public void sendEmailForApplication() {
        String subject = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.email.subject", (String[])new String[]{this.getGenericApplicationPeriod().getTitle().getContent()});
        String body = BundleUtil.getString((String)"resources.CandidateResources", (String)"label.application.email.body", (String[])new String[]{this.getApplicationNumber(), this.generateConfirmationLink(), this.getGenericApplicationPeriod().getTitle().getContent(), Unit.getInstitutionAcronym()});
        new Message((Sender)((Object)this.getRootDomainObject().getSystemSender()), this.getEmail(), subject, body);
    }

    private String generateConfirmationLink() {
        String confirmationCode = Hashing.sha512().hashString((CharSequence)(this.getEmail() + System.currentTimeMillis() + this.hashCode() + new Random(System.currentTimeMillis()).nextGaussian()), Charsets.UTF_8).toString();
        this.setConfirmationCode(confirmationCode);
        return FenixEduAcademicConfiguration.getConfiguration().getGenericApplicationEmailConfirmationLink() + confirmationCode + "&applicationExternalId=" + this.getExternalId();
    }

    public boolean isAllPersonalInformationFilled() {
        return this.getGender() != null && this.getDateOfBirthYearMonthDay() != null && this.getDocumentIdNumber() != null && !this.getDocumentIdNumber().isEmpty() && this.getIdDocumentType() != null && this.getNationality() != null && this.getAddress() != null && !this.getAddress().isEmpty() && this.getAreaCode() != null && !this.getAreaCode().isEmpty() && this.getArea() != null && !this.getArea().isEmpty() && this.getTelephoneContact() != null && !this.getTelephoneContact().isEmpty();
    }

    public int getAvailableGenericApplicationRecomentationCount() {
        int result = 0;
        for (GenericApplicationRecomentation recomentation : this.getGenericApplicationRecomentationSet()) {
            if (recomentation.getLetterOfRecomentation() == null) continue;
            ++result;
        }
        return result;
    }

    public void submitApplication() {
        Object object = advice$submitApplication.perform((Callable)new GenericApplication$callable$submitApplication(this));
    }

    static /* synthetic */ void advised$submitApplication(GenericApplication this_) {
        this_.setSubmitted(true);
    }

    static {
        advice$submitApplication = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_APPLICATION_NUMBER = new Comparator<GenericApplication>(){

            @Override
            public int compare(GenericApplication o1, GenericApplication o2) {
                int n = this.compareAppNumber(o1.getApplicationNumber(), o2.getApplicationNumber());
                return n == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : n;
            }

            private int compareAppNumber(String an1, String an2) {
                int i1 = an1.lastIndexOf(47);
                int i2 = an2.lastIndexOf(47);
                int c = an1.substring(0, i1).compareTo(an2.substring(0, i2));
                return c == 0 ? Integer.valueOf(an1.substring(i1 + 1)).compareTo(Integer.valueOf(an2.substring(i2 + 1))) : c;
            }
        };
    }
}

