/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.events.candidacy.IndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;

public class IndividualCandidacyEventWrapper
implements Wrapper {
    IndividualCandidacyEvent event;

    public IndividualCandidacyEventWrapper(IndividualCandidacyEvent event) {
        this.event = event;
    }

    @Override
    public String getStudentNumber() {
        if (this.event.getPerson().getStudent() != null) {
            return this.event.getPerson().getStudent().getNumber().toString();
        }
        return "--";
    }

    @Override
    public String getStudentName() {
        return this.event.getPerson().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.event.getPerson().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        return "--";
    }

    @Override
    public String getExecutionYear() {
        return this.getForExecutionYear().getName();
    }

    @Override
    public String getDegreeName() {
        return "--";
    }

    @Override
    public String getDegreeType() {
        return "--";
    }

    @Override
    public String getPhdProgramName() {
        return "--";
    }

    @Override
    public String getEnrolledECTS() {
        return "--";
    }

    @Override
    public String getRegime() {
        return "--";
    }

    @Override
    public String getEnrolmentModel() {
        return "--";
    }

    @Override
    public String getResidenceYear() {
        return "--";
    }

    @Override
    public String getResidenceMonth() {
        return "--";
    }

    @Override
    public String getStudiesType() {
        return "--";
    }

    @Override
    public String getTotalDiscount() {
        return this.event.getTotalDiscount().toPlainString();
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return !ExecutionYear.readByDateTime(this.event.getIndividualCandidacy().getCandidacyDate()).isBefore(executionYear);
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        return ExecutionYear.readByDateTime(this.event.getIndividualCandidacy().getCandidacyDate());
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        return this.event.getAdministrativeOffice();
    }

    @Override
    public String getRelatedEventExternalId() {
        return "--";
    }

    @Override
    public String getDebtorFiscalId() {
        return "--";
    }

    @Override
    public String getDebtorName() {
        return "--";
    }
}

