/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentCoordinatorGroup;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="coordinator")
public class CoordinatorGroup
extends FenixGroup {
    private static final long serialVersionUID = 2016819143184891118L;
    @GroupArgument
    private DegreeType degreeType;
    @GroupArgument
    private Degree degree;

    private CoordinatorGroup() {
    }

    private CoordinatorGroup(DegreeType degreeType, Degree degree) {
        this();
        this.degreeType = degreeType;
        this.degree = degree;
    }

    public static CoordinatorGroup get() {
        return new CoordinatorGroup(null, null);
    }

    public static CoordinatorGroup get(DegreeType degreeType) {
        return new CoordinatorGroup(degreeType, null);
    }

    public static CoordinatorGroup get(Degree degree) {
        return new CoordinatorGroup(null, degree);
    }

    public static CoordinatorGroup get(DegreeType degreeType, Degree degree) {
        return new CoordinatorGroup(degreeType, degree);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        ArrayList<String> parts = new ArrayList<String>();
        String connector = "";
        if (this.degreeType != null) {
            parts.add(this.degreeType.getName().getContent());
        }
        if (this.degree != null) {
            parts.add(this.degree.getPresentationName());
        }
        if (!parts.isEmpty()) {
            connector = BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.default", (String[])new String[0]);
        }
        return new String[]{connector, Joiner.on((String)", ").join(parts)};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        if (this.degreeType != null) {
            ExecutionYear year = ExecutionYear.readCurrentExecutionYear();
            for (ExecutionDegree executionDegree : year.getExecutionDegreesSet()) {
                DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
                Degree degree = degreeCurricularPlan.getDegree();
                if (!degree.getDegreeType().equals(this.degreeType)) continue;
                for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                    User user = coordinator.getPerson().getUser();
                    if (user == null) continue;
                    users.add(user);
                }
            }
        }
        if (this.degree != null) {
            users.addAll(CoordinatorGroup.getCoordinators(this.degree));
        }
        if (this.degree == null && this.degreeType == null) {
            ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
            for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
                for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                    User user = coordinator.getPerson().getUser();
                    if (user == null) continue;
                    users.add(user);
                }
            }
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    private static Set<User> getCoordinators(Degree degree) {
        HashSet<User> users = new HashSet<User>();
        for (Coordinator coordinator : degree.getCurrentCoordinators()) {
            User user = coordinator.getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public boolean isMember(User user) {
        if (user == null || user.getPerson().getCoordinatorsSet().isEmpty()) {
            return false;
        }
        for (Coordinator coordinator : user.getPerson().getCoordinatorsSet()) {
            ExecutionDegree executionDegree = coordinator.getExecutionDegree();
            if (!executionDegree.getExecutionYear().isCurrent() || this.degreeType != null && this.degreeType != executionDegree.getDegree().getDegreeType() || this.degree != null && !executionDegree.getDegree().equals(this.degree)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentCoordinatorGroup.getInstance(this.degreeType, this.degree);
    }

    public boolean equals(Object object) {
        if (object instanceof CoordinatorGroup) {
            CoordinatorGroup other = (CoordinatorGroup)((Object)object);
            return Objects.equal((Object)this.degreeType, (Object)other.degreeType) && Objects.equal((Object)this.degree, (Object)other.degree);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.degreeType, this.degree});
    }
}

