/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.GratuitySituation_Base;
import org.fenixedu.academic.domain.GratuityValues;
import org.fenixedu.academic.domain.PaymentPhase;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonAccount;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.GratuitySituationPaymentCode;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurricularPlan.Specialization;
import org.fenixedu.academic.domain.transactions.GratuityTransaction;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.domain.transactions.TransactionType;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class GratuitySituation
extends GratuitySituation_Base {
    private static final BigDecimal PENALTY_PERCENTAGE = new BigDecimal("0.01");

    public GratuitySituation() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public GratuitySituation(GratuityValues gratuityValues, StudentCurricularPlan studentCurricularPlan) {
        this();
        this.setGratuityValues(gratuityValues);
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setWhenDateTime(new DateTime());
        this.updateValues();
    }

    public void delete() {
        this.setStudentCurricularPlan(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void updateValues() {
        this.updateTotalValue();
        this.updateRemainingValue();
    }

    private void updateTotalValue() {
        super.setTotalValue(Double.valueOf(this.calculateTotalAmountWithPenalty()));
    }

    private double calculateTotalAmountWithPenalty() {
        return this.calculateOriginalTotalValue() + this.calculatePenalty(this.calculateOriginalTotalValue());
    }

    private double calculateOriginalTotalValue() {
        double totalValue = 0.0;
        Specialization specialization = this.getStudentCurricularPlan().getSpecialization();
        if (specialization.equals((Object)Specialization.STUDENT_CURRICULAR_PLAN_SPECIALIZATION)) {
            totalValue = this.getGratuityValues().calculateTotalValueForSpecialization(this.getStudentCurricularPlan());
        } else if (specialization.equals((Object)Specialization.STUDENT_CURRICULAR_PLAN_MASTER_DEGREE)) {
            totalValue = this.getGratuityValues().calculateTotalValueForMasterDegree();
        }
        return totalValue;
    }

    private void updateRemainingValue() {
        super.setRemainingValue(Double.valueOf(this.getTotalValue() - this.calculatePayedValue() - this.calculateExemptionValue()));
    }

    private double calculateExemptionValue() {
        double exemptionValue = 0.0;
        if (this.getExemptionPercentage() != null) {
            exemptionValue = this.getTotalValue() * (this.getExemptionPercentage().doubleValue() / 100.0);
        }
        if (this.getExemptionValue() != null) {
            exemptionValue += this.getExemptionValue().doubleValue();
        }
        return exemptionValue;
    }

    public double calculatePayedValue() {
        return this.calculatePayedValue(null);
    }

    public double calculatePayedValue(YearMonthDay date) {
        Collection<Object> transactions = date == null ? this.getTransactionListSet() : this.getTransactionsUntil(date);
        BigDecimal result = BigDecimal.ZERO;
        for (GratuityTransaction gratuityTransaction : transactions) {
            result = result.add(gratuityTransaction.getValueWithAdjustment());
        }
        return result.doubleValue();
    }

    private List<GratuityTransaction> getTransactionsUntil(YearMonthDay date) {
        ArrayList<GratuityTransaction> result = new ArrayList<GratuityTransaction>();
        for (GratuityTransaction gratuityTransaction : this.getTransactionListSet()) {
            if (gratuityTransaction.getTransactionDateDateTime().toYearMonthDay().compareTo((ReadablePartial)date) > 0) continue;
            result.add(gratuityTransaction);
        }
        return result;
    }

    public GratuitySituationPaymentCode calculatePaymentCode() {
        this.updateValues();
        if (!this.hasPaymentCode()) {
            this.createPaymentCode();
        } else {
            this.updatePaymentCode();
        }
        return super.getPaymentCode();
    }

    private void updatePaymentCode() {
        super.getPaymentCode().update(new YearMonthDay(), this.calculatePaymentCodeEndDate(), new Money(this.getRemainingValue()), new Money(this.getRemainingValue()));
    }

    private void createPaymentCode() {
        GratuitySituationPaymentCode.create(PaymentCodeType.PRE_BOLONHA_MASTER_DEGREE_TOTAL_GRATUITY, new YearMonthDay(), this.calculatePaymentCodeEndDate(), new Money(this.getRemainingValue()), new Money(this.getRemainingValue()), this.getStudent(), this);
    }

    private Student getStudent() {
        return this.getStudentCurricularPlan().getRegistration().getStudent();
    }

    private Person getPerson() {
        return this.getStudent().getPerson();
    }

    public GratuitySituationPaymentCode getPaymentCode() {
        throw new DomainException("error.GratuitySituation.paymentCode.cannot.be.accessed.directly", new String[0]);
    }

    public boolean hasPaymentCode() {
        return super.getPaymentCode() != null;
    }

    private double calculatePenalty(double remainingValue) {
        if (this.hasPenalty() && this.getGratuityValues().isPenaltyApplicable()) {
            int monthsToChargePenalty = 0;
            YearMonthDay now = new YearMonthDay();
            monthsToChargePenalty = this.getEndPaymentDate().getMonthOfYear() == now.getMonthOfYear() ? ++monthsToChargePenalty : this.calculateMonthsToChargePenalty(this.calculateCloseDate());
            return new Money(remainingValue).multiply(PENALTY_PERCENTAGE).multiply(new BigDecimal(monthsToChargePenalty)).getAmount().doubleValue();
        }
        return 0.0;
    }

    private int calculateMonthsToChargePenalty(YearMonthDay when) {
        YearMonthDay endPaymentDate = this.getEndPaymentDate();
        YearMonthDay endOfMonth = endPaymentDate.plusMonths(1).withDayOfMonth(1).minusDays(1);
        int numberOfDaysLeftInMonth = new Period((ReadablePartial)endPaymentDate, (ReadablePartial)endOfMonth).getDays();
        int monthsToChargePenalty = 0;
        if (numberOfDaysLeftInMonth > 0) {
            ++monthsToChargePenalty;
        }
        Period period = new Period((ReadablePartial)endPaymentDate.plusMonths(1).withDayOfMonth(1), (ReadablePartial)when);
        return monthsToChargePenalty += period.getMonths() + 1;
    }

    private YearMonthDay calculateCloseDate() {
        for (GratuityTransaction transaction : this.getTransactionListSet()) {
            if (!this.canClose(transaction.getTransactionDateDateTime().toYearMonthDay())) continue;
            return transaction.getTransactionDateDateTime().toYearMonthDay();
        }
        return new YearMonthDay();
    }

    private boolean canClose(YearMonthDay when) {
        if (this.calculatePayedAmountUntil(when) > this.calculateOriginalValueWithExemption()) {
            return true;
        }
        int monthsToChargePenalty = this.calculateMonthsToChargePenalty(when);
        double penaltyAmount = new Money(this.calculateOriginalValueWithExemption()).multiply(PENALTY_PERCENTAGE).multiply(new BigDecimal(monthsToChargePenalty)).getAmount().doubleValue();
        return this.calculatePayedAmountUntil(when) > penaltyAmount + this.calculateOriginalValueWithExemption();
    }

    private double calculatePayedAmountUntil(YearMonthDay endDate) {
        Money result = Money.ZERO;
        DateTime limit = endDate.toDateTimeAtMidnight().plusDays(1).minusMinutes(1);
        for (GratuityTransaction transaction : this.getTransactionListSet()) {
            if (transaction.getTransactionDateDateTime().isAfter((ReadableInstant)limit)) continue;
            result = result.add(transaction.getValueWithAdjustment());
        }
        return result.getAmount().doubleValue();
    }

    private boolean hasPenalty() {
        if (!this.getHasPenaltyExemption().booleanValue() && new YearMonthDay().isAfter((ReadablePartial)this.getEndPaymentDate())) {
            double payedValue = this.calculatePayedValue(this.getEndPaymentDate());
            return payedValue < this.calculateOriginalValueWithExemption();
        }
        return false;
    }

    private double calculateOriginalValueWithExemption() {
        return this.calculateOriginalTotalValue() - this.calculateExemptionValue();
    }

    public Boolean getHasPenaltyExemption() {
        return super.getHasPenaltyExemption() != null && super.getHasPenaltyExemption() != false;
    }

    private YearMonthDay calculatePaymentCodeEndDate() {
        YearMonthDay now = new YearMonthDay();
        YearMonthDay endPaymentDate = this.getEndPaymentDate();
        return now.isAfter((ReadablePartial)endPaymentDate) ? this.calculateNextEndDate(now) : endPaymentDate;
    }

    protected YearMonthDay calculateNextEndDate(YearMonthDay yearMonthDay) {
        YearMonthDay nextMonth = yearMonthDay.plusMonths(1);
        return new YearMonthDay(nextMonth.getYear(), nextMonth.getMonthOfYear(), 1).minusDays(1);
    }

    private boolean isPayedUsingPhases() {
        return !this.getGratuityValues().getPaymentPhaseListSet().isEmpty();
    }

    private YearMonthDay getEndPaymentDate() {
        if (this.isPayedUsingPhases()) {
            YearMonthDay lastPaymentPhaseDate = this.getLastPaymentPhaseDate();
            if (this.getGratuityValues().getEndPaymentYearMonthDay() == null) {
                return lastPaymentPhaseDate;
            }
            return lastPaymentPhaseDate.isAfter((ReadablePartial)this.getGratuityValues().getEndPaymentYearMonthDay()) ? lastPaymentPhaseDate : this.getGratuityValues().getEndPaymentYearMonthDay();
        }
        if (this.getGratuityValues().getEndPaymentYearMonthDay() == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.GratuitySituation.paymentMode.is.not.correctly.defined", new String[0]);
        }
        return this.getGratuityValues().getEndPaymentYearMonthDay();
    }

    private YearMonthDay getLastPaymentPhaseDate() {
        PaymentPhase paymentPhase = this.getGratuityValues().getLastPaymentPhase();
        return paymentPhase == null ? null : paymentPhase.getEndDateYearMonthDay();
    }

    public boolean isPayed() {
        return new Money(this.getRemainingValue()).lessOrEqualThan(Money.ZERO);
    }

    public GratuityTransaction processAmount(Person responsiblePerson, Money amount, DateTime whenRegistered, PaymentType paymentType) {
        GratuityTransaction transaction = new GratuityTransaction(amount.getAmount(), whenRegistered, paymentType, TransactionType.GRATUITY_ADHOC_PAYMENT, responsiblePerson, this.getOrCreatePersonAccount(), this);
        this.updateRemainingValue();
        return transaction;
    }

    private PersonAccount getOrCreatePersonAccount() {
        return this.getPerson().getAssociatedPersonAccount() != null ? this.getPerson().getAssociatedPersonAccount() : new PersonAccount(this.getPerson());
    }

    public void setTotalValue(Double value) {
        throw new DomainException("error.org.fenixedu.academic.domain.GratuitySituation.cannot.modify.value", new String[0]);
    }

    public void setRemainingValue(Double value) {
        throw new DomainException("error.org.fenixedu.academic.domain.GratuitySituation.cannot.modify.value", new String[0]);
    }

    public void editPenaltyExemption(Boolean hasPenaltyExemption, String justification) {
        this.setHasPenaltyExemption(hasPenaltyExemption);
        if (hasPenaltyExemption != null && hasPenaltyExemption.booleanValue()) {
            this.setPenaltyExemptionDate(new YearMonthDay());
            this.setPenaltyExemptionUser(Authenticate.getUser());
            this.setPenaltyExemptionJustification(justification);
        } else {
            this.setPenaltyExemptionDate(null);
            this.setPenaltyExemptionUser(null);
            this.setPenaltyExemptionJustification(null);
        }
    }

    public Money getPayedAmountBetween(DateTime startDate, DateTime endDate) {
        Money result = Money.ZERO;
        for (GratuityTransaction transaction : this.getTransactionListSet()) {
            if (transaction.getTransactionDateDateTime().isBefore((ReadableInstant)startDate) || transaction.getTransactionDateDateTime().isAfter((ReadableInstant)endDate)) continue;
            result = result.add(transaction.getValueWithAdjustment());
        }
        return result;
    }

    @Deprecated
    public Date getWhen() {
        DateTime dt = this.getWhenDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setWhen(Date date) {
        if (date == null) {
            this.setWhenDateTime(null);
        } else {
            this.setWhenDateTime(new DateTime(date.getTime()));
        }
    }
}

