/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.validator;

import java.util.Comparator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.Resources;

public class ValidateCompareTwoFields {
    private static final int VALUE = 11;

    private static boolean validate(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, Comparator comparator) {
        String greaterInputString = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String secondProperty = field.getVarValue("secondProperty");
        String lowerInputString = ValidatorUtils.getValueAsString((Object)bean, (String)secondProperty);
        if (!GenericValidator.isBlankOrNull((String)lowerInputString) && !GenericValidator.isBlankOrNull((String)greaterInputString)) {
            try {
                Double lowerInput = new Double(lowerInputString);
                Double greaterInput = new Double(greaterInputString);
                if (comparator.compare(lowerInput, greaterInput) != 11) {
                    errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                errors.add(field.getKey(), new ActionMessage(va.getMsg()));
                return false;
            }
        }
        return true;
    }

    public static boolean validateGreaterThanOrEqual(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, ServletContext application) {
        return ValidateCompareTwoFields.validate(bean, va, field, errors, request, new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = (Double)o1;
                Double d2 = (Double)o2;
                int result = d1.compareTo(d2);
                if (result <= 0) {
                    result = 11;
                }
                return result;
            }
        });
    }

    public static boolean validateGreaterThan(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, ServletContext application) {
        return ValidateCompareTwoFields.validate(bean, va, field, errors, request, new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = (Double)o1;
                Double d2 = (Double)o2;
                int result = d1.compareTo(d2);
                if (result < 0) {
                    result = 11;
                }
                return result;
            }
        });
    }

    public static boolean validateEqual(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, ServletContext application) {
        return ValidateCompareTwoFields.validate(bean, va, field, errors, request, new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = (Double)o1;
                Double d2 = (Double)o2;
                int result = d1.compareTo(d2);
                if (result == 0) {
                    result = 11;
                }
                return result;
            }
        });
    }

    public static boolean validateLessThan(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, ServletContext application) {
        return ValidateCompareTwoFields.validate(bean, va, field, errors, request, new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = (Double)o1;
                Double d2 = (Double)o2;
                int result = d1.compareTo(d2);
                if (result > 0) {
                    result = 11;
                }
                return result;
            }
        });
    }

    public static boolean validateLessThanOrEqual(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, ServletContext application) {
        return ValidateCompareTwoFields.validate(bean, va, field, errors, request, new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = (Double)o1;
                Double d2 = (Double)o2;
                int result = d1.compareTo(d2);
                if (result >= 0) {
                    result = 11;
                }
                return result;
            }
        });
    }
}

