/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import pt.ist.fenixframework.DomainObject;

public class PhdDocumentsZip
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String ZIP_MIME_TYPE = "application/zip";
    private static Comparator<PhdProgramProcessDocument> COMPARE_BY_DOCUMENT_TYPE_AND_NAME = new Comparator<PhdProgramProcessDocument>(){

        @Override
        public int compare(PhdProgramProcessDocument o1, PhdProgramProcessDocument o2) {
            int result = o1.getDocumentType().compareTo(o2.getDocumentType());
            if (result == 0) {
                result = o1.getFilename().compareTo(o2.getFilename());
            }
            return result != 0 ? result : DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2);
        }
    };
    private final Collection<PhdProgramProcessDocument> documents = new TreeSet<PhdProgramProcessDocument>(COMPARE_BY_DOCUMENT_TYPE_AND_NAME);

    public PhdDocumentsZip add(PhdProgramProcessDocument document) {
        this.documents.add(document);
        return this;
    }

    public PhdDocumentsZip addAll(Collection<PhdProgramProcessDocument> documents) {
        this.documents.addAll(documents);
        return this;
    }

    public byte[] create() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ZipOutputStream zipFile = new ZipOutputStream(result);
        int prefixName = 0;
        for (PhdProgramProcessDocument document : this.documents) {
            this.zipEntry(++prefixName, zipFile, document);
        }
        zipFile.close();
        return result.toByteArray();
    }

    private void zipEntry(int prefixName, ZipOutputStream zipFile, PhdProgramProcessDocument document) throws IOException {
        zipFile.putNextEntry(new ZipEntry(String.format("%s-%s", prefixName, document.getFilename())));
        zipFile.write(document.getContent());
        zipFile.closeEntry();
    }

    public static byte[] zip(Collection<PhdProgramProcessDocument> documents) throws IOException {
        return new PhdDocumentsZip().addAll(documents).create();
    }
}

